/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTProblemHolder;
import org.eclipse.cdt.core.dom.ast.IASTStatement;

public class CFAGenerationRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 6850681425709171716L;

    public CFAGenerationRuntimeException(String msg) {
        super(msg);
    }

    public CFAGenerationRuntimeException(Throwable cause) {
        super(cause.getMessage(), cause);
    }

    public CFAGenerationRuntimeException(String msg, IASTNode astNode) {
        this(astNode == null ? msg : CFAGenerationRuntimeException.createMessage(msg, astNode));
    }

    public CFAGenerationRuntimeException(String msg, org.sosy_lab.cpachecker.cfa.ast.IASTNode astNode) {
        this(astNode == null ? msg : msg + " in line " + astNode.getFileLocation().getStartingLineNumber() + ": " + astNode.toASTString());
    }

    public <P extends IASTProblemHolder & IASTNode> CFAGenerationRuntimeException(P problem) {
        this(CFAGenerationRuntimeException.createMessage(problem.getProblem().getMessage(), problem));
    }

    private static String createMessage(String msg, IASTNode node) {
        IASTNode fullLine;
        for (fullLine = node; fullLine != null && !(fullLine instanceof IASTStatement) && !(fullLine instanceof IASTDeclaration); fullLine = fullLine.getParent()) {
        }
        String rawSignature = node.getRawSignature();
        StringBuilder sb = new StringBuilder();
        if (Strings.isNullOrEmpty((String)msg)) {
            sb.append("Problem");
        } else {
            sb.append(msg);
        }
        sb.append(" in line ");
        sb.append(node.getFileLocation().getStartingLineNumber());
        sb.append(": ");
        sb.append(rawSignature);
        if (fullLine != null && fullLine != node) {
            String lineWithoutWhitespace;
            String lineRawSignature = fullLine.getRawSignature();
            String codeWithoutWhitespace = CharMatcher.WHITESPACE.removeFrom((CharSequence)rawSignature);
            if (!codeWithoutWhitespace.equals(lineWithoutWhitespace = CharMatcher.WHITESPACE.removeFrom((CharSequence)lineRawSignature))) {
                sb.append(" (full line is ");
                sb.append(lineRawSignature);
                sb.append(")");
            }
        }
        return sb.toString();
    }
}

