/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.sosy_lab.cpachecker.cfa.ast.IASTEnumerationSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionTypeSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.CFAGenerationRuntimeException;

class Scope {
    private final LinkedList<Map<String, IASTSimpleDeclaration>> varsStack = Lists.newLinkedList();
    private final LinkedList<Map<String, IASTSimpleDeclaration>> varsList = Lists.newLinkedList();
    private final Map<String, IASTSimpleDeclaration> functions = new HashMap<String, IASTSimpleDeclaration>();
    private String currentFunctionName = null;

    public Scope() {
        this.enterBlock();
    }

    public boolean isGlobalScope() {
        return this.varsStack.size() == 1;
    }

    public void enterFunction(IASTFunctionDeclaration pFuncDef) {
        this.currentFunctionName = pFuncDef.getOrigName();
        this.registerFunctionDeclaration(pFuncDef);
        this.enterBlock();
    }

    public void leaveFunction() {
        Preconditions.checkState((!this.isGlobalScope() ? 1 : 0) != 0);
        this.varsStack.removeLast();
        while (this.varsList.size() > this.varsStack.size()) {
            this.varsList.removeLast();
        }
        this.currentFunctionName = null;
    }

    public void enterBlock() {
        this.varsStack.addLast(new HashMap());
        this.varsList.addLast(this.varsStack.getLast());
    }

    public void leaveBlock() {
        Preconditions.checkState((this.varsStack.size() > 2 ? 1 : 0) != 0);
        this.varsStack.removeLast();
    }

    public boolean variableNameInUse(String name, String origName) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)origName);
        Iterator<Map<String, IASTSimpleDeclaration>> it = this.varsList.descendingIterator();
        while (it.hasNext()) {
            Map<String, IASTSimpleDeclaration> vars = it.next();
            IASTSimpleDeclaration binding = vars.get(origName);
            if (binding != null && binding.getName().equals(name)) {
                return true;
            }
            binding = vars.get(name);
            if (binding == null || !binding.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public IASTSimpleDeclaration lookupVariable(String name) {
        Preconditions.checkNotNull((Object)name);
        Iterator<Map<String, IASTSimpleDeclaration>> it = this.varsStack.descendingIterator();
        while (it.hasNext()) {
            Map<String, IASTSimpleDeclaration> vars = it.next();
            IASTSimpleDeclaration binding = vars.get(name);
            if (binding == null) continue;
            return binding;
        }
        return null;
    }

    public IASTSimpleDeclaration lookupFunction(String name) {
        return this.functions.get(Preconditions.checkNotNull((Object)name));
    }

    public void registerDeclaration(IASTSimpleDeclaration declaration) {
        assert (declaration instanceof IASTVariableDeclaration || declaration instanceof IASTEnumerationSpecifier.IASTEnumerator || declaration instanceof IASTParameterDeclaration) : "Tried to register a declaration which does not define a name in the standard namespace: " + declaration;
        assert (!(declaration.getDeclSpecifier() instanceof IASTFunctionTypeSpecifier));
        String name = declaration.getOrigName();
        assert (name != null);
        Map<String, IASTSimpleDeclaration> vars = this.varsStack.getLast();
        if (vars.containsKey(name) && !this.isGlobalScope()) {
            throw new CFAGenerationRuntimeException("Variable " + name + " already declared", declaration);
        }
        vars.put(name, declaration);
    }

    public void registerFunctionDeclaration(IASTFunctionDeclaration declaration) {
        Preconditions.checkState((boolean)this.isGlobalScope(), (Object)"nested functions not allowed");
        String name = declaration.getName();
        assert (name != null);
        if (this.functions.containsKey(name)) {
            // empty if block
        }
        this.functions.put(name, declaration);
    }

    public String getCurrentFunctionName() {
        return this.currentFunctionName;
    }

    public String toString() {
        return "Functions: " + Joiner.on((char)' ').join(this.functions.keySet());
    }
}

