/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cmdline;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.configuration.converters.FileTypeConverter;
import org.sosy_lab.common.configuration.converters.TypeConverter;
import org.sosy_lab.cpachecker.cmdline.CmdLineArguments;
import org.sosy_lab.cpachecker.cmdline.ShutdownHook;
import org.sosy_lab.cpachecker.core.CPAchecker;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.ProofGenerator;

public class CPAMain {
    public static void main(String[] args) {
        Configuration cpaConfig = null;
        LogManager logManager = null;
        String outputDirectory = null;
        try {
            try {
                cpaConfig = CPAMain.createConfiguration(args);
            }
            catch (CmdLineArguments.InvalidCmdlineArgumentException e) {
                System.err.println("Could not parse command line arguments: " + e.getMessage());
                System.exit(1);
            }
            catch (IOException e) {
                System.err.println("Could not read config file " + e.getMessage());
                System.exit(1);
            }
            FileTypeConverter fileTypeConverter = new FileTypeConverter(cpaConfig);
            outputDirectory = fileTypeConverter.getOutputDirectory();
            cpaConfig = Configuration.builder().copyFrom(cpaConfig).addConverter(FileOption.class, (TypeConverter)fileTypeConverter).build();
            Configuration.getDefaultConverters().put(FileOption.class, fileTypeConverter);
            logManager = new LogManager(cpaConfig);
        }
        catch (InvalidConfigurationException e) {
            System.err.println("Invalid configuration: " + e.getMessage());
            System.exit(1);
        }
        CPAchecker cpachecker = null;
        ShutdownHook shutdownHook = null;
        File cFile = null;
        ProofGenerator proofGenerator = null;
        try {
            shutdownHook = new ShutdownHook(cpaConfig, logManager, outputDirectory);
            cpachecker = new CPAchecker(cpaConfig, logManager);
            cFile = CPAMain.getCodeFile(cpaConfig);
            proofGenerator = new ProofGenerator(cpaConfig, logManager);
        }
        catch (InvalidConfigurationException e) {
            logManager.logUserException(Level.SEVERE, (Throwable)e, "Invalid configuration");
            System.exit(1);
        }
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        CPAcheckerResult result = cpachecker.run(cFile.getPath());
        shutdownHook.setResult(result);
        proofGenerator.generateProof(result);
    }

    static File getCodeFile(Configuration cpaConfig) throws InvalidConfigurationException {
        MainOptions options = new MainOptions();
        cpaConfig.inject((Object)options);
        if (options.programs.size() != 1) {
            throw new InvalidConfigurationException("Exactly one code file has to be given.");
        }
        return (File)Iterables.getOnlyElement((Iterable)options.programs);
    }

    static Configuration createConfiguration(String[] args) throws CmdLineArguments.InvalidCmdlineArgumentException, IOException, InvalidConfigurationException {
        Map<String, String> cmdLineOptions = CmdLineArguments.processArguments(args);
        String configFile = cmdLineOptions.remove("configuration.file");
        Configuration.Builder config = Configuration.builder();
        if (configFile != null) {
            config.loadFromFile(configFile);
        }
        config.setOptions(cmdLineOptions);
        return config.build();
    }

    private CPAMain() {
    }

    @Options
    private static class MainOptions {
        @Option(name="analysis.programNames", required=true, description="C programs to analyze (currently only one file is supported)")
        @FileOption(value=FileOption.Type.REQUIRED_INPUT_FILE)
        private List<File> programs;

        private MainOptions() {
        }
    }
}

