/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cmdline;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMultimap;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.MutableCFA;
import org.sosy_lab.cpachecker.cfa.ParseResult;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.ParserException;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class CPASelfCheck {
    private static LogManager logManager;
    private static Configuration config;

    public static void main(String[] args) throws Exception {
        config = Configuration.defaultConfiguration();
        logManager = new LogManager(config);
        CFA cfa = CPASelfCheck.createCFA();
        CFAFunctionDefinitionNode main = cfa.getMainFunction();
        logManager.log(Level.INFO, new Object[]{"Searching for CPAs"});
        List<Class<ConfigurableProgramAnalysis>> cpas = CPASelfCheck.getCPAs();
        for (Class<ConfigurableProgramAnalysis> cpa : cpas) {
            ConfigurableProgramAnalysis cpaInst;
            logManager.log(Level.INFO, new Object[]{"Checking " + cpa.getCanonicalName() + " ..."});
            try {
                cpaInst = CPASelfCheck.tryToInstantiate(cpa, cfa);
            }
            catch (InvocationTargetException e) {
                logManager.logException(Level.WARNING, (Throwable)e, "Getting factory instance for " + cpa.getCanonicalName() + " failed!");
                continue;
            }
            catch (NoSuchMethodException e) {
                logManager.logException(Level.WARNING, (Throwable)e, "Getting factory instance for " + cpa.getCanonicalName() + " failed: no factory method!");
                continue;
            }
            catch (Exception e) {
                logManager.logException(Level.WARNING, (Throwable)e, "Could not instantiate " + cpa.getCanonicalName());
                continue;
            }
            catch (UnsatisfiedLinkError e) {
                logManager.logException(Level.WARNING, (Throwable)e, "Could not instantiate " + cpa.getCanonicalName());
                continue;
            }
            assert (cpaInst != null);
            try {
                cpaInst.getInitialElement(main);
                boolean ok = true;
                ok &= CPASelfCheck.checkJoin(cpa, cpaInst, main);
                ok &= CPASelfCheck.checkMergeSoundness(cpa, cpaInst, main);
                ok &= CPASelfCheck.checkStopEmptyReached(cpa, cpaInst, main);
                logManager.log(Level.INFO, new Object[]{(ok &= CPASelfCheck.checkStopReached(cpa, cpaInst, main)) ? " OK" : " ERROR"});
            }
            catch (Exception e) {
                logManager.logException(Level.WARNING, (Throwable)e, "");
            }
        }
    }

    private static CFA createCFA() throws IOException, ParserException {
        String code = "int main() {\n  int a;\n  a = 1;\n  return (a);\n}\n";
        CParser parser = CParser.Factory.getParser(logManager, CParser.Factory.getDefaultOptions());
        ParseResult cfas = parser.parseString(code);
        MutableCFA cfa = new MutableCFA(cfas.getFunctions(), cfas.getCFANodes(), cfas.getFunctions().get("main"));
        return cfa.makeImmutableCFA((Optional<ImmutableMultimap<String, CFAUtils.Loop>>)Optional.absent());
    }

    private static ConfigurableProgramAnalysis tryToInstantiate(Class<ConfigurableProgramAnalysis> pCpa, CFA cfa) throws NoSuchMethodException, InvocationTargetException, InvalidConfigurationException, CPAException, IllegalAccessException {
        Method factoryMethod = pCpa.getMethod("factory", new Class[0]);
        CPAFactory factory = (CPAFactory)factoryMethod.invoke(null, new Object[0]);
        return factory.setLogger(logManager).setConfiguration(config).set(cfa, CFA.class).createInstance();
    }

    private static boolean ensure(boolean pB, String pString) {
        if (!pB) {
            logManager.log(Level.WARNING, new Object[]{pString});
            return false;
        }
        return true;
    }

    private static boolean checkJoin(Class<ConfigurableProgramAnalysis> pCpa, ConfigurableProgramAnalysis pCpaInst, CFAFunctionDefinitionNode pMain) throws CPAException {
        AbstractDomain d = pCpaInst.getAbstractDomain();
        AbstractElement initial = pCpaInst.getInitialElement(pMain);
        return CPASelfCheck.ensure(d.isLessOrEqual(initial, d.join(initial, initial)), "Join of same elements is unsound!");
    }

    private static boolean checkMergeSoundness(Class<ConfigurableProgramAnalysis> pCpa, ConfigurableProgramAnalysis pCpaInst, CFAFunctionDefinitionNode pMain) throws CPAException {
        AbstractDomain d = pCpaInst.getAbstractDomain();
        MergeOperator merge = pCpaInst.getMergeOperator();
        AbstractElement initial = pCpaInst.getInitialElement(pMain);
        Precision initialPrec = pCpaInst.getInitialPrecision(pMain);
        return CPASelfCheck.ensure(d.isLessOrEqual(initial, merge.merge(initial, initial, initialPrec)), "Merging same elements was unsound!");
    }

    private static boolean checkStopEmptyReached(Class<ConfigurableProgramAnalysis> pCpa, ConfigurableProgramAnalysis pCpaInst, CFAFunctionDefinitionNode pMain) throws CPAException {
        Precision initialPrec;
        StopOperator stop = pCpaInst.getStopOperator();
        HashSet<AbstractElement> reached = new HashSet<AbstractElement>();
        AbstractElement initial = pCpaInst.getInitialElement(pMain);
        return CPASelfCheck.ensure(!stop.stop(initial, reached, initialPrec = pCpaInst.getInitialPrecision(pMain)), "Stopped on empty set!");
    }

    private static boolean checkStopReached(Class<ConfigurableProgramAnalysis> pCpa, ConfigurableProgramAnalysis pCpaInst, CFAFunctionDefinitionNode pMain) throws CPAException {
        StopOperator stop = pCpaInst.getStopOperator();
        HashSet<AbstractElement> reached = new HashSet<AbstractElement>();
        AbstractElement initial = pCpaInst.getInitialElement(pMain);
        reached.add(initial);
        Precision initialPrec = pCpaInst.getInitialPrecision(pMain);
        return CPASelfCheck.ensure(stop.stop(initial, reached, initialPrec), "Did not stop on same element!");
    }

    private static List<Class<ConfigurableProgramAnalysis>> getCPAs() throws ClassNotFoundException, IOException {
        List<Class<?>> cpaCandidates = CPASelfCheck.getClasses("org.sosy_lab.cpachecker.cpa");
        ArrayList<Class<ConfigurableProgramAnalysis>> cpas = new ArrayList<Class<ConfigurableProgramAnalysis>>();
        Class targetType = null;
        for (Class<?> candidate : cpaCandidates) {
            if (Modifier.isAbstract(candidate.getModifiers()) || Modifier.isInterface(candidate.getModifiers()) || !ConfigurableProgramAnalysis.class.isAssignableFrom(candidate)) continue;
            cpas.add(CPASelfCheck.uncheckedGenericCast(candidate, targetType));
        }
        return cpas;
    }

    private static <T> Class<T> uncheckedGenericCast(Class<?> classObj, Class<T> targetType) {
        return classObj;
    }

    private static List<Class<?>> getClasses(String packageName) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList classes = new ArrayList();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            CPASelfCheck.collectClasses(new File(resource.getFile()), packageName, classes);
        }
        return classes;
    }

    private static void collectClasses(File directory, String packageName, List<Class<?>> classes) {
        File[] files;
        if (!directory.exists()) {
            return;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                CPASelfCheck.collectClasses(file, packageName + "." + file.getName(), classes);
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            try {
                Class<?> foundClass = Class.forName(packageName + '.' + file.getName().substring(0, file.getName().length() - 6));
                classes.add(foundClass);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
    }
}

