/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cmdline;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.sosy_lab.common.Files;
import org.sosy_lab.common.configuration.OptionCollector;
import org.sosy_lab.cpachecker.core.CPAchecker;
import org.sosy_lab.cpachecker.cpa.composite.CompositeCPA;

class CmdLineArguments {
    private static final String DEFAULT_CONFIG_FILES_DIR = "config/%s.properties";
    static final String CONFIGURATION_FILE_OPTION = "configuration.file";

    private CmdLineArguments() {
    }

    static Map<String, String> processArguments(String[] args) throws InvalidCmdlineArgumentException {
        if (args == null || args.length < 1) {
            throw new InvalidCmdlineArgumentException("Configuration file or list of CPAs needed. Use -help for more information.");
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        ArrayList<String> programs = new ArrayList<String>();
        Iterator<String> argsIt = Arrays.asList(args).iterator();
        while (argsIt.hasNext()) {
            String arg = argsIt.next();
            if (CmdLineArguments.handleArgument0("-cbmc", "analysis.useCBMC", "true", arg, properties) || CmdLineArguments.handleArgument0("-stats", "statistics.print", "true", arg, properties) || CmdLineArguments.handleArgument0("-noout", "output.disable", "true", arg, properties) || CmdLineArguments.handleArgument1("-outputpath", "output.path", arg, argsIt, properties) || CmdLineArguments.handleArgument1("-logfile", "log.file", arg, argsIt, properties) || CmdLineArguments.handleArgument1("-entryfunction", "analysis.entryFunction", arg, argsIt, properties) || CmdLineArguments.handleArgument1("-config", CONFIGURATION_FILE_OPTION, arg, argsIt, properties) || CmdLineArguments.handleArgument1("-timelimit", "cpa.conditions.global.time.wall", arg, argsIt, properties) || CmdLineArguments.handleMultipleArgument1("-spec", "specification", arg, argsIt, properties)) continue;
            if (arg.equals("-cpas")) {
                if (argsIt.hasNext()) {
                    properties.put("cpa", CompositeCPA.class.getName());
                    properties.put(CompositeCPA.class.getSimpleName() + ".cpas", argsIt.next());
                    continue;
                }
                throw new InvalidCmdlineArgumentException("-cpas argument missing.");
            }
            if (arg.equals("-nolog")) {
                CmdLineArguments.putIfNotExistent(properties, "log.level", "off");
                CmdLineArguments.putIfNotExistent(properties, "log.consoleLevel", "off");
                continue;
            }
            if (arg.equals("-setprop")) {
                if (argsIt.hasNext()) {
                    String s = argsIt.next();
                    String[] bits = s.split("=");
                    if (bits.length != 2) {
                        throw new InvalidCmdlineArgumentException("-setprop argument must be a key=value pair, but \"" + s + "\" is not.");
                    }
                    CmdLineArguments.putIfNotExistent(properties, bits[0], bits[1]);
                    continue;
                }
                throw new InvalidCmdlineArgumentException("-setprop argument missing.");
            }
            if ("-printOptions".equals(arg)) {
                boolean verbose = false;
                if (argsIt.hasNext()) {
                    String nextArg = argsIt.next();
                    verbose = "-v".equals(nextArg) || "-verbose".equals(nextArg);
                }
                System.out.println(OptionCollector.getCollectedOptions((boolean)verbose));
                System.exit(0);
                continue;
            }
            if ("-printUsedOptions".equals(arg)) {
                CmdLineArguments.putIfNotExistent(properties, "log.usedOptions.export", "true");
                CmdLineArguments.putIfNotExistent(properties, "analysis.disable", "true");
                properties.put("log.consoleLevel", "SEVERE");
                continue;
            }
            if (arg.equals("-help") || arg.equals("-h")) {
                CmdLineArguments.printHelp();
                continue;
            }
            if (arg.startsWith("-") && !new File(arg).exists()) {
                String argName = arg.substring(1);
                File f = new File(String.format(DEFAULT_CONFIG_FILES_DIR, argName));
                if (argName.matches("^[a-zA-Z0-9-]+$") && f.exists()) {
                    try {
                        Files.checkReadableFile((File)f);
                        CmdLineArguments.putIfNotExistent(properties, CONFIGURATION_FILE_OPTION, f.getPath());
                    }
                    catch (FileNotFoundException e) {
                        System.out.println("Invalid configuration " + argName + " (" + e.getMessage() + ")");
                        System.exit(0);
                    }
                    continue;
                }
                System.out.println("Invalid option " + arg);
                System.out.println("");
                CmdLineArguments.printHelp();
                continue;
            }
            programs.add(arg);
        }
        if (!programs.isEmpty()) {
            CmdLineArguments.putIfNotExistent(properties, "analysis.programNames", Joiner.on((String)", ").join(programs));
        }
        return properties;
    }

    private static void printHelp() {
        System.out.println("CPAchecker " + CPAchecker.getVersion());
        System.out.println();
        System.out.println("OPTIONS:");
        System.out.println(" -config");
        System.out.println(" -cpas");
        System.out.println(" -spec");
        System.out.println(" -outputpath");
        System.out.println(" -logfile");
        System.out.println(" -entryfunction");
        System.out.println(" -timelimit");
        System.out.println(" -cbmc");
        System.out.println(" -stats");
        System.out.println(" -nolog");
        System.out.println(" -noout");
        System.out.println(" -setprop");
        System.out.println(" -printOptions [-v|-verbose]");
        System.out.println(" -printUsedOptions");
        System.out.println(" -help");
        System.out.println();
        System.out.println("More information on how to configure CPAchecker can be found in 'doc/Configuration.txt'.");
        System.exit(0);
    }

    private static void putIfNotExistent(Map<String, String> properties, String key, String value) throws InvalidCmdlineArgumentException {
        if (properties.containsKey(key)) {
            throw new InvalidCmdlineArgumentException("Duplicate option " + key + " specified on command-line.");
        }
        properties.put(key, value);
    }

    private static boolean handleArgument0(String arg, String option, String value, String currentArg, Map<String, String> properties) throws InvalidCmdlineArgumentException {
        if (currentArg.equals(arg)) {
            CmdLineArguments.putIfNotExistent(properties, option, value);
            return true;
        }
        return false;
    }

    private static boolean handleArgument1(String arg, String option, String currentArg, Iterator<String> args, Map<String, String> properties) throws InvalidCmdlineArgumentException {
        if (currentArg.equals(arg)) {
            if (!args.hasNext()) {
                throw new InvalidCmdlineArgumentException(currentArg + " argument missing.");
            }
            CmdLineArguments.putIfNotExistent(properties, option, args.next());
            return true;
        }
        return false;
    }

    private static boolean handleMultipleArgument1(String arg, String option, String currentArg, Iterator<String> args, Map<String, String> properties) throws InvalidCmdlineArgumentException {
        if (currentArg.equals(arg)) {
            if (!args.hasNext()) {
                throw new InvalidCmdlineArgumentException(currentArg + " argument missing.");
            }
            String value = properties.get(option);
            value = value != null ? value + "," + args.next() : args.next();
            properties.put(option, value);
            return true;
        }
        return false;
    }

    static class InvalidCmdlineArgumentException
    extends Exception {
        private static final long serialVersionUID = -6526968677815416436L;

        private InvalidCmdlineArgumentException(String msg) {
            super(msg);
        }
    }
}

