/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cmdline;

import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import org.sosy_lab.common.DuplicateOutputStream;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;

@Options(prefix="statistics")
class ShutdownHook
extends Thread {
    @Option(name="export", description="write some statistics to disk")
    private boolean exportStatistics = true;
    @Option(name="file", description="write some statistics to disk")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private File exportStatisticsFile = new File("Statistics.txt");
    @Option(name="print", description="print statistics to console")
    private boolean printStatistics = false;
    private final LogManager logManager;
    private final String outputDirectory;
    private final Thread mainThread;
    private CPAcheckerResult mResult = null;

    public ShutdownHook(Configuration config, LogManager logger, String pOutputDirectory) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logManager = logger;
        this.outputDirectory = pOutputDirectory;
        this.mainThread = Thread.currentThread();
    }

    public void setResult(CPAcheckerResult pResult) {
        assert (this.mResult == null);
        this.mResult = pResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block14: {
            boolean cancelled = false;
            if (this.mainThread.isAlive()) {
                this.mainThread.interrupt();
                this.logManager.log(Level.INFO, new Object[]{"Stop signal received, waiting 2s for analysis to stop cleanly..."});
                cancelled = true;
                try {
                    this.mainThread.join(2000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.mainThread.isAlive()) {
                    this.logManager.log(Level.WARNING, new Object[]{"Analysis did not stop fast enough, forcing immediate termination now. This might prevent the statistics from being generated."});
                    this.mainThread.stop();
                }
            }
            this.logManager.flush();
            System.out.flush();
            System.err.flush();
            if (this.mResult != null && this.mResult.getResult() != CPAcheckerResult.Result.NOT_YET_STARTED) {
                PrintStream console = this.printStatistics ? System.out : null;
                FileOutputStream file = null;
                if (this.exportStatistics && this.exportStatisticsFile != null) {
                    try {
                        Files.createParentDirs((File)this.exportStatisticsFile);
                        file = new FileOutputStream(this.exportStatisticsFile);
                    }
                    catch (IOException e) {
                        this.logManager.logUserException(Level.WARNING, (Throwable)e, "Could not write statistics to file");
                    }
                }
                PrintStream stream = ShutdownHook.makePrintStream(DuplicateOutputStream.mergeStreams((OutputStream)console, file));
                try {
                    this.mResult.printStatistics(stream);
                    stream.println();
                    if (cancelled) {
                        stream.println("***********************************************************************\n* WARNING: Analysis interrupted!! The statistics might be unreliable! *\n***********************************************************************\n");
                    }
                    if (!this.printStatistics) {
                        stream = ShutdownHook.makePrintStream(DuplicateOutputStream.mergeStreams((OutputStream)System.out, (OutputStream)file));
                    }
                    this.mResult.printResult(stream);
                    if (this.outputDirectory != null) {
                        stream.println("More details about the verification run can be found in the directory \"" + this.outputDirectory + "\".");
                    }
                    stream.flush();
                    if (file == null) break block14;
                }
                catch (Throwable throwable) {
                    if (file != null) {
                        Closeables.closeQuietly(file);
                    }
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)file);
            }
        }
        this.logManager.flush();
    }

    private static PrintStream makePrintStream(OutputStream stream) {
        if (stream instanceof PrintStream) {
            return (PrintStream)stream;
        }
        return new PrintStream(stream);
    }
}

