/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonParser;
import org.sosy_lab.cpachecker.cpa.automaton.ControlAutomatonCPA;
import org.sosy_lab.cpachecker.cpa.composite.CompositeCPA;
import org.sosy_lab.cpachecker.cpa.location.LocationCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.InvalidComponentException;

@Options
public class CPABuilder {
    private static final String CPA_OPTION_NAME = "cpa";
    private static final String CPA_CLASS_PREFIX = "org.sosy_lab.cpachecker";
    private static final Splitter LIST_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    @Option(name="cpa", description="CPA to use (see doc/Configuration.txt for more documentation on this)")
    private String cpaName = CompositeCPA.class.getCanonicalName();
    @Option(name="specification", description="comma-separated list of files with specifications that should be checked\n(see config/specification/ for examples)")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private List<File> specificationFiles = null;
    private final Configuration config;
    private final LogManager logger;
    private final ReachedSetFactory reachedSetFactory;

    public CPABuilder(Configuration pConfig, LogManager pLogger, ReachedSetFactory pReachedSetFactory) throws InvalidConfigurationException {
        this.config = pConfig;
        this.logger = pLogger;
        this.reachedSetFactory = pReachedSetFactory;
        this.config.inject((Object)this);
    }

    public ConfigurableProgramAnalysis buildCPAs(CFA cfa) throws InvalidConfigurationException, CPAException {
        HashSet<String> usedAliases = new HashSet<String>();
        ArrayList<ConfigurableProgramAnalysis> cpas = null;
        if (this.specificationFiles != null) {
            cpas = new ArrayList<ConfigurableProgramAnalysis>();
            for (File specFile : this.specificationFiles) {
                List<Automaton> automata = AutomatonParser.parseAutomatonFile(specFile, this.config, this.logger);
                for (Automaton automaton : automata) {
                    String cpaAlias = automaton.getName();
                    if (!usedAliases.add(cpaAlias)) {
                        throw new InvalidConfigurationException("Name " + cpaAlias + " used twice for an automaton.");
                    }
                    CPAFactory factory = ControlAutomatonCPA.factory();
                    factory.setConfiguration(Configuration.copyWithNewPrefix((Configuration)this.config, (String)cpaAlias));
                    factory.setLogger(this.logger);
                    factory.set(automaton, Automaton.class);
                    cpas.add(factory.createInstance());
                    this.logger.log(Level.FINER, new Object[]{"Loaded Automaton\"" + automaton.getName() + "\""});
                }
            }
        }
        return this.buildCPAs(this.cpaName, CPA_OPTION_NAME, usedAliases, cpas, cfa);
    }

    private ConfigurableProgramAnalysis buildCPAs(String optionValue, String optionName, Set<String> usedAliases, List<ConfigurableProgramAnalysis> cpas, CFA cfa) throws InvalidConfigurationException, CPAException {
        ConfigurableProgramAnalysis cpa;
        Preconditions.checkNotNull((Object)optionValue);
        String[] optionParts = optionValue.trim().split("\\s+");
        String cpaName = optionParts[0];
        String cpaAlias = this.getCPAAlias(optionValue, optionName, optionParts, cpaName);
        if (!usedAliases.add(cpaAlias)) {
            throw new InvalidConfigurationException("Alias " + cpaAlias + " used twice for a CPA.");
        }
        Class<?> cpaClass = this.getCPAClass(optionName, cpaName);
        this.logger.log(Level.FINER, new Object[]{"Instantiating CPA " + cpaClass.getName() + " with alias " + cpaAlias});
        CPAFactory factory = this.getFactoryInstance(cpaName, cpaClass);
        factory.setConfiguration(Configuration.copyWithNewPrefix((Configuration)this.config, (String)cpaAlias));
        factory.setLogger(this.logger);
        if (this.reachedSetFactory != null) {
            factory.set(this.reachedSetFactory, ReachedSetFactory.class);
        }
        if (cfa != null) {
            factory.set(cfa, CFA.class);
        }
        this.createAndSetChildrenCPAs(cpaName, cpaAlias, factory, usedAliases, cpas, cfa);
        if (cpas != null && !cpas.isEmpty()) {
            throw new InvalidConfigurationException("Option specification gave specification automata, but no CompositeCPA was used");
        }
        try {
            cpa = factory.createInstance();
        }
        catch (IllegalStateException e) {
            throw new InvalidComponentException(cpaClass, "CPA", e);
        }
        if (cpa == null) {
            throw new InvalidComponentException(cpaClass, "CPA", "Factory returned null.");
        }
        this.logger.log(Level.FINER, new Object[]{"Sucessfully instantiated CPA " + cpa.getClass().getName() + " with alias " + cpaAlias});
        return cpa;
    }

    private String getCPAAlias(String optionValue, String optionName, String[] optionParts, String cpaName) throws InvalidConfigurationException {
        if (optionParts.length == 1) {
            int dotIndex = cpaName.lastIndexOf(46);
            return dotIndex >= 0 ? cpaName.substring(dotIndex + 1) : cpaName;
        }
        if (optionParts.length == 2) {
            return optionParts[1];
        }
        throw new InvalidConfigurationException("Option " + optionName + " contains invalid CPA specification \"" + optionValue + "\"!");
    }

    private Class<?> getCPAClass(String optionName, String cpaName) throws InvalidConfigurationException {
        Class cpaClass;
        try {
            cpaClass = Classes.forName((String)cpaName, (String)CPA_CLASS_PREFIX);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidConfigurationException("Option " + optionName + " is set to unknown CPA " + cpaName, (Throwable)e);
        }
        if (!ConfigurableProgramAnalysis.class.isAssignableFrom(cpaClass)) {
            throw new InvalidConfigurationException("Option " + optionName + " has to be set to a class implementing the ConfigurableProgramAnalysis interface!");
        }
        return cpaClass;
    }

    private CPAFactory getFactoryInstance(String cpaName, Class<?> cpaClass) throws CPAException {
        Object factoryObj;
        Method factoryMethod;
        try {
            factoryMethod = cpaClass.getMethod("factory", null);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidComponentException(cpaClass, "CPA", "No public static method \"factory\" with zero parameters.");
        }
        if (!Modifier.isStatic(factoryMethod.getModifiers())) {
            throw new InvalidComponentException(cpaClass, "CPA", "Factory method is not static.");
        }
        String exception = Classes.verifyDeclaredExceptions((Method)factoryMethod, (Class[])new Class[]{CPAException.class});
        if (exception != null) {
            throw new InvalidComponentException(cpaClass, "CPA", "Factory method declares the unsupported checked exception " + exception + " .");
        }
        try {
            factoryObj = factoryMethod.invoke(null, (Object[])null);
        }
        catch (IllegalAccessException e) {
            throw new InvalidComponentException(cpaClass, "CPA", "Factory method is not public.");
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            Throwables.propagateIfPossible((Throwable)cause, CPAException.class);
            throw new Classes.UnexpectedCheckedException("instantiation of CPA " + cpaName, cause);
        }
        if (factoryObj == null || !(factoryObj instanceof CPAFactory)) {
            throw new InvalidComponentException(cpaClass, "CPA", "Factory method did not return a CPAFactory instance.");
        }
        return (CPAFactory)factoryObj;
    }

    private void createAndSetChildrenCPAs(String cpaName, String cpaAlias, CPAFactory factory, Set<String> usedAliases, List<ConfigurableProgramAnalysis> cpas, CFA cfa) throws InvalidConfigurationException, CPAException {
        String childOptionName = cpaAlias + ".cpa";
        String childrenOptionName = cpaAlias + ".cpas";
        String childCpaName = this.config.getProperty(childOptionName);
        String childrenCpaNames = this.config.getProperty(childrenOptionName);
        if (childrenCpaNames == null && childCpaName == null && cpaAlias.equals("CompositeCPA") && cpas != null && !cpas.isEmpty()) {
            childrenCpaNames = LocationCPA.class.getCanonicalName();
        }
        if (childCpaName != null) {
            if (childrenCpaNames != null) {
                throw new InvalidConfigurationException("Ambiguous configuration: both " + childOptionName + " and " + childrenOptionName + " are specified!");
            }
            ConfigurableProgramAnalysis child = this.buildCPAs(childCpaName, childOptionName, usedAliases, cpas, cfa);
            try {
                factory.setChild(child);
            }
            catch (UnsupportedOperationException e) {
                throw new InvalidConfigurationException(cpaName + " is no wrapper CPA, but option " + childOptionName + " was specified!", (Throwable)e);
            }
            this.logger.log(Level.FINER, new Object[]{"CPA " + cpaAlias + " got child " + childCpaName});
        } else if (childrenCpaNames != null) {
            ImmutableList.Builder childrenCpas = ImmutableList.builder();
            for (String currentChildCpaName : LIST_SPLITTER.split((CharSequence)childrenCpaNames)) {
                childrenCpas.add((Object)this.buildCPAs(currentChildCpaName, childrenOptionName, usedAliases, null, cfa));
            }
            if (cpas != null) {
                childrenCpas.addAll(cpas);
                cpas.clear();
            }
            try {
                factory.setChildren((List<ConfigurableProgramAnalysis>)childrenCpas.build());
            }
            catch (UnsupportedOperationException e) {
                throw new InvalidConfigurationException(cpaName + " is no wrapper CPA, but option " + childrenOptionName + " was specified!", (Throwable)e);
            }
            this.logger.log(Level.FINER, new Object[]{"CPA " + cpaAlias + " got children " + childrenCpaNames});
        }
    }
}

