/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.AbstractMBean;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CFACreator;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.CoreComponentsFactory;
import org.sosy_lab.cpachecker.core.MainCPAStatistics;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.ExternalCBMCAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.impact.ImpactAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.ParserException;
import org.sosy_lab.cpachecker.util.AbstractElements;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;

@Options(prefix="analysis")
public class CPAchecker {
    @Option(description="stop after the first error has been found")
    private boolean stopAfterError = true;
    @Option(name="disable", description="stop CPAchecker after startup (internal option, not intended for users)")
    private boolean disableAnalysis = false;
    @Option(name="externalCBMC", description="use CBMC as an external tool from CPAchecker")
    private boolean runCBMCasExternalTool = false;
    private final LogManager logger;
    private final Configuration config;
    private final CoreComponentsFactory factory;
    private static final String version;

    public static void stopIfNecessary() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public static String getVersion() {
        return version;
    }

    public CPAchecker(Configuration pConfiguration, LogManager pLogManager) throws InvalidConfigurationException {
        this.config = pConfiguration;
        this.logger = pLogManager;
        this.config.inject((Object)this);
        this.factory = new CoreComponentsFactory(pConfiguration, pLogManager);
    }

    public CPAcheckerResult run(String filename) {
        this.logger.log(Level.INFO, new Object[]{"CPAchecker", CPAchecker.getVersion(), "started"});
        MainCPAStatistics stats = null;
        ReachedSet reached = null;
        CPAcheckerResult.Result result = CPAcheckerResult.Result.NOT_YET_STARTED;
        try {
            Algorithm algorithm;
            stats = new MainCPAStatistics(this.config, this.logger);
            stats.creationTime.start();
            reached = this.factory.createReachedSet();
            if (this.runCBMCasExternalTool) {
                algorithm = new ExternalCBMCAlgorithm(filename, this.config, this.logger);
            } else {
                CFA cfa = this.parse(filename, stats);
                GlobalInfo.getInstance().storeCFA(cfa);
                CPAchecker.stopIfNecessary();
                ConfigurableProgramAnalysis cpa = this.factory.createCPA(cfa, stats);
                algorithm = this.factory.createAlgorithm(cpa, filename, cfa, stats);
                if (algorithm instanceof ImpactAlgorithm) {
                    ImpactAlgorithm mcmillan = (ImpactAlgorithm)algorithm;
                    reached.add(mcmillan.getInitialElement(cfa.getMainFunction()), mcmillan.getInitialPrecision(cfa.getMainFunction()));
                } else {
                    this.initializeReachedSet(reached, cpa, cfa.getMainFunction());
                }
            }
            this.printConfigurationWarnings();
            stats.creationTime.stop();
            CPAchecker.stopIfNecessary();
            if (this.disableAnalysis) {
                return new CPAcheckerResult(CPAcheckerResult.Result.NOT_YET_STARTED, null, null);
            }
            result = CPAcheckerResult.Result.UNKNOWN;
            boolean sound = this.runAlgorithm(algorithm, reached, stats);
            result = this.analyzeResult(reached, sound);
        }
        catch (IOException e) {
            this.logger.logUserException(Level.SEVERE, (Throwable)e, "Could not read file");
        }
        catch (ParserException e) {
            this.logger.logUserException(Level.SEVERE, (Throwable)e, "Parsing failed");
            this.logger.log(Level.INFO, new Object[]{"Make sure that the code was preprocessed using Cil (HowTo.txt).\nIf the error still occurs, please send this error message together with the input file to cpachecker-users@sosy-lab.org."});
        }
        catch (InvalidConfigurationException e) {
            this.logger.logUserException(Level.SEVERE, (Throwable)e, "Invalid configuration");
        }
        catch (InterruptedException e) {
        }
        catch (CPAException e) {
            this.logger.logUserException(Level.SEVERE, (Throwable)e, null);
        }
        return new CPAcheckerResult(result, reached, stats);
    }

    private CFA parse(String filename, MainCPAStatistics stats) throws InvalidConfigurationException, IOException, ParserException, InterruptedException {
        CFACreator cfaCreator = new CFACreator(this.config, this.logger);
        stats.setCFACreator(cfaCreator);
        return cfaCreator.parseFileAndCreateCFA(filename);
    }

    private void printConfigurationWarnings() {
        Set deprecatedProperties;
        Set unusedProperties = this.config.getUnusedProperties();
        if (!unusedProperties.isEmpty()) {
            this.logger.log(Level.WARNING, new Object[]{"The following configuration options were specified but are not used:\n", Joiner.on((String)"\n ").join((Iterable)unusedProperties), "\n"});
        }
        if (!(deprecatedProperties = this.config.getDeprecatedProperties()).isEmpty()) {
            this.logger.log(Level.WARNING, new Object[]{"The following options are deprecated and will be removed in the future:\n", Joiner.on((String)"\n ").join((Iterable)deprecatedProperties), "\n"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runAlgorithm(Algorithm algorithm, ReachedSet reached, MainCPAStatistics stats) throws CPAException, InterruptedException {
        this.logger.log(Level.INFO, new Object[]{"Starting analysis ..."});
        boolean sound = true;
        CPAcheckerBean mxbean = new CPAcheckerBean(reached, this.logger);
        stats.analysisTime.start();
        try {
            do {
                sound &= algorithm.run(reached);
            } while (!this.stopAfterError && reached.hasWaitingElement());
            this.logger.log(Level.INFO, new Object[]{"Stopping analysis ..."});
            boolean bl = sound;
            return bl;
        }
        finally {
            stats.analysisTime.stop();
            stats.programTime.stop();
            mxbean.unregister();
        }
    }

    private CPAcheckerResult.Result analyzeResult(ReachedSet reached, boolean sound) {
        if (Iterables.any((Iterable)reached, AbstractElements.IS_TARGET_ELEMENT)) {
            return CPAcheckerResult.Result.UNSAFE;
        }
        if (reached.hasWaitingElement()) {
            this.logger.log(Level.WARNING, new Object[]{"Analysis not completed: there are still elements to be processed."});
            return CPAcheckerResult.Result.UNKNOWN;
        }
        if (!sound) {
            this.logger.log(Level.WARNING, new Object[]{"Analysis incomplete: no errors found, but not everything could be checked."});
            return CPAcheckerResult.Result.UNKNOWN;
        }
        return CPAcheckerResult.Result.SAFE;
    }

    private void initializeReachedSet(ReachedSet reached, ConfigurableProgramAnalysis cpa, CFAFunctionDefinitionNode mainFunction) {
        this.logger.log(Level.FINE, new Object[]{"Creating initial reached set"});
        AbstractElement initialElement = cpa.getInitialElement(mainFunction);
        Precision initialPrecision = cpa.getInitialPrecision(mainFunction);
        reached.add(initialElement, initialPrecision);
    }

    static {
        String v = "(unknown version)";
        try {
            String content;
            URL url = CPAchecker.class.getClassLoader().getResource("org/sosy_lab/cpachecker/VERSION.txt");
            if (url != null && (content = Resources.toString((URL)url, (Charset)Charsets.US_ASCII).trim()).matches("[a-zA-Z0-9 ._+:-]+")) {
                v = content;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        version = v;
    }

    private static class CPAcheckerBean
    extends AbstractMBean
    implements CPAcheckerMXBean {
        private final ReachedSet reached;
        private final Thread cpacheckerThread;

        public CPAcheckerBean(ReachedSet pReached, LogManager logger) {
            super("org.sosy_lab.cpachecker:type=CPAchecker", logger);
            this.reached = pReached;
            this.cpacheckerThread = Thread.currentThread();
            this.register();
        }

        @Override
        public int getReachedSetSize() {
            return this.reached.size();
        }

        @Override
        public void stop() {
            this.cpacheckerThread.interrupt();
        }
    }

    public static interface CPAcheckerMXBean {
        public int getReachedSetSize();

        public void stop();
    }
}

