/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core;

import com.google.common.base.Preconditions;
import java.io.PrintStream;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;

public class CPAcheckerResult {
    private final Result result;
    private final ReachedSet reached;
    private final Statistics stats;

    CPAcheckerResult(Result result, ReachedSet reached, Statistics stats) {
        Preconditions.checkNotNull((Object)((Object)result));
        this.result = result;
        this.reached = reached;
        this.stats = stats;
    }

    public Result getResult() {
        return this.result;
    }

    public UnmodifiableReachedSet getReached() {
        return this.reached;
    }

    public void printStatistics(PrintStream target) {
        if (this.stats != null && this.reached != null && this.result != Result.NOT_YET_STARTED) {
            this.stats.printStatistics(target, this.result, this.reached);
        }
    }

    public void printResult(PrintStream out) {
        if (this.result == Result.NOT_YET_STARTED) {
            return;
        }
        out.print("Verification result: ");
        switch (this.result) {
            case UNKNOWN: {
                out.println("UNKNOWN, incomplete analysis.");
                break;
            }
            case UNSAFE: {
                out.println("UNSAFE. Error path found by chosen configuration.");
                break;
            }
            case SAFE: {
                out.println("SAFE. No error path found by chosen configuration.");
                break;
            }
            default: {
                out.println("UNKNOWN result: " + (Object)((Object)this.result));
            }
        }
    }

    public static enum Result {
        NOT_YET_STARTED,
        UNKNOWN,
        UNSAFE,
        SAFE;

    }
}

