/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core;

import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.CPABuilder;
import org.sosy_lab.cpachecker.core.MainCPAStatistics;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.AssumptionCollectorAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.BMCAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.CEGARAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.CounterexampleCheckAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.FeatureVarsRestrictionAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.ProofCheckAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.RestartAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.RestartWithConditionsAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.impact.ImpactAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ForwardingReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.cpa.location.LocationCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;

@Options(prefix="analysis")
class CoreComponentsFactory {
    @Option(description="use assumption collecting algorithm")
    private boolean useAssumptionCollector = false;
    @Option(description="use adjustable conditions algorithm")
    private boolean useAdjustableConditions = false;
    @Option(description="use CEGAR algorithm for lazy counter-example guided analysis\nYou need to specify a refiner with the cegar.refiner option.\nCurrently all refiner require the use of the ARTCPA.")
    private boolean useRefinement = false;
    @Option(description="use CBMC to double-check counter-examples")
    private boolean useCBMC = false;
    @Option(description="use CBMC and the FeatureVars Restriction option")
    private boolean useFeatureVarsRestriction = false;
    @Option(description="use a BMC like algorithm that checks for satisfiability after the analysis has finished, works only with PredicateCPA")
    private boolean useBMC = false;
    @Option(description="Use McMillan's Impact algorithm for lazy interpolation")
    private boolean useImpactAlgorithm = false;
    @Option(name="restartAfterUnknown", description="restart the algorithm using a different CPA after unknown result")
    private boolean useRestartingAlgorithm = false;
    @Option(description="use a proof check algorithm to validate a previously generated proof")
    private boolean useProofCheckAlgorithm = false;
    private final Configuration config;
    private final LogManager logger;
    private final ReachedSetFactory reachedSetFactory;
    private final CPABuilder cpaFactory;

    public CoreComponentsFactory(Configuration pConfig, LogManager pLogger) throws InvalidConfigurationException {
        this.config = pConfig;
        this.logger = pLogger;
        this.config.inject((Object)this);
        this.reachedSetFactory = new ReachedSetFactory(this.config, this.logger);
        this.cpaFactory = new CPABuilder(this.config, this.logger, this.reachedSetFactory);
    }

    public Algorithm createAlgorithm(ConfigurableProgramAnalysis cpa, String filename, CFA cfa, MainCPAStatistics stats) throws InvalidConfigurationException, CPAException {
        Algorithm algorithm;
        this.logger.log(Level.FINE, new Object[]{"Creating algorithms"});
        if (this.useProofCheckAlgorithm) {
            this.logger.log(Level.INFO, new Object[]{"Using Proof Check Algorithm"});
            algorithm = new ProofCheckAlgorithm(cpa, this.config, this.logger);
        } else if (this.useRestartingAlgorithm) {
            this.logger.log(Level.INFO, new Object[]{"Using Restarting Algorithm"});
            algorithm = new RestartAlgorithm(this.config, this.logger, filename, cfa);
        } else if (this.useImpactAlgorithm) {
            algorithm = new ImpactAlgorithm(this.config, this.logger, cpa);
        } else {
            algorithm = new CPAAlgorithm(cpa, this.logger);
            if (this.useRefinement) {
                algorithm = new CEGARAlgorithm(algorithm, cpa, this.config, this.logger);
            }
            if (this.useBMC) {
                algorithm = new BMCAlgorithm(algorithm, cpa, this.config, this.logger, this.reachedSetFactory, cfa);
            }
            if (this.useCBMC) {
                algorithm = new CounterexampleCheckAlgorithm(algorithm, cpa, this.config, this.logger, this.reachedSetFactory, cfa);
            }
            if (this.useFeatureVarsRestriction) {
                algorithm = new FeatureVarsRestrictionAlgorithm(algorithm, cpa, this.config, this.logger, this.reachedSetFactory, cfa);
            }
            if (this.useAssumptionCollector) {
                algorithm = new AssumptionCollectorAlgorithm(algorithm, cpa, this.config, this.logger);
            }
            if (this.useAdjustableConditions) {
                algorithm = new RestartWithConditionsAlgorithm(algorithm, cpa, this.config, this.logger);
            }
        }
        if (algorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)algorithm)).collectStatistics(stats.getSubStatistics());
        }
        return algorithm;
    }

    public ReachedSet createReachedSet() {
        ReachedSet reached = this.reachedSetFactory.create();
        if (this.useRestartingAlgorithm) {
            reached = new ForwardingReachedSet(reached);
        }
        return reached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurableProgramAnalysis createCPA(CFA cfa, MainCPAStatistics stats) throws InvalidConfigurationException, CPAException {
        this.logger.log(Level.FINE, new Object[]{"Creating CPAs"});
        stats.cpaCreationTime.start();
        try {
            if (this.useRestartingAlgorithm) {
                ConfigurableProgramAnalysis configurableProgramAnalysis = LocationCPA.factory().set(cfa, CFA.class).createInstance();
                return configurableProgramAnalysis;
            }
            ConfigurableProgramAnalysis cpa = this.cpaFactory.buildCPAs(cfa);
            if (cpa instanceof StatisticsProvider) {
                ((StatisticsProvider)((Object)cpa)).collectStatistics(stats.getSubStatistics());
            }
            ConfigurableProgramAnalysis configurableProgramAnalysis = cpa;
            return configurableProgramAnalysis;
        }
        finally {
            stats.cpaCreationTime.stop();
        }
    }
}

