/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cpa.art.Path;

public class CounterexampleInfo {
    private final boolean spurious;
    private final Path targetPath;
    private final Object assignment;
    private final Collection<Pair<Object, File>> furtherInfo;
    private static final CounterexampleInfo SPURIOUS = new CounterexampleInfo(true, null, null);

    private CounterexampleInfo(boolean pSpurious, Path pTargetPath, Object pAssignment) {
        this.spurious = pSpurious;
        this.targetPath = pTargetPath;
        this.assignment = pAssignment;
        this.furtherInfo = !this.spurious ? Lists.newArrayListWithExpectedSize((int)1) : null;
    }

    public static CounterexampleInfo spurious() {
        return SPURIOUS;
    }

    public static CounterexampleInfo feasible(Path pTargetPath, Object pAssignment) {
        return new CounterexampleInfo(false, pTargetPath, pAssignment);
    }

    public boolean isSpurious() {
        return this.spurious;
    }

    public Path getTargetPath() {
        Preconditions.checkState((!this.spurious ? 1 : 0) != 0);
        return this.targetPath;
    }

    public Object getTargetPathAssignment() {
        Preconditions.checkState((!this.spurious ? 1 : 0) != 0);
        return this.assignment;
    }

    public void addFurtherInformation(Object info, File dumpFile) {
        Preconditions.checkState((!this.spurious ? 1 : 0) != 0);
        this.furtherInfo.add((Pair<Object, File>)Pair.of((Object)Preconditions.checkNotNull((Object)info), (Object)dumpFile));
    }

    public Collection<Pair<Object, File>> getAllFurtherInformation() {
        Preconditions.checkState((!this.spurious ? 1 : 0) != 0);
        return Collections.unmodifiableCollection(this.furtherInfo);
    }
}

