/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.sosy_lab.common.Files;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Timer;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFACreator;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.LocationMappedReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.PartitionedReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.util.AbstractElements;

@Options
class MainCPAStatistics
implements Statistics {
    @Option(name="reachedSet.export", description="print reached set to text file")
    private boolean exportReachedSet = true;
    @Option(name="reachedSet.file", description="print reached set to text file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private File outputFile = new File("reached.txt");
    @Option(name="statistics.memory", description="track memory usage of JVM during runtime")
    private boolean monitorMemoryUsage = true;
    private final LogManager logger;
    private final Collection<Statistics> subStats;
    private final MemoryStatistics memStats;
    final Timer programTime = new Timer();
    final Timer creationTime = new Timer();
    final Timer cpaCreationTime = new Timer();
    final Timer analysisTime = new Timer();
    private CFACreator cfaCreator;

    public MainCPAStatistics(Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        this.logger = pLogger;
        config.inject((Object)this);
        this.subStats = new ArrayList<Statistics>();
        if (this.monitorMemoryUsage) {
            this.memStats = new MemoryStatistics(pLogger);
            this.memStats.setDaemon(true);
            this.memStats.start();
        } else {
            this.memStats = null;
        }
        this.programTime.start();
    }

    public Collection<Statistics> getSubStatistics() {
        return this.subStats;
    }

    @Override
    public String getName() {
        return "CPAchecker";
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, ReachedSet reached) {
        Map.Entry<Object, Collection<AbstractElement>> maxPartition;
        int locs;
        if (this.analysisTime.isRunning()) {
            this.analysisTime.stop();
        }
        if (this.programTime.isRunning()) {
            this.programTime.stop();
        }
        if (this.memStats != null) {
            this.memStats.interrupt();
        }
        if (this.exportReachedSet && this.outputFile != null) {
            try {
                Files.writeFile((File)this.outputFile, (Object)Joiner.on((char)'\n').join((Iterable)reached));
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write reached set to file");
            }
            catch (OutOfMemoryError e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write reached set to file due to memory problems");
            }
        }
        for (Statistics s : this.subStats) {
            String name = s.getName();
            if (!Strings.isNullOrEmpty((String)name)) {
                name = name + " statistics";
                out.println(name);
                out.println(Strings.repeat((String)"-", (int)name.length()));
            }
            s.printStatistics(out, result, reached);
            if (Strings.isNullOrEmpty((String)name)) continue;
            out.println();
        }
        int reachedSize = reached.size();
        out.println("CPAchecker general statistics");
        out.println("-----------------------------");
        out.println("Size of reached set:          " + reachedSize);
        if (reached instanceof LocationMappedReachedSet) {
            LocationMappedReachedSet l = (LocationMappedReachedSet)reached;
            locs = l.getNumberOfPartitions();
            out.println("  Number of locations:        " + locs);
            out.println("    Avg states per loc.:      " + reachedSize / locs);
            maxPartition = l.getMaxPartition();
            out.println("    Max states per loc.:      " + maxPartition.getValue().size() + " (at node " + maxPartition.getKey() + ")");
        } else {
            HashMultiset allLocations = HashMultiset.create(AbstractElements.extractLocations(reached));
            locs = allLocations.entrySet().size();
            out.println("  Number of locations:        " + locs);
            out.println("    Avg states per loc.:      " + reachedSize / locs);
            int max = 0;
            CFANode maxLoc = null;
            for (Multiset.Entry location : allLocations.entrySet()) {
                int size = location.getCount();
                if (size <= max) continue;
                max = size;
                maxLoc = (CFANode)location.getElement();
            }
            out.println("    Max states per loc.:      " + max + " (at node " + maxLoc + ")");
        }
        if (reached instanceof PartitionedReachedSet) {
            PartitionedReachedSet p = (PartitionedReachedSet)reached;
            int partitions = p.getNumberOfPartitions();
            out.println("  Number of partitions:       " + partitions);
            out.println("    Avg size of partitions:   " + reachedSize / partitions);
            maxPartition = p.getMaxPartition();
            out.println("    Max size of partitions:   " + maxPartition.getValue().size() + " (with key " + maxPartition.getKey() + ")");
        }
        out.println("  Number of target elements:  " + Iterables.size(AbstractElements.filterTargetElements(reached)));
        out.println("Time for analysis setup:      " + this.creationTime);
        out.println("  Time for loading CPAs:      " + this.cpaCreationTime);
        if (this.cfaCreator != null) {
            out.println("  Time for loading C parser:  " + this.cfaCreator.parserInstantiationTime);
            out.println("  Time for CFA construction:  " + this.cfaCreator.totalTime);
            out.println("    Time for parsing C file:  " + this.cfaCreator.parsingTime);
            out.println("    Time for AST to CFA:      " + this.cfaCreator.conversionTime);
            out.println("    Time for CFA sanity check:" + this.cfaCreator.checkTime);
            out.println("    Time for post-processing: " + this.cfaCreator.processingTime);
            if (this.cfaCreator.pruningTime.getNumberOfIntervals() > 0) {
                out.println("    Time for CFA pruning:     " + this.cfaCreator.pruningTime);
            }
            if (this.cfaCreator.exportTime.getNumberOfIntervals() > 0) {
                out.println("    Time for CFA export:      " + this.cfaCreator.exportTime);
            }
        }
        out.println("Time for Analysis:            " + this.analysisTime);
        out.println("Total time for CPAchecker:    " + this.programTime);
        out.println("");
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        HashSet<String> gcNames = new HashSet<String>();
        long gcTime = 0L;
        int gcCount = 0;
        for (GarbageCollectorMXBean gcBean : gcBeans) {
            gcTime += gcBean.getCollectionTime();
            gcCount = (int)((long)gcCount + gcBean.getCollectionCount());
            gcNames.add(gcBean.getName());
        }
        out.println("Time for Garbage Collector:   " + Timer.formatTime((long)gcTime) + " (in " + gcCount + " runs)");
        out.println("Garbage Collector(s) used:    " + Joiner.on((String)", ").join(gcNames));
        if (this.memStats != null) {
            try {
                this.memStats.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            out.println("Used heap memory:             " + MainCPAStatistics.formatMem(this.memStats.maxHeap) + " max (" + MainCPAStatistics.formatMem(this.memStats.sumHeap / this.memStats.count) + " avg)");
            out.println("Used non-heap memory:         " + MainCPAStatistics.formatMem(this.memStats.maxNonHeap) + " max (" + MainCPAStatistics.formatMem(this.memStats.sumNonHeap / this.memStats.count) + " avg)");
            out.println("Allocated heap memory:        " + MainCPAStatistics.formatMem(this.memStats.maxHeapAllocated) + " max (" + MainCPAStatistics.formatMem(this.memStats.sumHeapAllocated / this.memStats.count) + " avg)");
            out.println("Allocated non-heap memory:    " + MainCPAStatistics.formatMem(this.memStats.maxNonHeapAllocated) + " max (" + MainCPAStatistics.formatMem(this.memStats.sumNonHeapAllocated / this.memStats.count) + " avg)");
            if (this.memStats.osMbean != null) {
                out.println("Total process virtual memory: " + MainCPAStatistics.formatMem(this.memStats.maxProcess) + " max (" + MainCPAStatistics.formatMem(this.memStats.sumProcess / this.memStats.count) + " avg)");
            }
        }
    }

    private static String formatMem(long mem) {
        return String.format("%,9dMB", mem >> 20);
    }

    public void setCFACreator(CFACreator pCfaCreator) {
        Preconditions.checkState((this.cfaCreator == null ? 1 : 0) != 0);
        this.cfaCreator = pCfaCreator;
    }

    private static class MemoryStatistics
    extends Thread {
        private static final long MEMORY_CHECK_INTERVAL = 100L;
        private final LogManager logger;
        private long maxHeap = 0L;
        private long sumHeap = 0L;
        private long maxHeapAllocated = 0L;
        private long sumHeapAllocated = 0L;
        private long maxNonHeap = 0L;
        private long sumNonHeap = 0L;
        private long maxNonHeapAllocated = 0L;
        private long sumNonHeapAllocated = 0L;
        private long maxProcess = 0L;
        private long sumProcess = 0L;
        private long count = 0L;
        private final MBeanServer mbeanServer;
        private ObjectName osMbean;
        private static final String MEMORY_SIZE = "CommittedVirtualMemorySize";

        private MemoryStatistics(LogManager pLogger) {
            super("CPAchecker memory statistics collector");
            this.logger = pLogger;
            this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
            try {
                this.osMbean = new ObjectName("java.lang", "type", "OperatingSystem");
            }
            catch (MalformedObjectNameException e) {
                this.logger.logDebugException((Throwable)e, "Accessing OperatingSystemMXBean failed");
                this.osMbean = null;
            }
        }

        @Override
        public void run() {
            MemoryMXBean mxBean = ManagementFactory.getMemoryMXBean();
            List<MemoryPoolMXBean> poolBeans = ManagementFactory.getMemoryPoolMXBeans();
            Iterator<MemoryPoolMXBean> it = poolBeans.iterator();
            while (it.hasNext()) {
                MemoryPoolMXBean pool = it.next();
                if (pool.isCollectionUsageThresholdSupported() && !pool.getName().contains("Survivor")) {
                    long threshold = (long)((double)pool.getUsage().getMax() * 0.99);
                    pool.setCollectionUsageThreshold(threshold);
                    this.logger.log(Level.INFO, new Object[]{"Setting threshold of pool", pool.getName(), "to", MainCPAStatistics.formatMem(threshold).trim()});
                    continue;
                }
                it.remove();
            }
            long[] poolCollectionUsageThresholdCounts = new long[poolBeans.size()];
            while (true) {
                ++this.count;
                int i = 0;
                for (MemoryPoolMXBean pool : poolBeans) {
                    long collectionUsageThresholdCount;
                    if (pool.isCollectionUsageThresholdExceeded() && (collectionUsageThresholdCount = pool.getCollectionUsageThresholdCount()) > poolCollectionUsageThresholdCounts[i]) {
                        this.logger.log(Level.WARNING, new Object[]{"Collection threshold exceeded in pool", pool.getName() + ":", pool.getCollectionUsage()});
                        poolCollectionUsageThresholdCounts[i] = collectionUsageThresholdCount;
                    }
                    ++i;
                }
                MemoryUsage currentHeap = mxBean.getHeapMemoryUsage();
                long currentHeapUsed = currentHeap.getUsed();
                this.maxHeap = Math.max(this.maxHeap, currentHeapUsed);
                this.sumHeap += currentHeapUsed;
                long currentHeapAllocated = currentHeap.getCommitted();
                this.maxHeapAllocated = Math.max(this.maxHeapAllocated, currentHeapAllocated);
                this.sumHeapAllocated += currentHeapAllocated;
                MemoryUsage currentNonHeap = mxBean.getNonHeapMemoryUsage();
                long currentNonHeapUsed = currentNonHeap.getUsed();
                this.maxNonHeap = Math.max(this.maxNonHeap, currentNonHeapUsed);
                this.sumNonHeap += currentNonHeapUsed;
                long currentNonHeapAllocated = currentNonHeap.getCommitted();
                this.maxNonHeapAllocated = Math.max(this.maxNonHeapAllocated, currentNonHeapAllocated);
                this.sumNonHeapAllocated += currentNonHeapAllocated;
                if (this.osMbean != null) {
                    try {
                        long memUsed = (Long)this.mbeanServer.getAttribute(this.osMbean, MEMORY_SIZE);
                        this.maxProcess = Math.max(this.maxProcess, memUsed);
                        this.sumProcess += memUsed;
                    }
                    catch (JMException e) {
                        this.logger.logDebugException((Throwable)e, "Querying memory size failed");
                        this.osMbean = null;
                    }
                    catch (ClassCastException e) {
                        this.logger.logDebugException((Throwable)e, "Querying memory size failed");
                        this.osMbean = null;
                    }
                }
                try {
                    MemoryStatistics.sleep(100L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }
}

