/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.sosy_lab.common.Files;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.WrapperCPA;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.cpa.art.Path;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageCPA;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageElement;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.AbstractElements;
import org.sosy_lab.cpachecker.util.assumptions.AssumptionWithLocation;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;

@Options(prefix="assumptions")
public class AssumptionCollectorAlgorithm
implements Algorithm,
StatisticsProvider {
    private int automatonStates = 0;
    @Option(name="export", description="write collected assumptions to file")
    private boolean exportAssumptions = true;
    @Option(name="file", description="write collected assumptions to file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private File assumptionsFile = new File("assumptions.txt");
    @Option(name="automatonFile", description="write collected assumptions as automaton to file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private File assumptionAutomatonFile = new File("AssumptionAutomaton.txt");
    private final LogManager logger;
    private final Algorithm innerAlgorithm;
    private final FormulaManager formulaManager;
    private final AssumptionWithLocation exceptionAssumptions;
    private final AssumptionStorageCPA cpa;
    private final Set<Integer> exceptionElements = new HashSet<Integer>();

    public AssumptionCollectorAlgorithm(Algorithm algo, ConfigurableProgramAnalysis pCpa, Configuration config, LogManager logger) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = logger;
        this.innerAlgorithm = algo;
        this.cpa = ((WrapperCPA)((Object)pCpa)).retrieveWrappedCpa(AssumptionStorageCPA.class);
        if (this.cpa == null) {
            throw new InvalidConfigurationException("AssumptionStorageCPA needed for AssumptionCollectionAlgorithm");
        }
        this.formulaManager = this.cpa.getFormulaManager();
        this.exceptionAssumptions = new AssumptionWithLocation(this.formulaManager);
    }

    @Override
    public boolean run(ReachedSet reached) throws CPAException, InterruptedException {
        boolean sound = true;
        boolean restartCPA = false;
        do {
            restartCPA = false;
            try {
                sound &= this.innerAlgorithm.run(reached);
            }
            catch (RefinementFailedException failedRefinement) {
                this.logger.log(Level.FINER, new Object[]{"Dumping assumptions due to:", failedRefinement});
                Path path = failedRefinement.getErrorPath();
                ARTElement errorElement = (ARTElement)((Pair)path.getLast()).getFirst();
                assert (errorElement == reached.getLastElement());
                ARTElement parent = (ARTElement)Iterables.getOnlyElement(errorElement.getParents());
                reached.removeOnlyFromWaitlist(parent);
                this.exceptionElements.add(parent.getElementId());
                this.addAvoidingAssumptions(this.exceptionAssumptions, parent);
                reached.remove(errorElement);
                errorElement.removeFromART();
                restartCPA = true;
                sound = false;
            }
            catch (CPAException e) {
                this.logger.log(Level.FINER, new Object[]{"Dumping assumptions due to: " + e.toString()});
            }
        } while (restartCPA);
        return sound;
    }

    private AssumptionWithLocation collectLocationAssumptions(ReachedSet reached, AssumptionWithLocation exceptionAssumptions) {
        AssumptionWithLocation result = AssumptionWithLocation.copyOf(exceptionAssumptions);
        this.logger.log(Level.FINER, new Object[]{"Dumping assumptions resulting from tool assumptions"});
        for (AbstractElement element : reached) {
            if (AbstractElements.isTargetElement(element)) {
                this.addAvoidingAssumptions(result, element);
                continue;
            }
            AssumptionStorageElement e = AbstractElements.extractElementByType(element, AssumptionStorageElement.class);
            Formula assumption = this.formulaManager.makeAnd(e.getAssumption(), e.getStopFormula());
            if (assumption.isTrue()) continue;
            this.addAssumption(result, assumption, element);
        }
        this.logger.log(Level.FINER, new Object[]{"Dumping assumptions resulting from waitlist elements"});
        for (AbstractElement element : reached.getWaitlist()) {
            this.addAvoidingAssumptions(result, element);
        }
        return result;
    }

    private void addAssumption(AssumptionWithLocation invariant, Formula assumption, AbstractElement state) {
        Formula dataRegion = AbstractElements.extractReportedFormulas(this.formulaManager, state);
        CFANode loc = AbstractElements.extractLocation(state);
        assert (loc != null);
        invariant.add(loc, this.formulaManager.makeOr(assumption, this.formulaManager.makeNot(dataRegion)));
    }

    private void addAvoidingAssumptions(AssumptionWithLocation invariant, AbstractElement element) {
        this.addAssumption(invariant, this.formulaManager.makeFalse(), element);
    }

    private String produceAssumptionAutomaton(ReachedSet reached) {
        AbstractElement firstElement = reached.getFirstElement();
        if (!(firstElement instanceof ARTElement)) {
            return "Cannot dump assumption as automaton if ARTCPA is not used.";
        }
        HashSet falseAssumptionElements = Sets.newHashSet(reached.getWaitlist());
        HashSet<ARTElement> relevantElements = new HashSet<ARTElement>();
        for (AbstractElement element : reached) {
            ARTElement e = (ARTElement)element;
            AssumptionStorageElement asmptElement = AbstractElements.extractElementByType(e, AssumptionStorageElement.class);
            if (e.isTarget() || asmptElement.isStop() || this.exceptionElements.contains(e.getElementId())) {
                falseAssumptionElements.add(e);
            }
            if (relevantElements.contains(e) || asmptElement.getAssumption().isTrue() && !falseAssumptionElements.contains(e)) continue;
            this.findAllParents(e, relevantElements);
        }
        ARTElement rootElement = (ARTElement)reached.getFirstElement();
        TreeSet<ARTElement> childrenOfRelevantElements = new TreeSet<ARTElement>(relevantElements);
        childrenOfRelevantElements.add(rootElement);
        for (ARTElement e : relevantElements) {
            childrenOfRelevantElements.addAll(e.getChildren());
            if (!e.isCovered()) continue;
            childrenOfRelevantElements.add(e.getCoveringElement());
        }
        return this.writeAutomaton(rootElement, childrenOfRelevantElements, relevantElements, falseAssumptionElements);
    }

    private String writeAutomaton(ARTElement initialElement, Set<ARTElement> allElements, Set<ARTElement> relevantElements, Set<AbstractElement> falseAssumptionElements) {
        StringBuilder sb = new StringBuilder();
        sb.append("OBSERVER AUTOMATON AssumptionAutomaton\n\n");
        sb.append("INITIAL STATE ART" + initialElement.getElementId() + ";\n\n");
        sb.append("STATE __TRUE :\n");
        sb.append("    TRUE -> ASSUME \"true\" GOTO __TRUE;\n\n");
        if (!falseAssumptionElements.isEmpty()) {
            sb.append("STATE __FALSE :\n");
            sb.append("    TRUE -> ASSUME \"false\" GOTO __FALSE;\n\n");
        }
        for (ARTElement e : allElements) {
            if (e.isCovered() || falseAssumptionElements.contains(e)) continue;
            sb.append("STATE USEFIRST ART" + e.getElementId() + " :\n");
            ++this.automatonStates;
            if (!relevantElements.contains(e)) {
                sb.append("   TRUE -> GOTO __TRUE;\n\n");
                continue;
            }
            CFANode loc = AbstractElements.extractLocation(e);
            for (ARTElement child : e.getChildren()) {
                if (child.isCovered()) {
                    child = child.getCoveringElement();
                    assert (!child.isCovered());
                }
                CFANode childLoc = AbstractElements.extractLocation(child);
                CFAEdge edge = loc.getEdgeTo(childLoc);
                sb.append("    MATCH \"");
                AssumptionCollectorAlgorithm.escape(edge.getRawStatement(), sb);
                sb.append("\" -> ");
                AssumptionStorageElement assumptionChild = AbstractElements.extractElementByType(child, AssumptionStorageElement.class);
                Formula assumption = this.formulaManager.makeAnd(assumptionChild.getAssumption(), assumptionChild.getStopFormula());
                sb.append("ASSUME \"");
                AssumptionCollectorAlgorithm.escape(assumption.toString(), sb);
                sb.append("\" ");
                if (falseAssumptionElements.contains(child)) {
                    sb.append("GOTO __FALSE");
                } else {
                    sb.append("GOTO ART" + child.getElementId());
                }
                sb.append(";\n");
            }
            sb.append("    TRUE -> GOTO __TRUE;\n\n");
        }
        sb.append("END AUTOMATON\n");
        return sb.toString();
    }

    private void findAllParents(ARTElement e, Set<ARTElement> parentSet) {
        ArrayDeque<ARTElement> toAdd = new ArrayDeque<ARTElement>();
        toAdd.add(e);
        while (!toAdd.isEmpty()) {
            ARTElement current = (ARTElement)toAdd.pop();
            if (!parentSet.add(current)) continue;
            toAdd.addAll(current.getParents());
            toAdd.addAll(current.getCoveredByThis());
        }
    }

    private static void escape(String s, StringBuilder appendTo) {
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    appendTo.append("\\n");
                    continue block5;
                }
                case '\"': {
                    appendTo.append("\\\"");
                    continue block5;
                }
                case '\\': {
                    appendTo.append("\\\\");
                    continue block5;
                }
                default: {
                    appendTo.append(c);
                }
            }
        }
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.innerAlgorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.innerAlgorithm)).collectStatistics(pStatsCollection);
        }
        pStatsCollection.add(new AssumptionCollectionStatistics());
    }

    private class AssumptionCollectionStatistics
    implements Statistics {
        private AssumptionCollectionStatistics() {
        }

        @Override
        public String getName() {
            return "Assumption Collection algorithm";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, ReachedSet pReached) {
            AssumptionWithLocation resultAssumption = AssumptionCollectorAlgorithm.this.collectLocationAssumptions(pReached, AssumptionCollectorAlgorithm.this.exceptionAssumptions);
            out.println("Number of locations with assumptions: " + resultAssumption.getNumberOfLocations());
            if (AssumptionCollectorAlgorithm.this.exportAssumptions) {
                if (AssumptionCollectorAlgorithm.this.assumptionsFile != null) {
                    try {
                        Files.writeFile((File)AssumptionCollectorAlgorithm.this.assumptionsFile, (Object)resultAssumption);
                    }
                    catch (IOException e) {
                        AssumptionCollectorAlgorithm.this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write assumptions to file");
                    }
                }
                if (AssumptionCollectorAlgorithm.this.assumptionAutomatonFile != null) {
                    try {
                        Files.writeFile((File)AssumptionCollectorAlgorithm.this.assumptionAutomatonFile, (Object)AssumptionCollectorAlgorithm.this.produceAssumptionAutomaton(pReached));
                    }
                    catch (IOException e) {
                        AssumptionCollectorAlgorithm.this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write assumptions to file");
                    }
                    out.println("Number of states in automaton:        " + AssumptionCollectorAlgorithm.this.automatonStates);
                }
            }
        }
    }
}

