/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.Concurrency;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Timer;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionReturnEdge;
import org.sosy_lab.cpachecker.core.CPABuilder;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.WrapperCPA;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.cpa.art.ARTCPA;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.cpa.art.ARTUtils;
import org.sosy_lab.cpachecker.cpa.art.Path;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageElement;
import org.sosy_lab.cpachecker.cpa.loopstack.LoopstackElement;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractElement;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractElements;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.predicates.Model;
import org.sosy_lab.cpachecker.util.predicates.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.TheoremProver;

@Options(prefix="bmc")
public class BMCAlgorithm
implements Algorithm,
StatisticsProvider {
    private static final Function<AbstractElement, PredicateAbstractElement> EXTRACT_PREDICATE_ELEMENT = AbstractElements.extractElementByTypeFunction(PredicateAbstractElement.class);
    private static final Predicate<AbstractElement> IS_STOP_ELEMENT = Predicates.compose((Predicate)new Predicate<AssumptionStorageElement>(){

        public boolean apply(AssumptionStorageElement pArg0) {
            return pArg0 != null && pArg0.isStop();
        }
    }, AbstractElements.extractElementByTypeFunction(AssumptionStorageElement.class));
    private static final Predicate<AbstractElement> IS_IN_LOOP = new Predicate<AbstractElement>(){

        public boolean apply(AbstractElement pArg0) {
            LoopstackElement loopElement = AbstractElements.extractElementByType(pArg0, LoopstackElement.class);
            return loopElement.getLoop() != null;
        }
    };
    @Option(description="If BMC did not find a bug, check whether the bounding did actually remove parts of the state space (this is similar to CBMC's unwinding assertions).")
    private boolean boundingAssertions = true;
    @Option(description="Check reachability of target states after analysis (classical BMC). The alternative is to check the reachability as soon as the target states are discovered, which is done if cpa.predicate.targetStateSatCheck=true.")
    private boolean checkTargetStates = true;
    @Option(description="try using induction to verify programs with loops")
    private boolean induction = false;
    @Option(description="dump counterexample formula to file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private File dumpCounterexampleFormula = new File("counterexample.msat");
    private final BMCStatistics stats = new BMCStatistics();
    private final Algorithm algorithm;
    private final ConfigurableProgramAnalysis cpa;
    private final InvariantGenerator invariantGenerator;
    private final FormulaManager fmgr;
    private final PathFormulaManager pmgr;
    private final TheoremProver prover;
    private final LogManager logger;
    private final ReachedSetFactory reachedSetFactory;
    private final CFA cfa;

    private static <T> boolean none(Iterable<T> iterable, Predicate<? super T> predicate) {
        return !Iterables.any(iterable, predicate);
    }

    public BMCAlgorithm(Algorithm algorithm, ConfigurableProgramAnalysis pCpa, Configuration config, LogManager logger, ReachedSetFactory pReachedSetFactory, CFA pCfa) throws InvalidConfigurationException, CPAException {
        config.inject((Object)this);
        this.algorithm = algorithm;
        this.cpa = pCpa;
        this.logger = logger;
        this.reachedSetFactory = pReachedSetFactory;
        this.cfa = pCfa;
        this.invariantGenerator = new InvariantGenerator(config, logger, this.reachedSetFactory, this.cfa);
        PredicateCPA predCpa = ((WrapperCPA)((Object)this.cpa)).retrieveWrappedCpa(PredicateCPA.class);
        if (predCpa == null) {
            throw new InvalidConfigurationException("PredicateCPA needed for BMCAlgorithm");
        }
        this.fmgr = predCpa.getFormulaManager();
        this.pmgr = predCpa.getPathFormulaManager();
        this.prover = predCpa.getSolver().getTheoremProver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean run(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        if (this.induction) {
            CFANode initialLocation = AbstractElements.extractLocation(pReachedSet.getFirstElement());
            this.invariantGenerator.start(initialLocation);
        }
        try {
            this.logger.log(Level.INFO, new Object[]{"Creating formula for program"});
            boolean soundInner = this.algorithm.run(pReachedSet);
            if (Iterables.any((Iterable)Iterables.transform((Iterable)Iterables.skip((Iterable)pReachedSet, (int)1), EXTRACT_PREDICATE_ELEMENT), PredicateAbstractElement.FILTER_ABSTRACTION_ELEMENTS)) {
                this.logger.log(Level.WARNING, new Object[]{"BMC algorithm does not work with abstractions. Could not check for satisfiability!"});
                boolean bl = soundInner;
                return bl;
            }
            this.prover.init();
            try {
                boolean safe = this.checkTargetStates(pReachedSet);
                this.logger.log(Level.FINER, new Object[]{"Program is safe?:", safe});
                if (!safe) {
                    this.createErrorPath(pReachedSet);
                }
                this.prover.pop();
                boolean sound = false;
                if (soundInner && safe) {
                    sound = this.checkBoundingAssertions(pReachedSet);
                    if (this.induction) {
                        sound = sound || this.checkWithInduction();
                    }
                }
                boolean bl = sound && soundInner;
                this.prover.reset();
                return bl;
            }
            catch (Throwable throwable) {
                this.prover.reset();
                throw throwable;
            }
        }
        finally {
            this.invariantGenerator.cancelAndWait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createErrorPath(ReachedSet pReachedSet) throws CPATransferException {
        if (!(this.cpa instanceof ARTCPA)) {
            this.logger.log(Level.INFO, new Object[]{"Error found, but error path cannot be created without ARTCPA"});
            return;
        }
        this.stats.errorPathCreation.start();
        try {
            Path targetPath;
            boolean stillSatisfiable;
            this.logger.log(Level.INFO, new Object[]{"Error found, creating error path"});
            Iterable art = Iterables.filter(pReachedSet.getReached(), ARTElement.class);
            Formula branchingFormula = this.pmgr.buildBranchingFormula(art);
            if (branchingFormula.isTrue()) {
                this.logger.log(Level.WARNING, new Object[]{"Could not create error path because of missing branching informating"});
                return;
            }
            this.prover.push(branchingFormula);
            boolean bl = stillSatisfiable = !this.prover.isUnsat();
            if (!stillSatisfiable) {
                this.logger.log(Level.WARNING, new Object[]{"Could not create error path information because of inconsistent branching information!"});
                return;
            }
            Model model = this.prover.getModel();
            this.prover.pop();
            Map<Integer, Boolean> branchingInformation = this.pmgr.getBranchingPredicateValuesFromModel(model);
            ARTElement root = (ARTElement)pReachedSet.getFirstElement();
            try {
                targetPath = ARTUtils.getPathFromBranchingInformation(root, pReachedSet.getReached(), branchingInformation);
            }
            catch (IllegalArgumentException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not create error path");
                this.stats.errorPathCreation.stop();
                return;
            }
            Formula pathFormula = this.pmgr.makeFormulaForPath(targetPath.asEdgesList()).getFormula();
            this.prover.pop();
            this.prover.push(pathFormula);
            if (this.prover.isUnsat()) {
                this.logger.log(Level.WARNING, new Object[]{"Inconsistent replayed error path!"});
            } else {
                model = this.prover.getModel();
            }
            CounterexampleInfo counterexample = CounterexampleInfo.feasible(targetPath, (Object)model);
            if (pathFormula != null) {
                counterexample.addFurtherInformation(pathFormula, this.dumpCounterexampleFormula);
            }
            ((ARTCPA)this.cpa).setCounterexample(counterexample);
        }
        finally {
            this.stats.errorPathCreation.stop();
        }
    }

    private boolean checkTargetStates(ReachedSet pReachedSet) {
        if (this.checkTargetStates) {
            ArrayList targetElements = Lists.newArrayList(AbstractElements.filterTargetElements(pReachedSet));
            this.logger.log(Level.FINER, new Object[]{"Found", targetElements.size(), "potential target elements"});
            Formula program = this.createFormulaFor(targetElements);
            this.logger.log(Level.INFO, new Object[]{"Starting satisfiability check..."});
            this.stats.satCheck.start();
            this.prover.push(program);
            boolean safe = this.prover.isUnsat();
            this.stats.satCheck.stop();
            if (safe) {
                pReachedSet.removeAll(targetElements);
            }
            return safe;
        }
        return BMCAlgorithm.none(pReachedSet, AbstractElements.IS_TARGET_ELEMENT);
    }

    private boolean checkBoundingAssertions(ReachedSet pReachedSet) {
        if (this.boundingAssertions) {
            Iterable stopElements = Iterables.filter((Iterable)pReachedSet, IS_STOP_ELEMENT);
            Formula assertions = this.createFormulaFor(stopElements);
            this.logger.log(Level.INFO, new Object[]{"Starting assertions check..."});
            this.stats.assertionsCheck.start();
            this.prover.push(assertions);
            boolean sound = this.prover.isUnsat();
            this.prover.pop();
            this.stats.assertionsCheck.stop();
            this.logger.log(Level.FINER, new Object[]{"Soundness after assertion checks:", sound});
            return sound;
        }
        return BMCAlgorithm.none(pReachedSet, IS_STOP_ELEMENT);
    }

    private Formula createFormulaFor(Iterable<AbstractElement> elements) {
        Formula f = this.fmgr.makeFalse();
        for (PredicateAbstractElement e : AbstractElements.projectToType(elements, PredicateAbstractElement.class)) {
            f = this.fmgr.makeOr(f, e.getPathFormula().getFormula());
        }
        return f;
    }

    private boolean checkWithInduction() throws CPAException, InterruptedException {
        if (!this.cfa.getLoopStructure().isPresent()) {
            this.logger.log(Level.WARNING, new Object[]{"Could not use induction for proving program safety, loop structure of program could not be determined."});
            return false;
        }
        Multimap loops = (Multimap)this.cfa.getLoopStructure().get();
        if (loops.size() > 1) {
            this.logger.log(Level.WARNING, new Object[]{"Could not use induction for proving program safety, program has too many loops"});
            return false;
        }
        if (loops.isEmpty()) {
            return true;
        }
        this.stats.inductionPreparation.start();
        CFAUtils.Loop loop = (CFAUtils.Loop)Iterables.getOnlyElement((Iterable)loops.values());
        Iterable incomingEdges = Iterables.filter(loop.getIncomingEdges(), (Predicate)Predicates.not((Predicate)Predicates.instanceOf(FunctionReturnEdge.class)));
        Iterable outgoingEdges = Iterables.filter(loop.getOutgoingEdges(), (Predicate)Predicates.not((Predicate)Predicates.instanceOf(FunctionCallEdge.class)));
        if (Iterables.size((Iterable)incomingEdges) > 1) {
            this.logger.log(Level.WARNING, new Object[]{"Could not use induction for proving program safety, loop has too many incoming edges", incomingEdges});
            return false;
        }
        if (loop.getLoopHeads().size() > 1) {
            this.logger.log(Level.WARNING, new Object[]{"Could not use induction for proving program safety, loop has too many loop heads"});
            return false;
        }
        CFANode loopHead = (CFANode)Iterables.getOnlyElement(loop.getLoopHeads());
        assert (loopHead.equals(((CFAEdge)Iterables.getOnlyElement((Iterable)incomingEdges)).getSuccessor()));
        ReachedSet reached = this.reachedSetFactory.create();
        reached.add(this.cpa.getInitialElement(loopHead), this.cpa.getInitialPrecision(loopHead));
        this.logger.log(Level.INFO, new Object[]{"Running algorithm to create induction hypothesis"});
        this.algorithm.run(reached);
        ImmutableListMultimap reachedPerLocation = Multimaps.index((Iterable)reached, AbstractElements.EXTRACT_LOCATION);
        Iterable loopStates = Iterables.filter((Iterable)reached, IS_IN_LOOP);
        assert (!Iterables.isEmpty((Iterable)loopStates));
        if (Iterables.any((Iterable)loopStates, AbstractElements.IS_TARGET_ELEMENT)) {
            this.logger.log(Level.WARNING, new Object[]{"Could not use induction for proving program safety, target state is contained in the loop"});
            return false;
        }
        Formula invariants = this.extractInvariantsAt(loopHead, this.invariantGenerator.get());
        invariants = this.fmgr.instantiate(invariants, SSAMap.emptySSAMap().withDefault(1));
        Formula inductions = this.fmgr.makeTrue();
        for (CFAEdge outgoingEdge : outgoingEdges) {
            CFANode exitLocation = outgoingEdge.getSuccessor();
            Collection exitStates = reachedPerLocation.get((Object)exitLocation);
            ARTElement lastExitState = (ARTElement)Iterables.getLast((Iterable)exitStates);
            Set<ARTElement> outOfLoopStates = lastExitState.getSubtree();
            if (Iterables.isEmpty(AbstractElements.filterTargetElements(outOfLoopStates))) continue;
            this.stats.inductionCutPoints++;
            this.logger.log(Level.FINEST, new Object[]{"Considering exit edge", outgoingEdge});
            CFANode cutPoint = outgoingEdge.getPredecessor();
            Collection cutPointStates = reachedPerLocation.get((Object)cutPoint);
            AbstractElement lastcutPointState = (AbstractElement)Iterables.getLast((Iterable)cutPointStates);
            PathFormula pathFormulaAB = AbstractElements.extractElementByType(lastcutPointState, PredicateAbstractElement.class).getPathFormula();
            Formula formulaAB = this.fmgr.makeAnd(invariants, pathFormulaAB.getFormula());
            PathFormula empty = this.pmgr.makeEmptyPathFormula(pathFormulaAB);
            PathFormula pathFormulaC = this.pmgr.makeAnd(empty, outgoingEdge);
            Formula formulaC = this.fmgr.makeNot(pathFormulaC.getFormula());
            Formula f = this.fmgr.makeOr(this.fmgr.makeNot(formulaAB), formulaC);
            inductions = this.fmgr.makeAnd(inductions, f);
        }
        inductions = this.fmgr.makeNot(inductions);
        this.stats.inductionPreparation.stop();
        this.logger.log(Level.INFO, new Object[]{"Starting induction check..."});
        this.stats.inductionCheck.start();
        this.prover.push(inductions);
        boolean sound = this.prover.isUnsat();
        this.prover.pop();
        this.stats.inductionCheck.stop();
        if (!sound && this.logger.wouldBeLogged(Level.ALL)) {
            this.logger.log(Level.ALL, new Object[]{"Model returned for induction check:", this.prover.getModel()});
        }
        this.logger.log(Level.FINER, new Object[]{"Soundness after induction check:", sound});
        return sound;
    }

    private Formula extractInvariantsAt(CFANode loc, ReachedSet reached) {
        if (reached.isEmpty()) {
            return this.fmgr.makeTrue();
        }
        Formula invariant = this.fmgr.makeFalse();
        for (AbstractElement locState : AbstractElements.filterLocation(reached, loc)) {
            Formula f = AbstractElements.extractReportedFormulas(this.fmgr, locState);
            this.logger.log(Level.ALL, new Object[]{"Invariant:", f});
            invariant = this.fmgr.makeOr(invariant, f);
        }
        return invariant;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.algorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.algorithm)).collectStatistics(pStatsCollection);
        }
        pStatsCollection.add(this.stats);
    }

    @Options(prefix="bmc")
    private static class InvariantGenerator {
        @Option(name="invariantGenerationConfigFile", description="configuration file for invariant generation")
        @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
        private File configFile;
        @Option(description="generate invariants for induction in parallel to the analysis")
        private boolean parallelInvariantGeneration = false;
        private final Timer invariantGeneration = new Timer();
        private final LogManager logger;
        private final ConfigurableProgramAnalysis invariantCPAs;
        private final ReachedSet reached;
        private CFANode initialLocation = null;
        private ExecutorService executor = null;
        private Future<ReachedSet> invariantGenerationFuture = null;

        public InvariantGenerator(Configuration config, LogManager pLogger, ReachedSetFactory reachedSetFactory, CFA cfa) throws InvalidConfigurationException, CPAException {
            config.inject((Object)this);
            this.logger = pLogger;
            if (this.configFile != null) {
                Configuration invariantConfig;
                try {
                    invariantConfig = Configuration.builder().loadFromFile(this.configFile).build();
                }
                catch (IOException e) {
                    throw new InvalidConfigurationException("could not read configuration file for invariant generation: " + e.getMessage(), (Throwable)e);
                }
                this.invariantCPAs = new CPABuilder(invariantConfig, this.logger, reachedSetFactory).buildCPAs(cfa);
                this.reached = new ReachedSetFactory(invariantConfig, this.logger).create();
            } else {
                this.invariantCPAs = null;
                this.reached = new ReachedSetFactory(config, this.logger).create();
            }
        }

        public void start(CFANode pInitialLocation) {
            Preconditions.checkState((this.initialLocation == null ? 1 : 0) != 0);
            this.initialLocation = pInitialLocation;
            if (this.invariantCPAs == null) {
                return;
            }
            if (this.parallelInvariantGeneration) {
                this.executor = Executors.newSingleThreadExecutor();
                this.invariantGenerationFuture = this.executor.submit(new Callable<ReachedSet>(){

                    @Override
                    public ReachedSet call() throws Exception {
                        return InvariantGenerator.this.findInvariants();
                    }
                });
                this.executor.shutdown();
            }
        }

        public void cancelAndWait() {
            if (this.invariantGenerationFuture != null) {
                this.invariantGenerationFuture.cancel(true);
                Concurrency.waitForTermination((ExecutorService)this.executor);
            }
        }

        public ReachedSet get() throws CPAException, InterruptedException {
            if (this.invariantGenerationFuture == null) {
                return this.findInvariants();
            }
            try {
                return this.invariantGenerationFuture.get();
            }
            catch (ExecutionException e) {
                Throwables.propagateIfPossible((Throwable)e.getCause(), CPAException.class, InterruptedException.class);
                throw new Classes.UnexpectedCheckedException("invariant generation", e.getCause());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ReachedSet findInvariants() throws CPAException, InterruptedException {
            Preconditions.checkState((this.initialLocation != null ? 1 : 0) != 0);
            if (this.invariantCPAs == null) {
                return this.reached;
            }
            this.invariantGeneration.start();
            this.logger.log(Level.INFO, new Object[]{"Finding invariants"});
            try {
                this.reached.add(this.invariantCPAs.getInitialElement(this.initialLocation), this.invariantCPAs.getInitialPrecision(this.initialLocation));
                CPAAlgorithm invariantAlgorithm = new CPAAlgorithm(this.invariantCPAs, this.logger);
                invariantAlgorithm.run(this.reached);
                ReachedSet reachedSet = this.reached;
                return reachedSet;
            }
            finally {
                this.invariantGeneration.start();
            }
        }
    }

    private class BMCStatistics
    implements Statistics {
        private final Timer satCheck = new Timer();
        private final Timer errorPathCreation = new Timer();
        private final Timer assertionsCheck = new Timer();
        private final Timer inductionPreparation = new Timer();
        private final Timer inductionCheck = new Timer();
        private int inductionCutPoints = 0;

        private BMCStatistics() {
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, ReachedSet pReached) {
            if (this.satCheck.getNumberOfIntervals() > 0) {
                out.println("Time for final sat check:            " + this.satCheck);
            }
            if (this.errorPathCreation.getNumberOfIntervals() > 0) {
                out.println("Time for error path creation:        " + this.errorPathCreation);
            }
            if (this.assertionsCheck.getNumberOfIntervals() > 0) {
                out.println("Time for bounding assertions check:  " + this.assertionsCheck);
            }
            if (this.inductionCheck.getNumberOfIntervals() > 0) {
                out.println("Number of cut points for induction:  " + this.inductionCutPoints);
                out.println("Time for induction formula creation: " + this.inductionPreparation);
                out.println("  Time for invariant generation:     " + BMCAlgorithm.this.invariantGenerator.invariantGeneration);
                out.println("Time for induction check:            " + this.inductionCheck);
            }
        }

        @Override
        public String getName() {
            return "BMC algorithm";
        }
    }
}

