/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.logging.Level;
import org.sosy_lab.common.AbstractMBean;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Timer;
import org.sosy_lab.common.configuration.ClassOption;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.InvalidComponentException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.AbstractElements;

@Options(prefix="cegar")
public class CEGARAlgorithm
implements Algorithm,
StatisticsProvider {
    private final CEGARStatistics stats = new CEGARStatistics();
    private static final int GC_PERIOD = 100;
    private int gcCounter = 0;
    private volatile int sizeOfReachedSetBeforeRefinement = 0;
    @Option(required=true, description="Which refinement algorithm to use? (give class name, required for CEGAR) If the package name starts with 'org.sosy_lab.cpachecker.', this prefix can be omitted.")
    @ClassOption(packagePrefix="org.sosy_lab.cpachecker")
    private Class<? extends Refiner> refiner = null;
    @Option(description="completely restart analysis on refinement by removing everything from the reached set")
    private boolean restartOnRefinement = false;
    private final LogManager logger;
    private final Algorithm algorithm;
    private final Refiner mRefiner;

    private Refiner createInstance(ConfigurableProgramAnalysis pCpa) throws CPAException, InvalidConfigurationException {
        Object refinerObj;
        Method factoryMethod;
        try {
            factoryMethod = this.refiner.getMethod("create", ConfigurableProgramAnalysis.class);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidComponentException(this.refiner, "Refiner", "No public static method \"create\" with exactly one parameter of type ConfigurableProgramAnalysis.");
        }
        if (!Modifier.isStatic(factoryMethod.getModifiers())) {
            throw new InvalidComponentException(this.refiner, "Refiner", "Factory method is not static");
        }
        String exception = Classes.verifyDeclaredExceptions((Method)factoryMethod, (Class[])new Class[]{CPAException.class, InvalidConfigurationException.class});
        if (exception != null) {
            throw new InvalidComponentException(this.refiner, "Refiner", "Factory method declares the unsupported checked exception " + exception + ".");
        }
        try {
            refinerObj = factoryMethod.invoke(null, pCpa);
        }
        catch (IllegalAccessException e) {
            throw new InvalidComponentException(this.refiner, "Refiner", "Factory method is not public.");
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            Throwables.propagateIfPossible((Throwable)cause, CPAException.class, InvalidConfigurationException.class);
            throw new Classes.UnexpectedCheckedException("instantiation of refiner " + this.refiner.getSimpleName(), cause);
        }
        if (refinerObj == null || !(refinerObj instanceof Refiner)) {
            throw new InvalidComponentException(this.refiner, "Refiner", "Factory method did not return a Refiner instance.");
        }
        return (Refiner)refinerObj;
    }

    public CEGARAlgorithm(Algorithm algorithm, ConfigurableProgramAnalysis pCpa, Configuration config, LogManager logger) throws InvalidConfigurationException, CPAException {
        config.inject((Object)this);
        this.algorithm = algorithm;
        this.logger = logger;
        this.mRefiner = this.createInstance(pCpa);
        new CEGARMBean();
    }

    public CEGARAlgorithm(Algorithm algorithm, Refiner pRefiner, Configuration config, LogManager logger) throws InvalidConfigurationException, CPAException {
        config.inject((Object)this);
        this.algorithm = algorithm;
        this.logger = logger;
        this.mRefiner = (Refiner)Preconditions.checkNotNull((Object)pRefiner);
    }

    @Override
    public boolean run(ReachedSet reached) throws CPAException, InterruptedException {
        boolean continueAnalysis;
        boolean sound = true;
        this.stats.totalTimer.start();
        do {
            boolean refinementResult;
            continueAnalysis = false;
            sound &= this.algorithm.run(reached);
            AbstractElement lastElement = reached.getLastElement();
            if (!AbstractElements.isTargetElement(lastElement)) continue;
            this.logger.log(Level.FINE, new Object[]{"Error found, performing CEGAR"});
            this.stats.countRefinements++;
            this.sizeOfReachedSetBeforeRefinement = reached.size();
            this.stats.refinementTimer.start();
            try {
                refinementResult = this.mRefiner.performRefinement(reached);
            }
            catch (RefinementFailedException e) {
                this.stats.countFailedRefinements++;
                throw e;
            }
            finally {
                this.stats.refinementTimer.stop();
            }
            if (refinementResult) {
                this.logger.log(Level.FINE, new Object[]{"Refinement successful"});
                this.stats.countSuccessfulRefinements++;
                if (this.restartOnRefinement) {
                    // empty if block
                }
                this.runGC();
                continueAnalysis = true;
                continue;
            }
            this.logger.log(Level.FINE, new Object[]{"Refinement unsuccessful"});
        } while (continueAnalysis);
        this.stats.totalTimer.stop();
        return sound;
    }

    private void runGC() {
        if (++this.gcCounter % 100 == 0) {
            this.stats.gcTimer.start();
            System.gc();
            this.gcCounter = 0;
            this.stats.gcTimer.stop();
        }
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.algorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.algorithm)).collectStatistics(pStatsCollection);
        }
        if (this.mRefiner instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.mRefiner)).collectStatistics(pStatsCollection);
        }
        pStatsCollection.add(this.stats);
    }

    private class CEGARMBean
    extends AbstractMBean
    implements CEGARMXBean {
        public CEGARMBean() {
            super("org.sosy_lab.cpachecker:type=CEGAR", CEGARAlgorithm.this.logger);
            this.register();
        }

        @Override
        public int getNumberOfRefinements() {
            return CEGARAlgorithm.this.stats.countRefinements;
        }

        @Override
        public int getSizeOfReachedSetBeforeLastRefinement() {
            return CEGARAlgorithm.this.sizeOfReachedSetBeforeRefinement;
        }

        @Override
        public boolean isRefinementActive() {
            return CEGARAlgorithm.this.stats.refinementTimer.isRunning();
        }
    }

    public static interface CEGARMXBean {
        public int getNumberOfRefinements();

        public int getSizeOfReachedSetBeforeLastRefinement();

        public boolean isRefinementActive();
    }

    private static class CEGARStatistics
    implements Statistics {
        private final Timer totalTimer = new Timer();
        private final Timer refinementTimer = new Timer();
        private final Timer gcTimer = new Timer();
        private volatile int countRefinements = 0;
        private int countSuccessfulRefinements = 0;
        private int countFailedRefinements = 0;

        private CEGARStatistics() {
        }

        @Override
        public String getName() {
            return "CEGAR algorithm";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, ReachedSet pReached) {
            out.println("Number of refinements:            " + this.countRefinements);
            if (this.countRefinements > 0) {
                out.println("Number of successful refinements: " + this.countSuccessfulRefinements);
                out.println("Number of failed refinements:     " + this.countFailedRefinements);
                out.println("");
                out.println("Total time for CEGAR algorithm:   " + this.totalTimer);
                out.println("Time for refinements:             " + this.refinementTimer);
                out.println("Average time for refinement:      " + this.refinementTimer.printAvgTime());
                out.println("Max time for refinement:          " + this.refinementTimer.printMaxTime());
                out.println("Time for garbage collection:      " + this.gcTimer);
            }
        }
    }
}

