/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.collect.Iterables;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Timer;
import org.sosy_lab.common.Triple;
import org.sosy_lab.cpachecker.core.CPAchecker;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class CPAAlgorithm
implements Algorithm,
StatisticsProvider {
    private final CPAStatistics stats = new CPAStatistics();
    private final ConfigurableProgramAnalysis cpa;
    private final LogManager logger;

    public CPAAlgorithm(ConfigurableProgramAnalysis cpa, LogManager logger) {
        this.cpa = cpa;
        this.logger = logger;
    }

    @Override
    public boolean run(ReachedSet reachedSet) throws CPAException, InterruptedException {
        this.stats.totalTimer.start();
        TransferRelation transferRelation = this.cpa.getTransferRelation();
        MergeOperator mergeOperator = this.cpa.getMergeOperator();
        StopOperator stopOperator = this.cpa.getStopOperator();
        PrecisionAdjustment precisionAdjustment = this.cpa.getPrecisionAdjustment();
        while (reachedSet.hasWaitingElement()) {
            CPAchecker.stopIfNecessary();
            this.stats.countIterations++;
            int size = reachedSet.getWaitlistSize();
            if (size >= this.stats.maxWaitlistSize) {
                this.stats.maxWaitlistSize = size;
            }
            this.stats.countWaitlistSize += size;
            this.stats.chooseTimer.start();
            AbstractElement element = reachedSet.popFromWaitlist();
            Precision precision = reachedSet.getPrecision(element);
            this.stats.chooseTimer.stop();
            this.logger.log(Level.FINER, new Object[]{"Retrieved element from waitlist"});
            this.logger.log(Level.ALL, new Object[]{"Current element is", element, "with precision", precision});
            this.stats.transferTimer.start();
            Collection<? extends AbstractElement> successors = transferRelation.getAbstractSuccessors(element, precision, null);
            this.stats.transferTimer.stop();
            int numSuccessors = successors.size();
            this.logger.log(Level.FINER, new Object[]{"Current element has", numSuccessors, "successors"});
            this.stats.countSuccessors += numSuccessors;
            this.stats.maxSuccessors = Math.max(numSuccessors, this.stats.maxSuccessors);
            for (AbstractElement successor : Iterables.consumingIterable(successors)) {
                this.logger.log(Level.FINER, new Object[]{"Considering successor of current element"});
                this.logger.log(Level.ALL, new Object[]{"Successor of", element, "\nis", successor});
                this.stats.precisionTimer.start();
                Triple<AbstractElement, Precision, PrecisionAdjustment.Action> precAdjustmentResult = precisionAdjustment.prec(successor, precision, reachedSet);
                this.stats.precisionTimer.stop();
                successor = (AbstractElement)precAdjustmentResult.getFirst();
                Precision successorPrecision = (Precision)precAdjustmentResult.getSecond();
                PrecisionAdjustment.Action action = (PrecisionAdjustment.Action)((Object)precAdjustmentResult.getThird());
                if (action == PrecisionAdjustment.Action.BREAK) {
                    this.stats.stopTimer.start();
                    boolean stop = stopOperator.stop(successor, reachedSet.getReached(successor), successorPrecision);
                    this.stats.stopTimer.stop();
                    if (stop) {
                        this.stats.countStop++;
                        this.logger.log(Level.FINER, new Object[]{"Break was signalled but ignored because the element is covered."});
                        continue;
                    }
                    this.stats.countBreak++;
                    this.logger.log(Level.FINER, new Object[]{"Break signalled, CPAAlgorithm will stop."});
                    reachedSet.add(successor, successorPrecision);
                    if (!successors.isEmpty()) {
                        reachedSet.reAddToWaitlist(element);
                    }
                    this.stats.totalTimer.stop();
                    return true;
                }
                assert (action == PrecisionAdjustment.Action.CONTINUE) : "Enum Action has unhandled values!";
                Collection<AbstractElement> reached = reachedSet.getReached(successor);
                if (mergeOperator != MergeSepOperator.getInstance() && !reached.isEmpty()) {
                    this.stats.mergeTimer.start();
                    ArrayList<AbstractElement> toRemove = new ArrayList<AbstractElement>();
                    ArrayList<Pair<AbstractElement, Precision>> toAdd = new ArrayList<Pair<AbstractElement, Precision>>();
                    this.logger.log(Level.FINER, new Object[]{"Considering", reached.size(), "elements from reached set for merge"});
                    for (AbstractElement reachedElement : reached) {
                        AbstractElement mergedElement = mergeOperator.merge(successor, reachedElement, successorPrecision);
                        if (mergedElement.equals(reachedElement)) continue;
                        this.logger.log(Level.FINER, new Object[]{"Successor was merged with element from reached set"});
                        this.logger.log(Level.ALL, new Object[]{"Merged", successor, "\nand", reachedElement, "\n-->", mergedElement});
                        this.stats.countMerge++;
                        toRemove.add(reachedElement);
                        toAdd.add((Pair<AbstractElement, Precision>)Pair.of((Object)mergedElement, (Object)successorPrecision));
                    }
                    reachedSet.removeAll(toRemove);
                    reachedSet.addAll(toAdd);
                    this.stats.mergeTimer.stop();
                }
                this.stats.stopTimer.start();
                boolean stop = stopOperator.stop(successor, reached, successorPrecision);
                this.stats.stopTimer.stop();
                if (stop) {
                    this.logger.log(Level.FINER, new Object[]{"Successor is covered or unreachable, not adding to waitlist"});
                    this.stats.countStop++;
                    continue;
                }
                this.logger.log(Level.FINER, new Object[]{"No need to stop, adding successor to waitlist"});
                this.stats.addTimer.start();
                reachedSet.add(successor, successorPrecision);
                this.stats.addTimer.stop();
            }
        }
        this.stats.totalTimer.stop();
        return true;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
    }

    private static class CPAStatistics
    implements Statistics {
        private Timer totalTimer = new Timer();
        private Timer chooseTimer = new Timer();
        private Timer precisionTimer = new Timer();
        private Timer transferTimer = new Timer();
        private Timer mergeTimer = new Timer();
        private Timer stopTimer = new Timer();
        private Timer addTimer = new Timer();
        private int countIterations = 0;
        private int maxWaitlistSize = 0;
        private int countWaitlistSize = 0;
        private int countSuccessors = 0;
        private int maxSuccessors = 0;
        private int countMerge = 0;
        private int countStop = 0;
        private int countBreak = 0;

        private CPAStatistics() {
        }

        @Override
        public String getName() {
            return "CPA algorithm";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, ReachedSet pReached) {
            out.println("Number of iterations:            " + this.countIterations);
            out.println("Max size of waitlist:            " + this.maxWaitlistSize);
            out.println("Average size of waitlist:        " + this.countWaitlistSize / this.countIterations);
            out.println("Number of computed successors:   " + this.countSuccessors);
            out.println("Max successors for one element:  " + this.maxSuccessors);
            out.println("Number of times merged:          " + this.countMerge);
            out.println("Number of times stopped:         " + this.countStop);
            out.println("Number of times breaked:         " + this.countBreak);
            out.println();
            out.println("Total time for CPA algorithm:     " + this.totalTimer + " (Max: " + this.totalTimer.printMaxTime() + ")");
            out.println("  Time for choose from waitlist:  " + this.chooseTimer);
            out.println("  Time for precision adjustment:  " + this.precisionTimer);
            out.println("  Time for transfer relation:     " + this.transferTimer);
            if (this.mergeTimer.getNumberOfIntervals() > 0) {
                out.println("  Time for merge operator:        " + this.mergeTimer);
            }
            out.println("  Time for stop operator:         " + this.stopTimer);
            out.println("  Time for adding to reached set: " + this.addTimer);
        }
    }
}

