/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.sosy_lab.common.Files;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.CPABuilder;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.CounterexampleChecker;
import org.sosy_lab.cpachecker.core.reachedset.PartitionedReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.waitlist.Waitlist;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CounterexampleAnalysisFailed;
import org.sosy_lab.cpachecker.util.AbstractElements;

@Options(prefix="counterexample.checker")
public class CounterexampleCPAChecker
implements CounterexampleChecker {
    private final LogManager logger;
    private final ReachedSetFactory reachedSetFactory;
    private final CFA cfa;
    @Option(name="config", description="configuration file for counterexample checks with CPAchecker")
    @FileOption(value=FileOption.Type.REQUIRED_INPUT_FILE)
    private File configFile = new File("config/explicitAnalysis-no-cbmc.properties");

    public CounterexampleCPAChecker(Configuration config, LogManager logger, ReachedSetFactory pReachedSetFactory, CFA pCfa) throws InvalidConfigurationException {
        this.logger = logger;
        config.inject((Object)this);
        this.reachedSetFactory = pReachedSetFactory;
        this.cfa = pCfa;
    }

    @Override
    public boolean checkCounterexample(ARTElement pRootElement, ARTElement pErrorElement, Set<ARTElement> pErrorPathElements) throws CPAException, InterruptedException {
        File automatonFile;
        String automaton = this.produceGuidingAutomaton(pRootElement, pErrorPathElements);
        try {
            automatonFile = Files.createTempFile((String)"automaton", (String)".txt", (String)automaton);
        }
        catch (IOException e) {
            throw new CounterexampleAnalysisFailed("Could not write path automaton to file " + e.getMessage(), e);
        }
        CFAFunctionDefinitionNode entryNode = (CFAFunctionDefinitionNode)AbstractElements.extractLocation(pRootElement);
        try {
            Configuration lConfig = Configuration.builder().loadFromFile(this.configFile).setOption("specification", automatonFile.getAbsolutePath()).build();
            CPABuilder lBuilder = new CPABuilder(lConfig, this.logger, this.reachedSetFactory);
            ConfigurableProgramAnalysis lCpas = lBuilder.buildCPAs(this.cfa);
            CPAAlgorithm lAlgorithm = new CPAAlgorithm(lCpas, this.logger);
            PartitionedReachedSet lReached = new PartitionedReachedSet(Waitlist.TraversalMethod.DFS);
            lReached.add(lCpas.getInitialElement(entryNode), lCpas.getInitialPrecision(entryNode));
            lAlgorithm.run(lReached);
            return !Iterables.isEmpty(AbstractElements.filterTargetElements(lReached));
        }
        catch (InvalidConfigurationException e) {
            throw new CounterexampleAnalysisFailed("Invalid configuration in counterexample-check config: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new CounterexampleAnalysisFailed(e.getMessage(), e);
        }
    }

    private String produceGuidingAutomaton(ARTElement pRootElement, Set<ARTElement> pPathElements) {
        StringBuilder sb = new StringBuilder();
        sb.append("CONTROL AUTOMATON AssumptionAutomaton\n\n");
        sb.append("INITIAL STATE ART" + pRootElement.getElementId() + ";\n\n");
        for (ARTElement e : pPathElements) {
            CFANode loc = AbstractElements.extractLocation(e);
            sb.append("STATE USEFIRST ART" + e.getElementId() + " :\n");
            for (ARTElement child : e.getChildren()) {
                if (child.isCovered()) {
                    child = child.getCoveringElement();
                    assert (!child.isCovered());
                }
                if (!pPathElements.contains(child)) continue;
                CFANode childLoc = AbstractElements.extractLocation(child);
                CFAEdge edge = loc.getEdgeTo(childLoc);
                sb.append("    MATCH \"");
                CounterexampleCPAChecker.escape(edge.getRawStatement(), sb);
                sb.append("\" -> ");
                if (child.isTarget()) {
                    sb.append("ERROR");
                } else {
                    sb.append("GOTO ART" + child.getElementId());
                }
                sb.append(";\n");
            }
            sb.append("    TRUE -> STOP;\n\n");
        }
        sb.append("END AUTOMATON\n");
        return sb.toString();
    }

    private static void escape(String s, StringBuilder appendTo) {
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    appendTo.append("\\n");
                    continue block5;
                }
                case '\"': {
                    appendTo.append("\\\"");
                    continue block5;
                }
                case '\\': {
                    appendTo.append("\\\\");
                    continue block5;
                }
                default: {
                    appendTo.append(c);
                }
            }
        }
    }
}

