/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Timer;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.exceptions.CPAException;

@Options
public class ExternalCBMCAlgorithm
implements Algorithm,
StatisticsProvider {
    private final String fileName;
    private final LogManager logger;
    private final Stats stats = new Stats();
    @Option(name="analysis.entryFunction", regexp="^[_a-zA-Z][_a-zA-Z0-9]*$", description="entry function")
    private String mainFunctionName = "main";
    @Option(name="cbmc.timelimit", description="maximum time limit for CBMC (0 is infinite)")
    private int timelimit = 0;
    @Option(name="cbmc.options.intWidth", description="set width of int (16, 32 or 64)")
    private int intWidth = 32;
    @Option(name="cbmc.options.errorLabel", description="specify the name of the error label")
    private String errorLabel = "ERROR";
    @Option(name="cbmc.options.unwindings", description="specify the limit for unwindings (0 is infinite)")
    private int unwind = 0;
    @Option(name="cbmc.options.nuaf", description="disable unwinding assertions violation error")
    private boolean noUnwindingAssertions = false;

    public ExternalCBMCAlgorithm(String fileName, Configuration config, LogManager logger) throws InvalidConfigurationException {
        this.fileName = fileName;
        this.logger = logger;
        config.inject((Object)this);
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean run(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String[] buildCBMCArguments(String fileName) {
        ArrayList<String> paramsList = new ArrayList<String>();
        paramsList.add("cbmc");
        paramsList.add("--function");
        paramsList.add(this.mainFunctionName);
        paramsList.add("--" + this.intWidth);
        paramsList.add("--unwind");
        paramsList.add(Integer.toString(this.unwind));
        paramsList.add("--error-label");
        paramsList.add(this.errorLabel);
        if (this.noUnwindingAssertions) {
            paramsList.add("--no-unwinding-assertions");
        }
        paramsList.add(fileName);
        String[] s = new String[paramsList.size()];
        return paramsList.toArray(s);
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
    }

    private static class DummyErrorElement
    implements AbstractElement,
    Targetable {
        private DummyErrorElement() {
        }

        @Override
        public boolean isTarget() {
            return true;
        }
    }

    private static class Stats
    implements Statistics {
        private final Timer cbmcTime = new Timer();

        private Stats() {
        }

        @Override
        public String getName() {
            return "CBMC";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, ReachedSet pReached) {
            out.println("Time for running CBMC: " + this.cbmcTime);
        }

        static /* synthetic */ Timer access$100(Stats x0) {
            return x0.cbmcTime;
        }
    }
}

