/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Timer;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.CounterexampleCPAChecker;
import org.sosy_lab.cpachecker.core.algorithm.cbmctools.CBMCChecker;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.CounterexampleChecker;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.cpa.art.ARTCPA;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.cpa.art.ARTUtils;
import org.sosy_lab.cpachecker.cpa.art.Path;
import org.sosy_lab.cpachecker.cpa.composite.CompositeElement;
import org.sosy_lab.cpachecker.cpa.featurevariables.FeatureVarsElement;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.predicates.NamedRegionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;

@Options(prefix="counterexample")
public class FeatureVarsRestrictionAlgorithm
implements Algorithm,
StatisticsProvider,
Statistics {
    private final Algorithm algorithm;
    private final CounterexampleChecker checker;
    private final LogManager logger;
    private final Timer checkTime = new Timer();
    private int numberOfInfeasiblePaths = 0;
    @Option(name="checker", toUppercase=true, values={"CBMC", "CPACHECKER"}, description="which model checker to use for verifying counterexamples as a second check\nCurrently CBMC or CPAchecker with a different config can be used.")
    private String checkerName = "CBMC";
    @Option(description="continue analysis after an counterexample was found that was denied by the second check")
    private boolean continueAfterInfeasibleError = true;
    @Option(description="If continueAfterInfeasibleError is true, remove the infeasible counterexample before continuing.Setting this to false may prevent a lot of similar infeasible counterexamples to get discovered, but is unsound")
    private boolean removeInfeasibleErrors = false;
    NamedRegionManager manager = null;
    Region errorSummary = null;
    int errorsHit = 0;

    public FeatureVarsRestrictionAlgorithm(Algorithm algorithm, ConfigurableProgramAnalysis pCpa, Configuration config, LogManager logger, ReachedSetFactory reachedSetFactory, CFA cfa) throws InvalidConfigurationException, CPAException {
        this.algorithm = algorithm;
        this.logger = logger;
        config.inject((Object)this);
        if (!(pCpa instanceof ARTCPA)) {
            throw new InvalidConfigurationException("ART CPA needed for counterexample check");
        }
        logger.log(Level.INFO, new Object[]{"using the FeatureVars Restriction Algorithm"});
        if (this.checkerName.equals("CBMC")) {
            this.checker = new CBMCChecker(config, logger);
        } else if (this.checkerName.equals("CPACHECKER")) {
            this.checker = new CounterexampleCPAChecker(config, logger, reachedSetFactory, cfa);
        } else {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean run(ReachedSet reached) throws CPAException, InterruptedException {
        boolean sound = true;
        while (reached.hasWaitingElement()) {
            ARTElement errorElement;
            sound &= this.algorithm.run(reached);
            AbstractElement lastElement = reached.getLastElement();
            if (!(lastElement instanceof ARTElement) || !(errorElement = (ARTElement)lastElement).isTarget()) break;
            this.checkTime.start();
            try {
                boolean feasibility;
                ARTElement rootElement = (ARTElement)reached.getFirstElement();
                Set<ARTElement> elementsOnErrorPath = ARTUtils.getAllElementsOnPathsTo(errorElement);
                try {
                    feasibility = this.checker.checkCounterexample(rootElement, errorElement, elementsOnErrorPath);
                }
                catch (CPAException e) {
                    this.logger.logUserException(Level.WARNING, (Throwable)e, "Counterexample found, but feasibility could not be verified");
                    boolean bl = false;
                    this.checkTime.stop();
                    return bl;
                }
                if (feasibility) {
                    this.logger.log(Level.INFO, new Object[]{"Error path found and confirmed by counterexample check with " + this.checkerName + "."});
                    Region errorBDD = null;
                    for (AbstractElement x : ((CompositeElement)errorElement.getWrappedElement()).getWrappedElements()) {
                        if (!(x instanceof FeatureVarsElement)) continue;
                        errorBDD = ((FeatureVarsElement)x).getRegion();
                        if (this.manager == null) {
                            this.manager = ((FeatureVarsElement)x).getManager();
                            this.errorSummary = this.manager.makeFalse();
                        }
                        this.errorSummary = this.manager.makeOr(errorBDD, this.errorSummary);
                        ++this.errorsHit;
                    }
                    for (AbstractElement x : reached.getWaitlist()) {
                        ARTElement xart = (ARTElement)x;
                        FeatureVarsElement fvelem = null;
                        for (AbstractElement y : ((CompositeElement)xart.getWrappedElement()).getWrappedElements()) {
                            if (!(y instanceof FeatureVarsElement)) continue;
                            fvelem = (FeatureVarsElement)y;
                        }
                        fvelem.restrictWith(this.manager.makeNot(errorBDD));
                    }
                    boolean bl = sound;
                    return bl;
                }
                ++this.numberOfInfeasiblePaths;
                this.logger.log(Level.INFO, new Object[]{"Error path found, but identified as infeasible by counterexample check with " + this.checkerName + "."});
                if (this.continueAfterInfeasibleError) {
                    if (this.removeInfeasibleErrors) {
                        sound &= this.handleInfeasibleCounterexample(reached, elementsOnErrorPath);
                    } else if (sound) {
                        this.logger.log(Level.WARNING, new Object[]{"Infeasible counterexample found, but could not remove it from the ART. Therefore, we cannot prove safety."});
                        sound = false;
                    }
                    sound &= this.removeErrorElement(reached, errorElement);
                    continue;
                }
                Path path = ARTUtils.getOnePathTo(errorElement);
                throw new RefinementFailedException(RefinementFailedException.Reason.InfeasibleCounterexample, path);
            }
            finally {
                this.checkTime.stop();
            }
        }
        if (this.errorSummary != null) {
            this.logger.log(Level.INFO, new Object[]{"ErrorSummary(" + this.errorsHit + "): " + this.manager.dumpRegion(this.errorSummary).replace("__SELECTED_FEATURE_", "")});
        } else {
            this.logger.log(Level.INFO, new Object[]{"ErrorSummary(0): No Errors"});
        }
        return sound;
    }

    private boolean handleInfeasibleCounterexample(ReachedSet reached, Set<ARTElement> elementsOnErrorPath) {
        boolean sound = true;
        ArrayList<ARTElement> coveredByErrorPath = new ArrayList<ARTElement>();
        for (ARTElement errorPathElement : elementsOnErrorPath) {
            coveredByErrorPath.addAll(errorPathElement.getCoveredByThis());
            errorPathElement.setNotCovering();
        }
        for (ARTElement coveredElement : coveredByErrorPath) {
            if (this.isTransitiveChildOf(coveredElement, coveredElement.getCoveringElement())) {
                this.logger.log(Level.WARNING, new Object[]{"Infeasible counterexample found, but could not remove it from the ART due to loops in the counterexample path. Therefore, we cannot prove safety."});
                sound = false;
                continue;
            }
            for (ARTElement parentOfCovered : coveredElement.getParents()) {
                if (elementsOnErrorPath.contains(parentOfCovered)) {
                    this.logger.log(Level.WARNING, new Object[]{"Infeasible counterexample found, but could not remove it from the ART. Therefore, we cannot prove safety."});
                    sound = false;
                    continue;
                }
                reached.reAddToWaitlist(parentOfCovered);
            }
            assert (!reached.contains(coveredElement)) : "covered element in reached set";
            coveredElement.removeFromART();
        }
        return sound;
    }

    private boolean isTransitiveChildOf(ARTElement potentialChild, ARTElement potentialParent) {
        HashSet<ARTElement> seen = new HashSet<ARTElement>();
        ArrayDeque<ARTElement> waitlist = new ArrayDeque<ARTElement>();
        waitlist.addAll(potentialChild.getParents());
        while (!waitlist.isEmpty()) {
            ARTElement current = (ARTElement)waitlist.pollFirst();
            for (ARTElement currentParent : current.getParents()) {
                if (currentParent.equals(potentialParent)) {
                    return true;
                }
                if (seen.add(currentParent)) continue;
                waitlist.addLast(currentParent);
            }
        }
        return false;
    }

    private boolean removeErrorElement(ReachedSet reached, ARTElement errorElement) {
        boolean sound = true;
        Set<ARTElement> parents = errorElement.getParents();
        assert (parents.size() == 1) : "error element that was merged";
        ARTElement parent = (ARTElement)Iterables.getOnlyElement(parents);
        if (parent.getChildren().size() > 1) {
            sound = false;
        }
        ImmutableList siblings = ImmutableList.copyOf(parent.getChildren());
        for (ARTElement toRemove : siblings) {
            assert (toRemove.getChildren().isEmpty());
            assert (siblings.containsAll(toRemove.getCoveredByThis()));
            reached.remove(toRemove);
            toRemove.removeFromART();
        }
        reached.remove(parent);
        parent.removeFromART();
        assert (errorElement.isDestroyed()) : "errorElement is not the child of its parent";
        assert (!reached.contains(errorElement)) : "reached.remove() didn't work";
        return sound;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.algorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.algorithm)).collectStatistics(pStatsCollection);
        }
        pStatsCollection.add(this);
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, ReachedSet pReached) {
        out.println("Number of counterexample checks:    " + this.checkTime.getNumberOfIntervals());
        if (this.checkTime.getNumberOfIntervals() > 0) {
            out.println("Number of infeasible paths:         " + this.numberOfInfeasiblePaths + " (" + FeatureVarsRestrictionAlgorithm.toPercent(this.numberOfInfeasiblePaths, this.checkTime.getNumberOfIntervals()) + ")");
            out.println("Time for counterexample checks:     " + this.checkTime);
        }
        if (this.checker instanceof Statistics) {
            ((Statistics)((Object)this.checker)).printStatistics(out, pResult, pReached);
        }
    }

    private static String toPercent(double val, double full) {
        return String.format("%1.0f", val / full * 100.0) + "%";
    }

    @Override
    public String getName() {
        return "Counterexample-Check Algorithm";
    }
}

