/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Timer;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.core.CPAchecker;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.ProofChecker;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;

@Options
public class ProofCheckAlgorithm
implements Algorithm,
StatisticsProvider {
    private final CPAStatistics stats = new CPAStatistics();
    private final ProofChecker cpa;
    private final LogManager logger;
    @Option(name="pcc.proofFile", description="file in which ART representation needed for proof checking is stored")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private File file = new File("art.obj");
    private final ARTElement rootElement;

    public ProofCheckAlgorithm(ConfigurableProgramAnalysis cpa, Configuration pConfig, LogManager logger) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        if (!(cpa instanceof ProofChecker)) {
            throw new InvalidConfigurationException("ProofCheckAlgorithm needs a CPA that implements the ProofChecker interface.");
        }
        this.cpa = (ProofChecker)((Object)cpa);
        this.logger = logger;
        ARTElement rootElement = null;
        try {
            rootElement = this.readART();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException("Failed reading ART.", e);
        }
        this.rootElement = rootElement;
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ARTElement readART() throws IOException, ClassNotFoundException {
        this.stats.totalTimer.start();
        this.stats.readTimer.start();
        InputStream fis = null;
        try {
            fis = new FileInputStream(this.file);
            ZipInputStream zis = new ZipInputStream(fis);
            ZipEntry entry = zis.getNextEntry();
            assert (entry.getName().equals("Proof"));
            zis.closeEntry();
            entry = zis.getNextEntry();
            assert (entry.getName().equals("Helper"));
            ObjectInputStream o = new ObjectInputStream(zis);
            int numberOfStorages = o.readInt();
            for (int i = 0; i < numberOfStorages; ++i) {
                Serializable storage = (Serializable)o.readObject();
                GlobalInfo.getInstance().addHelperStorage(storage);
            }
            zis.closeEntry();
            o.close();
            zis.close();
            fis.close();
            fis = new FileInputStream(this.file);
            zis = new ZipInputStream(fis);
            entry = zis.getNextEntry();
            assert (entry.getName().equals("Proof"));
            o = new ObjectInputStream(zis);
            ARTElement aRTElement = (ARTElement)o.readObject();
            return aRTElement;
        }
        finally {
            fis.close();
            this.stats.readTimer.stop();
            this.stats.totalTimer.stop();
        }
    }

    @Override
    public boolean run(ReachedSet reachedSet) throws CPAException, InterruptedException {
        this.stats.totalTimer.start();
        this.logger.log(Level.INFO, new Object[]{"Proof check algorithm started"});
        AbstractElement initialElement = reachedSet.popFromWaitlist();
        Precision initialPrecision = reachedSet.getPrecision(initialElement);
        this.logger.log(Level.FINE, new Object[]{"Checking root element"});
        if (!this.cpa.isCoveredBy(initialElement, this.rootElement) || !this.cpa.isCoveredBy(this.rootElement, initialElement)) {
            this.stats.totalTimer.stop();
            this.logger.log(Level.WARNING, new Object[]{"Root element of proof is invalid."});
            return false;
        }
        reachedSet.add(this.rootElement, initialPrecision);
        HashSet<ARTElement> postponedElements = new HashSet<ARTElement>();
        do {
            for (ARTElement e : postponedElements) {
                if (!reachedSet.contains(e.getCoveringElement())) {
                    this.stats.totalTimer.stop();
                    this.logger.log(Level.WARNING, new Object[]{"Covering element", e.getCoveringElement(), "was not found in reached set"});
                    return false;
                }
                reachedSet.reAddToWaitlist(e);
            }
            postponedElements.clear();
            while (reachedSet.hasWaitingElement()) {
                CPAchecker.stopIfNecessary();
                this.stats.countIterations++;
                ARTElement element = (ARTElement)reachedSet.popFromWaitlist();
                this.logger.log(Level.FINE, new Object[]{"Looking at element", element});
                if (element.isCovered()) {
                    this.logger.log(Level.FINER, new Object[]{"Element is covered by another abstract element; checking coverage"});
                    ARTElement coveringElement = element.getCoveringElement();
                    if (!reachedSet.contains(coveringElement)) {
                        postponedElements.add(element);
                        continue;
                    }
                    this.stats.stopTimer.start();
                    if (!this.isCoveringCycleFree(element)) {
                        this.stats.stopTimer.stop();
                        this.stats.totalTimer.stop();
                        this.logger.log(Level.WARNING, new Object[]{"Found cycle in covering relation for element", element});
                        return false;
                    }
                    if (!this.cpa.isCoveredBy(element, coveringElement)) {
                        this.stats.stopTimer.stop();
                        this.stats.totalTimer.stop();
                        this.logger.log(Level.WARNING, new Object[]{"Element", element, "is not covered by", coveringElement});
                        return false;
                    }
                    this.stats.stopTimer.stop();
                    continue;
                }
                this.stats.transferTimer.start();
                Set<ARTElement> successors = element.getChildren();
                this.logger.log(Level.FINER, new Object[]{"Checking abstract successors", successors});
                if (!this.cpa.areAbstractSuccessors(element, null, successors)) {
                    this.stats.transferTimer.stop();
                    this.stats.totalTimer.stop();
                    this.logger.log(Level.WARNING, new Object[]{"Element", element, "has other successors than", successors});
                    return false;
                }
                this.stats.transferTimer.stop();
                for (ARTElement e : successors) {
                    reachedSet.add(e, initialPrecision);
                }
            }
        } while (!postponedElements.isEmpty());
        this.stats.totalTimer.stop();
        return true;
    }

    private boolean isCoveringCycleFree(ARTElement pElement) {
        HashSet<ARTElement> seen = new HashSet<ARTElement>();
        seen.add(pElement);
        while (pElement.isCovered()) {
            boolean isNew = seen.add(pElement = pElement.getCoveringElement());
            if (isNew) continue;
            return false;
        }
        return true;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
    }

    private static class CPAStatistics
    implements Statistics {
        private Timer totalTimer = new Timer();
        private Timer transferTimer = new Timer();
        private Timer stopTimer = new Timer();
        private Timer readTimer = new Timer();
        private int countIterations = 0;

        private CPAStatistics() {
        }

        @Override
        public String getName() {
            return "Proof Check algorithm";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, ReachedSet pReached) {
            out.println("Number of iterations:                     " + this.countIterations);
            out.println();
            out.println("Total time for proof check algorithm: " + this.totalTimer);
            out.println("  Time for reading in proof:          " + this.readTimer);
            out.println("  Time for abstract successor checks: " + this.transferTimer + " (Calls: " + this.transferTimer.getNumberOfIntervals() + ")");
            out.println("  Time for covering checks:           " + this.stopTimer + " (Calls: " + this.stopTimer.getNumberOfIntervals() + ")");
        }
    }
}

