/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Timer;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.util.AbstractElements;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;

@Options
public class ProofGenerator {
    @Option(name="pcc.proofgen.doPCC", description="")
    private boolean doPCC = false;
    @Option(name="pcc.proofFile", description="file in which ART representation needed for proof checking is stored")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private File file = new File("art.obj");
    private final LogManager logger;

    public ProofGenerator(Configuration pConfig, LogManager pLogger) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = pLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateProof(CPAcheckerResult pResult) {
        if (!this.doPCC) {
            return;
        }
        UnmodifiableReachedSet reached = pResult.getReached();
        if (pResult.getResult() != CPAcheckerResult.Result.SAFE || reached.getFirstElement() == null || !(reached.getFirstElement() instanceof ARTElement) || AbstractElements.extractLocation(reached.getFirstElement()) == null) {
            this.logger.log(Level.SEVERE, new Object[]{"Proof cannot be generated because checked property not known to be true."});
            return;
        }
        this.logger.log(Level.INFO, new Object[]{"Proof Generation started."});
        Timer writingTimer = new Timer();
        writingTimer.start();
        OutputStream fos = null;
        try {
            fos = new FileOutputStream(this.file);
            ZipOutputStream zos = new ZipOutputStream(fos);
            zos.setLevel(9);
            ZipEntry ze = new ZipEntry("Proof");
            zos.putNextEntry(ze);
            ObjectOutputStream o = new ObjectOutputStream(zos);
            o.writeObject(reached.getFirstElement());
            zos.closeEntry();
            ze = new ZipEntry("Helper");
            zos.putNextEntry(ze);
            o = new ObjectOutputStream(zos);
            int numberOfStorages = GlobalInfo.getInstance().getNumberOfHelperStorages();
            o.writeInt(numberOfStorages);
            for (int i = 0; i < numberOfStorages; ++i) {
                o.writeObject(GlobalInfo.getInstance().getHelperStorage(i));
            }
            zos.closeEntry();
            o.close();
            zos.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
        finally {
            try {
                fos.close();
            }
            catch (Exception e) {}
        }
        writingTimer.stop();
        this.logger.log(Level.INFO, new Object[]{"Writing proof took " + writingTimer.printMaxTime()});
    }
}

