/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.CPABuilder;
import org.sosy_lab.cpachecker.core.CPAchecker;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.AssumptionCollectorAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.BMCAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.CEGARAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.CounterexampleCheckAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.ExternalCBMCAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ForwardingReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractElements;

@Options(prefix="restartAlgorithm")
public class RestartAlgorithm
implements Algorithm,
StatisticsProvider {
    @Option(description="list of files with configurations to use")
    @FileOption(value=FileOption.Type.REQUIRED_INPUT_FILE)
    private List<File> configFiles;
    private final LogManager logger;
    private final RestartAlgorithmStatistics stats;
    private final String filename;
    private final CFA cfa;
    private final Configuration globalConfig;
    private Algorithm currentAlgorithm;

    public RestartAlgorithm(Configuration config, LogManager pLogger, String pFilename, CFA pCfa) throws InvalidConfigurationException {
        config.inject((Object)this);
        if (this.configFiles.isEmpty()) {
            throw new InvalidConfigurationException("Need at least one configuration for restart algorithm!");
        }
        this.stats = new RestartAlgorithmStatistics();
        this.logger = pLogger;
        this.filename = pFilename;
        this.cfa = pCfa;
        this.globalConfig = config;
    }

    @Override
    public boolean run(ReachedSet pReached) throws CPAException, InterruptedException {
        Preconditions.checkArgument((boolean)(pReached instanceof ForwardingReachedSet), (Object)"RestartAlgorithm needs ForwardingReachedSet");
        Preconditions.checkArgument((pReached.size() <= 1 ? 1 : 0) != 0, (Object)"RestartAlgorithm does not support being called several times with the same reached set");
        Preconditions.checkArgument((!pReached.isEmpty() ? 1 : 0) != 0, (Object)"RestartAlgorithm needs non-empty reached set");
        ForwardingReachedSet reached = (ForwardingReachedSet)pReached;
        CFANode mainFunction = AbstractElements.extractLocation(pReached.getFirstElement());
        assert (mainFunction != null) : "Location information needed";
        Iterator<File> configFilesIterator = this.configFiles.iterator();
        while (configFilesIterator.hasNext()) {
            ReachedSet currentReached;
            block12: {
                File singleConfigFileName = configFilesIterator.next();
                try {
                    Pair<Algorithm, ReachedSet> currentPair = this.createNextAlgorithm(singleConfigFileName, mainFunction);
                    this.currentAlgorithm = (Algorithm)currentPair.getFirst();
                    currentReached = (ReachedSet)currentPair.getSecond();
                }
                catch (InvalidConfigurationException e) {
                    this.logger.logUserException(Level.WARNING, (Throwable)e, "Skipping one analysis because its configuration is invalid");
                    continue;
                }
                catch (IOException e) {
                    this.logger.logUserException(Level.WARNING, (Throwable)e, "Skipping one analysis due to unreadable configuration file");
                    continue;
                }
                reached.setDelegate(currentReached);
                if (this.currentAlgorithm instanceof StatisticsProvider) {
                    ((StatisticsProvider)((Object)this.currentAlgorithm)).collectStatistics(this.stats.getSubStatistics());
                }
                this.stats.noOfAlgorithmsUsed++;
                try {
                    boolean sound = this.currentAlgorithm.run(currentReached);
                    if (Iterables.any((Iterable)currentReached, AbstractElements.IS_TARGET_ELEMENT)) {
                        return sound;
                    }
                    if (!sound) {
                        this.logger.log(Level.INFO, new Object[]{"Analysis result was unsound."});
                        break block12;
                    }
                    if (currentReached.hasWaitingElement()) {
                        this.logger.log(Level.INFO, new Object[]{"Analysis not completed: There are still elements to be processed."});
                        break block12;
                    }
                    return true;
                }
                catch (CPAException e) {
                    if (configFilesIterator.hasNext()) {
                        this.logger.logUserException(Level.WARNING, (Throwable)e, "Analysis not completed");
                    }
                    throw e;
                }
            }
            if (!configFilesIterator.hasNext()) continue;
            this.stats.printStatistics(System.out, CPAcheckerResult.Result.UNKNOWN, currentReached);
            this.stats.resetSubStatistics();
            this.logger.log(Level.INFO, new Object[]{"RestartAlgorithm switches to the next configuration..."});
        }
        this.logger.log(Level.INFO, new Object[]{"No further configuration available."});
        return false;
    }

    private Pair<Algorithm, ReachedSet> createNextAlgorithm(File singleConfigFileName, CFANode mainFunction) throws InvalidConfigurationException, CPAException, InterruptedException, IOException {
        ReachedSet reached;
        Algorithm algorithm;
        Configuration.Builder singleConfigBuilder = Configuration.builder();
        singleConfigBuilder.copyFrom(this.globalConfig);
        singleConfigBuilder.clearOption("restartAlgorithm.configFiles");
        singleConfigBuilder.clearOption("analysis.restartAfterUnknown");
        RestartAlgorithmOptions singleOptions = new RestartAlgorithmOptions();
        singleConfigBuilder.loadFromFile(singleConfigFileName);
        Configuration singleConfig = singleConfigBuilder.build();
        singleConfig.inject((Object)singleOptions);
        if (singleOptions.runCBMCasExternalTool) {
            algorithm = new ExternalCBMCAlgorithm(this.filename, singleConfig, this.logger);
            reached = new ReachedSetFactory(singleConfig, this.logger).create();
        } else {
            ReachedSetFactory singleReachedSetFactory = new ReachedSetFactory(singleConfig, this.logger);
            ConfigurableProgramAnalysis cpa = this.createCPA(singleReachedSetFactory, singleConfig, this.stats);
            algorithm = this.createAlgorithm(cpa, singleConfig, this.stats, singleReachedSetFactory, singleOptions);
            reached = this.createInitialReachedSetForRestart(cpa, mainFunction, singleReachedSetFactory);
        }
        CPAchecker.stopIfNecessary();
        return Pair.of((Object)algorithm, (Object)reached);
    }

    private ReachedSet createInitialReachedSetForRestart(ConfigurableProgramAnalysis cpa, CFANode mainFunction, ReachedSetFactory pReachedSetFactory) {
        this.logger.log(Level.FINE, new Object[]{"Creating initial reached set"});
        AbstractElement initialElement = cpa.getInitialElement(mainFunction);
        Precision initialPrecision = cpa.getInitialPrecision(mainFunction);
        ReachedSet reached = pReachedSetFactory.create();
        reached.add(initialElement, initialPrecision);
        return reached;
    }

    private ConfigurableProgramAnalysis createCPA(ReachedSetFactory pReachedSetFactory, Configuration pConfig, RestartAlgorithmStatistics stats) throws InvalidConfigurationException, CPAException {
        this.logger.log(Level.FINE, new Object[]{"Creating CPAs"});
        CPABuilder builder = new CPABuilder(pConfig, this.logger, pReachedSetFactory);
        ConfigurableProgramAnalysis cpa = builder.buildCPAs(this.cfa);
        if (cpa instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)cpa)).collectStatistics(stats.getSubStatistics());
        }
        return cpa;
    }

    private Algorithm createAlgorithm(ConfigurableProgramAnalysis cpa, Configuration pConfig, RestartAlgorithmStatistics stats, ReachedSetFactory singleReachedSetFactory, RestartAlgorithmOptions pOptions) throws InvalidConfigurationException, CPAException {
        this.logger.log(Level.FINE, new Object[]{"Creating algorithms"});
        Algorithm algorithm = new CPAAlgorithm(cpa, this.logger);
        if (pOptions.useRefinement) {
            algorithm = new CEGARAlgorithm(algorithm, cpa, pConfig, this.logger);
        }
        if (pOptions.useBMC) {
            algorithm = new BMCAlgorithm(algorithm, cpa, pConfig, this.logger, singleReachedSetFactory, this.cfa);
        }
        if (pOptions.useCBMC) {
            algorithm = new CounterexampleCheckAlgorithm(algorithm, cpa, pConfig, this.logger, singleReachedSetFactory, this.cfa);
        }
        if (pOptions.useAssumptionCollector) {
            algorithm = new AssumptionCollectorAlgorithm(algorithm, cpa, pConfig, this.logger);
        }
        return algorithm;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.currentAlgorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.currentAlgorithm)).collectStatistics(pStatsCollection);
        }
        pStatsCollection.add(this.stats);
    }

    @Options
    private static class RestartAlgorithmOptions {
        @Option(name="analysis.useAssumptionCollector", description="use assumption collecting algorithm")
        boolean useAssumptionCollector = false;
        @Option(name="analysis.useRefinement", description="use CEGAR algorithm for lazy counter-example guided analysis\nYou need to specify a refiner with the cegar.refiner option.\nCurrently all refiner require the use of the ARTCPA.")
        boolean useRefinement = false;
        @Option(name="analysis.useCBMC", description="use CBMC to double-check counter-examples")
        boolean useCBMC = false;
        @Option(name="analysis.useBMC", description="use a BMC like algorithm that checks for satisfiability after the analysis has finished, works only with PredicateCPA")
        boolean useBMC = false;
        @Option(name="analysis.externalCBMC", description="use CBMC as an external tool from CPAchecker")
        boolean runCBMCasExternalTool = false;

        private RestartAlgorithmOptions() {
        }
    }

    private class RestartAlgorithmStatistics
    implements Statistics {
        private final Collection<Statistics> subStats = new ArrayList<Statistics>();
        private int noOfAlgorithmsUsed = 0;

        public Collection<Statistics> getSubStatistics() {
            return this.subStats;
        }

        public void resetSubStatistics() {
            this.subStats.clear();
        }

        @Override
        public String getName() {
            return "Restart Algorithm";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result result, ReachedSet reached) {
            out.println("Number of algorithms provided:    " + RestartAlgorithm.this.configFiles.size());
            out.println("Number of algorithms used:        " + this.noOfAlgorithmsUsed);
            for (Statistics s : this.subStats) {
                String name = s.getName();
                if (name != null && !name.isEmpty()) {
                    name = name + " statistics";
                    out.println("");
                    out.println(name);
                    out.println(Strings.repeat((String)"-", (int)name.length()));
                }
                s.printStatistics(out, result, reached);
            }
        }
    }
}

