/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AdjustableConditionCPA;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.art.ARTCPA;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.cpa.art.ARTReachedSet;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageCPA;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageElement;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractElements;
import org.sosy_lab.cpachecker.util.CPAs;

@Options(prefix="adjustableconditions")
public class RestartWithConditionsAlgorithm
implements Algorithm {
    private final Algorithm innerAlgorithm;
    private final ARTCPA cpa;
    private final LogManager logger;
    private final List<? extends AdjustableConditionCPA> conditionCPAs;
    @Option(description="maximum number of condition adjustments (-1 for infinite)")
    @IntegerOption(min=-1L)
    private int adjustmentLimit = -1;

    public RestartWithConditionsAlgorithm(Algorithm pAlgorithm, ConfigurableProgramAnalysis pCpa, Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = pLogger;
        this.innerAlgorithm = pAlgorithm;
        if (!(pCpa instanceof ARTCPA)) {
            throw new InvalidConfigurationException("ARTCPA needed for RestartWithConditionsAlgorithm");
        }
        this.cpa = (ARTCPA)pCpa;
        if (this.cpa.retrieveWrappedCpa(AssumptionStorageCPA.class) == null) {
            throw new InvalidConfigurationException("AssumptionStorageCPA needed for RestartWithConditionsAlgorithm");
        }
        this.conditionCPAs = ImmutableList.copyOf((Iterable)Iterables.filter(CPAs.asIterable(this.cpa), AdjustableConditionCPA.class));
    }

    @Override
    public boolean run(ReachedSet pReached) throws CPAException, InterruptedException {
        boolean sound = true;
        int count = 0;
        do {
            sound &= this.innerAlgorithm.run(pReached);
            if (Iterables.any((Iterable)pReached, AbstractElements.IS_TARGET_ELEMENT)) {
                return sound;
            }
            if (this.adjustmentLimit >= 0 && ++count > this.adjustmentLimit) {
                this.logger.log(Level.INFO, new Object[]{"Terminating because adjustment limit has been reached."});
                return sound;
            }
            List<AbstractElement> elementsWithAssumptions = this.getElementsWithAssumptions(pReached);
            if (!elementsWithAssumptions.isEmpty()) {
                this.logger.log(Level.INFO, new Object[]{"Adjusting heuristics thresholds."});
                this.adjustThresholds(elementsWithAssumptions, pReached);
            }
            for (AdjustableConditionCPA adjustableConditionCPA : this.conditionCPAs) {
                if (adjustableConditionCPA.adjustPrecision()) continue;
                this.logger.log(Level.INFO, new Object[]{"Terminating because of", adjustableConditionCPA.getClass().getSimpleName()});
                return sound;
            }
        } while (pReached.hasWaitingElement());
        return sound;
    }

    private List<AbstractElement> getElementsWithAssumptions(ReachedSet reached) {
        ArrayList<AbstractElement> retList = new ArrayList<AbstractElement>();
        for (AbstractElement element : reached) {
            AssumptionStorageElement e = AbstractElements.extractElementByType(element, AssumptionStorageElement.class);
            if (e.getAssumption().isTrue() && e.getStopFormula().isTrue()) continue;
            retList.add(element);
        }
        return retList;
    }

    private void adjustThresholds(List<AbstractElement> pElementsWithAssumptions, ReachedSet pReached) {
        ARTReachedSet reached = new ARTReachedSet(pReached, this.cpa);
        for (AbstractElement e : pElementsWithAssumptions) {
            ARTElement artElement = (ARTElement)e;
            for (ARTElement parent : ImmutableSet.copyOf(artElement.getParents())) {
                reached.removeSubtree(parent);
            }
        }
    }
}

