/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.cbmctools;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.sosy_lab.common.Files;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Timer;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.configuration.TimeSpanOption;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.cbmctools.CBMCExecutor;
import org.sosy_lab.cpachecker.core.interfaces.CounterexampleChecker;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CounterexampleAnalysisFailed;
import org.sosy_lab.cpachecker.util.AbstractElements;
import org.sosy_lab.cpachecker.util.cwriter.PathToCTranslator;

@Options
public class CBMCChecker
implements CounterexampleChecker,
Statistics {
    private final LogManager logger;
    private final Timer cbmcTime = new Timer();
    @Option(name="cbmc.dumpCBMCfile", description="file name where to put the path program that is generated as input for CBMC. A temporary file is used if this is unspecified.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private File cbmcFile;
    @Option(name="cbmc.timelimit", description="maximum time limit for CBMC (use milliseconds or specify a unit; 0 for infinite)")
    @TimeSpanOption(codeUnit=TimeUnit.MILLISECONDS, defaultUserUnit=TimeUnit.MILLISECONDS, min=0L)
    private int timelimit = 0;

    public CBMCChecker(Configuration config, LogManager logger) throws InvalidConfigurationException, CPAException {
        this.logger = logger;
        config.inject((Object)this);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkCounterexample(ARTElement pRootElement, ARTElement pErrorElement, Set<ARTElement> pErrorPathElements) throws CPAException, InterruptedException {
        int exitCode;
        CBMCExecutor cbmc;
        String mainFunctionName = AbstractElements.extractLocation(pRootElement).getFunctionName();
        String pathProgram = PathToCTranslator.translatePaths(pRootElement, pErrorPathElements);
        File cFile = this.cbmcFile;
        try {
            if (cFile != null) {
                Files.writeFile((File)cFile, (Object)pathProgram);
            } else {
                cFile = Files.createTempFile((String)"path", (String)".c", (String)pathProgram);
            }
        }
        catch (IOException e) {
            throw new CounterexampleAnalysisFailed("Could not write path program to file " + e.getMessage(), e);
        }
        assert (cFile != null);
        this.logger.log(Level.FINE, new Object[]{"Starting CBMC verification."});
        this.cbmcTime.start();
        try {
            String[] cbmcArgs = new String[]{"cbmc", "--function", mainFunctionName + "_0", "--32", cFile.getAbsolutePath()};
            cbmc = new CBMCExecutor(this.logger, cbmcArgs);
            exitCode = cbmc.join(this.timelimit);
        }
        catch (IOException e) {
            try {
                throw new CounterexampleAnalysisFailed(e.getMessage(), e);
                catch (TimeoutException e2) {
                    throw new CounterexampleAnalysisFailed("CBMC took too long to verify the counterexample.");
                }
            }
            catch (Throwable throwable) {
                this.cbmcTime.stop();
                this.logger.log(Level.FINER, new Object[]{"CBMC finished."});
                throw throwable;
            }
        }
        this.cbmcTime.stop();
        this.logger.log(Level.FINER, new Object[]{"CBMC finished."});
        if (cbmc.getResult() != null) {
            return cbmc.getResult();
        }
        throw new CounterexampleAnalysisFailed("CBMC could not verify the program (CBMC exit code was " + exitCode + ")!");
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, ReachedSet pReached) {
        out.println("Time for running CBMC:              " + this.cbmcTime);
    }

    @Override
    public String getName() {
        return "CBMC Counterexample Check";
    }
}

