/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.cbmctools;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.ProcessExecutor;

public class CBMCExecutor
extends ProcessExecutor<RuntimeException> {
    private Boolean result = null;
    private boolean unwindingAssertionFailed = false;
    private boolean gaveErrorOutput = false;

    public CBMCExecutor(LogManager logger, String[] args) throws IOException {
        super(logger, RuntimeException.class, args);
    }

    protected void handleExitCode(int pCode) {
        switch (pCode) {
            case 0: {
                this.result = false;
                if (!this.gaveErrorOutput) break;
                this.logger.log(Level.WARNING, new Object[]{"CBMC returned successfully, but printed warnings. Please check the log above!"});
                break;
            }
            case 10: {
                this.result = true;
                if (!this.gaveErrorOutput) break;
                this.logger.log(Level.WARNING, new Object[]{"CBMC returned successfully, but printed warnings. Please check the log above!"});
                break;
            }
            default: {
                super.handleExitCode(pCode);
            }
        }
    }

    protected void handleErrorOutput(String pLine) throws RuntimeException {
        if (!pLine.startsWith("Verified ") || !pLine.endsWith("original clauses.")) {
            this.gaveErrorOutput = true;
            super.handleErrorOutput(pLine);
        }
    }

    protected void handleOutput(String pLine) throws RuntimeException {
        if (pLine.contains("unwinding assertion")) {
            this.unwindingAssertionFailed = true;
        }
        super.handleOutput(pLine);
    }

    public boolean didUnwindingAssertionFailed() {
        return this.unwindingAssertionFailed;
    }

    public Boolean getResult() {
        Preconditions.checkState((boolean)this.isFinished());
        return this.result;
    }
}

