/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.impact;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Timer;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.impact.Vertex;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractElements;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.predicates.CachingPathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.ExtendedFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.FormulaManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.PathFormulaManagerImpl;
import org.sosy_lab.cpachecker.util.predicates.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.TheoremProver;
import org.sosy_lab.cpachecker.util.predicates.interpolation.CounterexampleTraceInfo;
import org.sosy_lab.cpachecker.util.predicates.interpolation.InterpolationManager;
import org.sosy_lab.cpachecker.util.predicates.interpolation.UninstantiatingInterpolationManager;

@Options(prefix="impact")
public class ImpactAlgorithm
implements Algorithm,
StatisticsProvider {
    private final LogManager logger;
    private final ConfigurableProgramAnalysis cpa;
    private final ExtendedFormulaManager fmgr;
    private final PathFormulaManager pfmgr;
    private final TheoremProver prover;
    private final Solver solver;
    private final InterpolationManager<Formula> imgr;
    private final Timer expandTime = new Timer();
    private final Timer forceCoverTime = new Timer();
    private final Timer refinementTime = new Timer();
    private final Timer coverTime = new Timer();
    private final Timer closeTime = new Timer();
    private int successfulForcedCovering = 0;
    @Option(description="enable the Forced Covering optimization")
    private boolean useForcedCovering = true;

    public ImpactAlgorithm(Configuration config, LogManager pLogger, ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException, CPAException {
        config.inject((Object)this);
        this.logger = pLogger;
        this.cpa = pCpa;
        FormulaManagerFactory factory = new FormulaManagerFactory(config, pLogger);
        this.fmgr = new ExtendedFormulaManager(factory.getFormulaManager(), config, this.logger);
        this.pfmgr = new CachingPathFormulaManager(new PathFormulaManagerImpl(this.fmgr, config, this.logger));
        this.prover = factory.createTheoremProver();
        this.solver = new Solver(this.fmgr, this.prover);
        this.imgr = new UninstantiatingInterpolationManager(this.fmgr, this.pfmgr, this.solver, factory, config, this.logger);
    }

    public AbstractElement getInitialElement(CFANode location) {
        return new Vertex(this.fmgr.makeTrue(), this.cpa.getInitialElement(location));
    }

    public Precision getInitialPrecision(CFANode location) {
        return this.cpa.getInitialPrecision(location);
    }

    @Override
    public boolean run(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        this.unwind(pReachedSet);
        pReachedSet.popFromWaitlist();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expand(Vertex v, ReachedSet reached) throws CPAException, InterruptedException {
        this.expandTime.start();
        try {
            assert (v.isLeaf() && !v.isCovered());
            AbstractElement predecessor = v.getWrappedElement();
            Precision precision = reached.getPrecision(v);
            CFANode loc = AbstractElements.extractLocation(v);
            for (CFAEdge edge : CFAUtils.leavingEdges(loc)) {
                Collection<? extends AbstractElement> successors = this.cpa.getTransferRelation().getAbstractSuccessors(predecessor, precision, edge);
                if (successors.isEmpty()) {
                    new Vertex(v, this.fmgr.makeFalse(), null);
                    continue;
                }
                assert (successors.size() == 1);
                Vertex w = new Vertex(v, this.fmgr.makeTrue(), (AbstractElement)Iterables.getOnlyElement(successors));
                reached.add(w, precision);
                reached.popFromWaitlist();
            }
        }
        finally {
            this.expandTime.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Vertex> refine(Vertex v) throws CPAException, InterruptedException {
        this.refinementTime.start();
        try {
            assert (v.isTarget() && !v.getStateFormula().isFalse());
            this.logger.log(Level.FINER, new Object[]{"Refinement on " + v});
            List<Vertex> path = this.getPathFromRootTo(v);
            path = path.subList(1, path.size());
            ArrayList<Formula> pathFormulas = new ArrayList<Formula>(path.size());
            this.addPathFormulasToList(path, pathFormulas);
            CounterexampleTraceInfo<Formula> cex = this.imgr.buildCounterexampleTrace(pathFormulas, Collections.<ARTElement>emptySet());
            if (!cex.isSpurious()) {
                List<Vertex> list = Collections.emptyList();
                return list;
            }
            this.logger.log(Level.FINER, new Object[]{"Refinement successful"});
            path = path.subList(0, path.size() - 1);
            assert (cex.getPredicatesForRefinement().size() == path.size());
            ArrayList<Vertex> changedElements = new ArrayList<Vertex>();
            for (Pair interpolationPoint : Pair.zipList(cex.getPredicatesForRefinement(), path)) {
                Formula stateFormula;
                Formula itp = (Formula)interpolationPoint.getFirst();
                Vertex w = (Vertex)interpolationPoint.getSecond();
                if (itp.isTrue() || this.solver.implies(stateFormula = w.getStateFormula(), itp)) continue;
                w.setStateFormula(this.fmgr.makeAnd(stateFormula, itp));
                w.cleanCoverage();
                changedElements.add(w);
            }
            if (!v.getStateFormula().isFalse()) {
                v.setStateFormula(this.fmgr.makeFalse());
                v.cleanCoverage();
                changedElements.add(v);
            }
            ArrayList<Vertex> arrayList = changedElements;
            return arrayList;
        }
        finally {
            this.refinementTime.stop();
        }
    }

    private boolean mayCover(Vertex v, Vertex w, Precision prec) throws CPAException {
        return v != w && !w.isCovered() && w.isOlderThan(v) && !v.isAncestorOf(w) && this.cpa.getStopOperator().stop(v.getWrappedElement(), Collections.singleton(w.getWrappedElement()), prec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cover(Vertex v, Vertex w, Precision prec) throws CPAException {
        this.coverTime.start();
        try {
            assert (!v.isCovered());
            if (this.mayCover(v, w, prec) && this.solver.implies(v.getStateFormula(), w.getStateFormula())) {
                for (Vertex y : v.getSubtree()) {
                    y.cleanCoverage();
                }
                v.setCoveredBy(w);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.coverTime.stop();
        }
    }

    private boolean forceCover(Vertex v, Vertex w, Precision prec) throws CPAException, InterruptedException {
        List<Vertex> path = new ArrayList<Vertex>();
        Vertex x = v;
        HashSet<Vertex> parentsOfW = new HashSet<Vertex>(this.getPathFromRootTo(w));
        while (!parentsOfW.contains(x)) {
            path.add(x);
            assert (x.hasParent());
            x = x.getParent();
        }
        path = Lists.reverse(path);
        ArrayList<Formula> formulas = new ArrayList<Formula>(path.size() + 2);
        PathFormula pf = this.pfmgr.makeEmptyPathFormula();
        formulas.add(this.fmgr.instantiate(x.getStateFormula(), SSAMap.emptySSAMap().withDefault(1)));
        for (Vertex w1 : path) {
            pf = this.pfmgr.makeAnd(pf, w1.getIncomingEdge());
            formulas.add(pf.getFormula());
            pf = this.pfmgr.makeEmptyPathFormula(pf);
        }
        formulas.add(this.fmgr.makeNot(this.fmgr.instantiate(w.getStateFormula(), pf.getSsa().withDefault(1))));
        path.add(0, x);
        assert (formulas.size() == path.size() + 1);
        CounterexampleTraceInfo<Formula> interpolantInfo = this.imgr.buildCounterexampleTrace(formulas, Collections.<ARTElement>emptySet());
        if (!interpolantInfo.isSpurious()) {
            this.logger.log(Level.FINER, new Object[]{"Forced covering unsuccessful."});
            return false;
        }
        ++this.successfulForcedCovering;
        this.logger.log(Level.FINER, new Object[]{"Forced covering successful."});
        List<Formula> interpolants = interpolantInfo.getPredicatesForRefinement();
        assert (interpolants.size() == formulas.size() - 1);
        assert (interpolants.size() == path.size());
        ArrayList<Vertex> changedElements = new ArrayList<Vertex>();
        for (Pair interpolationPoint : Pair.zipList(interpolants, path)) {
            Formula stateFormula;
            Formula itp = (Formula)interpolationPoint.getFirst();
            Vertex p = (Vertex)interpolationPoint.getSecond();
            if (itp.isTrue() || this.solver.implies(stateFormula = p.getStateFormula(), itp)) continue;
            p.setStateFormula(this.fmgr.makeAnd(stateFormula, itp));
            p.cleanCoverage();
            changedElements.add(p);
        }
        boolean covered = this.cover(v, w, prec);
        assert (covered);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean close(Vertex v, ReachedSet reached) throws CPAException {
        this.closeTime.start();
        try {
            if (v.isCovered()) {
                boolean bl = true;
                return bl;
            }
            Precision prec = reached.getPrecision(v);
            for (AbstractElement ae : reached.getReached(v)) {
                Vertex w = (Vertex)ae;
                if (!this.cover(v, w, prec)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeTime.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dfs(Vertex v, ReachedSet reached) throws CPAException, InterruptedException {
        if (this.close(v, reached)) {
            return true;
        }
        if (v.isTarget()) {
            List<Vertex> changedElements = this.refine(v);
            if (changedElements.isEmpty()) {
                return false;
            }
            for (Vertex w : changedElements) {
                if (this.close(w, reached)) break;
            }
            assert (v.getStateFormula().isFalse());
            return true;
        }
        if (!v.isLeaf()) {
            return true;
        }
        if (this.useForcedCovering) {
            this.forceCoverTime.start();
            try {
                Precision prec = reached.getPrecision(v);
                for (AbstractElement ae : reached.getReached(v)) {
                    Vertex w = (Vertex)ae;
                    if (!this.mayCover(v, w, prec) || !this.forceCover(v, w, prec)) continue;
                    assert (v.isCovered());
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.forceCoverTime.stop();
            }
        }
        this.expand(v, reached);
        for (Vertex w : v.getChildren()) {
            if (w.getStateFormula().isFalse()) continue;
            this.dfs(w, reached);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void unwind(ReachedSet reached) throws CPAException, InterruptedException {
        block0: while (true) {
            AbstractElement ae;
            Vertex v;
            Iterator<AbstractElement> i$ = reached.iterator();
            do {
                if (!i$.hasNext()) return;
            } while (!(v = (Vertex)(ae = i$.next())).isLeaf() || v.isCovered());
            List<Vertex> path = this.getPathFromRootTo(v);
            path = path.subList(0, path.size() - 1);
            for (Vertex w : path) {
                if (!this.close(w, reached)) continue;
                continue block0;
            }
            if (!this.dfs(v, reached)) break;
        }
        this.logger.log(Level.INFO, new Object[]{"Bug found"});
    }

    private void addPathFormulasToList(List<Vertex> path, List<Formula> pathFormulas) throws CPATransferException {
        PathFormula pf = this.pfmgr.makeEmptyPathFormula();
        for (Vertex w : path) {
            pf = this.pfmgr.makeAnd(pf, w.getIncomingEdge());
            pathFormulas.add(pf.getFormula());
            pf = this.pfmgr.makeEmptyPathFormula(pf);
        }
    }

    private List<Vertex> getPathFromRootTo(Vertex v) {
        ArrayList<Vertex> path = new ArrayList<Vertex>();
        Vertex w = v;
        while (w.hasParent()) {
            path.add(w);
            w = w.getParent();
        }
        path.add(w);
        return Lists.reverse(path);
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(new Stats());
    }

    private class Stats
    implements Statistics {
        private Stats() {
        }

        @Override
        public String getName() {
            return "Impact Algorithm";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, ReachedSet pReached) {
            out.println("Time for expand:                    " + ImpactAlgorithm.this.expandTime);
            if (ImpactAlgorithm.this.useForcedCovering) {
                out.println("  Time for forced covering:         " + ImpactAlgorithm.this.forceCoverTime);
            }
            out.println("Time for refinement:                " + ImpactAlgorithm.this.refinementTime);
            out.println("Time for close:                     " + ImpactAlgorithm.this.closeTime);
            out.println("  Time for cover:                   " + ImpactAlgorithm.this.coverTime);
            out.println("Time spent by solver for reasoning: " + ((ImpactAlgorithm)ImpactAlgorithm.this).solver.solverTime);
            out.println();
            out.println("Number of implication checks:       " + ((ImpactAlgorithm)ImpactAlgorithm.this).solver.implicationChecks);
            out.println("  trivial:                          " + ((ImpactAlgorithm)ImpactAlgorithm.this).solver.trivialImplicationChecks);
            out.println("  cached:                           " + ((ImpactAlgorithm)ImpactAlgorithm.this).solver.cachedImplicationChecks);
            out.println("Number of refinements:              " + ImpactAlgorithm.this.refinementTime.getNumberOfIntervals());
            if (ImpactAlgorithm.this.useForcedCovering) {
                out.println("Number of forced coverings:         " + ImpactAlgorithm.this.forceCoverTime.getNumberOfIntervals());
                out.println("  Successful:                       " + ImpactAlgorithm.this.successfulForcedCovering);
            }
        }
    }
}

