/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.defaults;

import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.defaults.FlatLatticeDomain;
import org.sosy_lab.cpachecker.core.defaults.MergeJoinOperator;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;

public abstract class AbstractCPA
implements ConfigurableProgramAnalysis {
    private final AbstractDomain abstractDomain;
    private final MergeOperator mergeOperator;
    private final StopOperator stopOperator;
    private final TransferRelation transferRelation;

    protected AbstractCPA(String mergeType, String stopType, TransferRelation transfer) {
        this(mergeType, stopType, new FlatLatticeDomain(), transfer);
    }

    protected AbstractCPA(String mergeType, String stopType, AbstractDomain domain, TransferRelation transfer) {
        this.abstractDomain = domain;
        if (mergeType.equalsIgnoreCase("join")) {
            this.mergeOperator = new MergeJoinOperator(this.abstractDomain);
        } else {
            assert (mergeType.equalsIgnoreCase("sep"));
            this.mergeOperator = MergeSepOperator.getInstance();
        }
        assert (stopType.equalsIgnoreCase("sep"));
        this.stopOperator = new StopSepOperator(this.abstractDomain);
        this.transferRelation = transfer;
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.abstractDomain;
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode) {
        return SingletonPrecision.getInstance();
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return StaticPrecisionAdjustment.getInstance();
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }
}

