/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.defaults;

import com.google.common.base.Preconditions;
import java.util.List;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;

public abstract class AbstractCPAFactory
implements CPAFactory {
    private LogManager logger = null;
    private Configuration configuration = null;

    @Override
    public CPAFactory setChild(ConfigurableProgramAnalysis pChild) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot wrap CPA");
    }

    @Override
    public CPAFactory setChildren(List<ConfigurableProgramAnalysis> pChildren) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot wrap CPAs");
    }

    @Override
    public CPAFactory setConfiguration(Configuration pConfiguration) {
        Preconditions.checkNotNull((Object)pConfiguration);
        Preconditions.checkState((this.configuration == null ? 1 : 0) != 0, (Object)"setConfiguration called twice on CPAFactory");
        this.configuration = pConfiguration;
        return this;
    }

    @Override
    public CPAFactory setLogger(LogManager pLogger) {
        Preconditions.checkNotNull((Object)pLogger);
        Preconditions.checkState((this.logger == null ? 1 : 0) != 0, (Object)"setLogger called twice on CPAFactory");
        this.logger = pLogger;
        return this;
    }

    protected LogManager getLogger() {
        Preconditions.checkState((this.logger != null ? 1 : 0) != 0, (Object)"LogManager object needed to create CPA");
        return this.logger;
    }

    protected Configuration getConfiguration() {
        Preconditions.checkState((this.configuration != null ? 1 : 0) != 0, (Object)"Configuration object needed to create CPA");
        return this.configuration;
    }

    @Override
    public <T> CPAFactory set(T pObject, Class<T> pClass) throws UnsupportedOperationException {
        return this;
    }
}

