/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.defaults;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.WrapperCPA;

public abstract class AbstractSingleWrapperCPA
implements ConfigurableProgramAnalysis,
WrapperCPA,
StatisticsProvider {
    private final ConfigurableProgramAnalysis wrappedCpa;

    public AbstractSingleWrapperCPA(ConfigurableProgramAnalysis pCpa) {
        Preconditions.checkNotNull((Object)pCpa);
        this.wrappedCpa = pCpa;
    }

    protected ConfigurableProgramAnalysis getWrappedCpa() {
        return this.wrappedCpa;
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode) {
        return this.wrappedCpa.getInitialPrecision(pNode);
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.wrappedCpa instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.wrappedCpa)).collectStatistics(pStatsCollection);
        }
    }

    @Override
    public <T extends ConfigurableProgramAnalysis> T retrieveWrappedCpa(Class<T> pType) {
        if (pType.isAssignableFrom(this.getClass())) {
            return (T)((ConfigurableProgramAnalysis)pType.cast(this));
        }
        if (pType.isAssignableFrom(this.wrappedCpa.getClass())) {
            return (T)((ConfigurableProgramAnalysis)pType.cast(this.wrappedCpa));
        }
        if (this.wrappedCpa instanceof WrapperCPA) {
            return ((WrapperCPA)((Object)this.wrappedCpa)).retrieveWrappedCpa(pType);
        }
        return null;
    }

    public ImmutableList<? extends ConfigurableProgramAnalysis> getWrappedCPAs() {
        return ImmutableList.of((Object)this.wrappedCpa);
    }
}

