/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.defaults;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class AutomaticCPAFactory
implements CPAFactory {
    private final Class<? extends ConfigurableProgramAnalysis> type;
    private final ClassToInstanceMap<Object> injects = MutableClassToInstanceMap.create();

    public static AutomaticCPAFactory forType(Class<? extends ConfigurableProgramAnalysis> type) {
        return new AutomaticCPAFactory(type);
    }

    public AutomaticCPAFactory(Class<? extends ConfigurableProgramAnalysis> type) {
        this.type = type;
    }

    private AutomaticCPAFactory(Class<? extends ConfigurableProgramAnalysis> pType, ClassToInstanceMap<Object> pInjects) {
        this.type = pType;
        this.injects.putAll(pInjects);
    }

    @Override
    public ConfigurableProgramAnalysis createInstance() throws InvalidConfigurationException, CPAException {
        Constructor<?>[] allConstructors = this.type.getDeclaredConstructors();
        if (allConstructors.length != 1) {
            throw new UnsupportedOperationException("Cannot automatically create CPAs with more than one constructor!");
        }
        Constructor<?> cons = allConstructors[0];
        cons.setAccessible(true);
        Class<?>[] formalParameters = cons.getParameterTypes();
        Annotation[][] parameterAnnotations = cons.getParameterAnnotations();
        Object[] actualParameters = new Object[formalParameters.length];
        for (int i = 0; i < formalParameters.length; ++i) {
            Class<?> formalParam = formalParameters[i];
            Object actualParam = this.get(formalParam);
            boolean optional = false;
            for (Annotation a : parameterAnnotations[i]) {
                if (!(a instanceof Optional)) continue;
                optional = true;
                break;
            }
            if (!optional) {
                Preconditions.checkNotNull(actualParam, (Object)(formalParam.getSimpleName() + " instance needed to create " + this.type.getSimpleName() + "-CPA!"));
            }
            actualParameters[i] = actualParam;
        }
        String exception = Classes.verifyDeclaredExceptions(cons, (Class[])new Class[]{InvalidConfigurationException.class, CPAException.class});
        if (exception != null) {
            throw new UnsupportedOperationException("Cannot automatically create CPAs if the constructor declares the unsupported checked exception " + exception);
        }
        try {
            return this.type.cast(cons.newInstance(actualParameters));
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            Throwables.propagateIfPossible((Throwable)t, CPAException.class, InvalidConfigurationException.class);
            throw new Classes.UnexpectedCheckedException("instantiation of CPA " + this.type.getSimpleName(), t);
        }
        catch (InstantiationException e) {
            throw new UnsupportedOperationException("Cannot automatically create CPAs that are declared abstract!");
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException("Cannot automatically create CPAs without an accessible constructor!");
        }
    }

    @Override
    public CPAFactory setLogger(LogManager pLogger) {
        return this.set(pLogger, LogManager.class);
    }

    @Override
    public CPAFactory setConfiguration(Configuration pConfiguration) {
        return this.set(pConfiguration, Configuration.class);
    }

    @Override
    public CPAFactory setChild(ConfigurableProgramAnalysis pChild) throws UnsupportedOperationException {
        return this.set(pChild, ConfigurableProgramAnalysis.class);
    }

    @Override
    public <T> CPAFactory set(T obj, Class<T> cls) throws UnsupportedOperationException {
        Preconditions.checkNotNull(cls);
        Preconditions.checkNotNull(obj);
        Preconditions.checkState((!this.injects.containsKey(cls) ? 1 : 0) != 0, (Object)("Cannot store two objects of class " + cls.getSimpleName()));
        this.injects.putInstance(cls, obj);
        return this;
    }

    public <T> T get(Class<T> cls) {
        return (T)this.injects.getInstance(cls);
    }

    @Override
    public CPAFactory setChildren(List<ConfigurableProgramAnalysis> pChildren) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot automatically create CPAs with multiple children CPAs!");
    }

    public <T> AutomaticCPAFactory withOptions(Class<T> optionsClass) {
        Constructor<T> constructor;
        Preconditions.checkArgument((optionsClass.getAnnotation(Options.class) != null ? 1 : 0) != 0, (Object)"Options holder class must be annotated with the Options annotation");
        try {
            constructor = optionsClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Options holder class must have a default constructor", e);
        }
        String exception = Classes.verifyDeclaredExceptions(constructor, (Class[])new Class[]{InvalidConfigurationException.class, CPAException.class});
        if (exception != null) {
            throw new IllegalArgumentException("Constructor of options holder class declares illegal checked exception: " + exception);
        }
        return new AutomaticCPAFactoryWithOptions(this.type, this.injects, optionsClass, constructor);
    }

    private static final class AutomaticCPAFactoryWithOptions<T>
    extends AutomaticCPAFactory {
        private final Class<T> optionsClass;
        private final Constructor<T> constructor;

        private AutomaticCPAFactoryWithOptions(Class<? extends ConfigurableProgramAnalysis> pType, ClassToInstanceMap<Object> pInjects, Class<T> pOptionsClass, Constructor<T> pConstructor) {
            super(pType, pInjects);
            this.optionsClass = pOptionsClass;
            this.constructor = pConstructor;
        }

        @Override
        public ConfigurableProgramAnalysis createInstance() throws InvalidConfigurationException, CPAException {
            T options;
            try {
                options = this.constructor.newInstance(new Object[0]);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getCause();
                Throwables.propagateIfPossible((Throwable)t, CPAException.class, InvalidConfigurationException.class);
                throw new Classes.UnexpectedCheckedException("instantiation of CPA options holder class " + this.optionsClass.getCanonicalName(), t);
            }
            catch (IllegalAccessException e) {
                throw new UnsupportedOperationException("Cannot automatically create CPAs without an accessible constructor for their options class!", e);
            }
            catch (InstantiationException e) {
                throw new UnsupportedOperationException("Cannot automatically create CPAs with an abstract options class!", e);
            }
            Configuration config = this.get(Configuration.class);
            Preconditions.checkState((config != null ? 1 : 0) != 0, (Object)"Configuration object needed to create CPA");
            config.recursiveInject(options);
            this.set(options, this.optionsClass);
            return super.createInstance();
        }
    }

    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Optional {
    }
}

