/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.defaults;

import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class FlatLatticeDomain
implements AbstractDomain {
    private final AbstractElement mTopElement;

    public FlatLatticeDomain(AbstractElement pTopElement) {
        assert (pTopElement != null);
        this.mTopElement = pTopElement;
    }

    public FlatLatticeDomain() {
        this(new TopElement());
    }

    @Override
    public AbstractElement join(AbstractElement pElement1, AbstractElement pElement2) throws CPAException {
        if (this.isLessOrEqual(pElement1, pElement2)) {
            return pElement2;
        }
        if (this.isLessOrEqual(pElement2, pElement1)) {
            return pElement1;
        }
        return this.mTopElement;
    }

    @Override
    public boolean isLessOrEqual(AbstractElement newElement, AbstractElement reachedElement) throws CPAException {
        return this.mTopElement.equals(reachedElement) || newElement.equals(reachedElement);
    }

    private static class TopElement
    implements AbstractElement {
        private TopElement() {
        }

        public String toString() {
            return "<TOP>";
        }
    }
}

