/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.reachedset;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterators;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.waitlist.Waitlist;

class DefaultReachedSet
implements ReachedSet {
    private final LinkedHashMap<AbstractElement, Precision> reached = new LinkedHashMap();
    private final Set<AbstractElement> unmodifiableReached = Collections.unmodifiableSet(this.reached.keySet());
    private AbstractElement lastElement = null;
    private AbstractElement firstElement = null;
    private final Waitlist waitlist;

    DefaultReachedSet(Waitlist.WaitlistFactory waitlistFactory) {
        this.waitlist = waitlistFactory.createWaitlistInstance();
    }

    @Override
    public void add(AbstractElement element, Precision precision) throws IllegalArgumentException {
        Precision previousPrecision;
        Preconditions.checkNotNull((Object)element);
        Preconditions.checkNotNull((Object)precision);
        if (this.reached.size() == 0) {
            this.firstElement = element;
        }
        if ((previousPrecision = this.reached.put(element, precision)) == null) {
            this.waitlist.add(element);
            this.lastElement = element;
        } else if (!precision.equals(previousPrecision)) {
            this.reached.put(element, previousPrecision);
            throw new IllegalArgumentException("Element added to reached set which is already contained, but with a different precision");
        }
    }

    @Override
    public void addAll(Iterable<Pair<AbstractElement, Precision>> toAdd) {
        for (Pair<AbstractElement, Precision> pair : toAdd) {
            this.add((AbstractElement)pair.getFirst(), (Precision)pair.getSecond());
        }
    }

    @Override
    public void reAddToWaitlist(AbstractElement e) {
        Preconditions.checkNotNull((Object)e);
        Preconditions.checkArgument((boolean)this.reached.containsKey(e), (Object)"Element has to be in the reached set");
        if (!this.waitlist.contains(e)) {
            this.waitlist.add(e);
        }
    }

    @Override
    public void updatePrecision(AbstractElement e, Precision newPrecision) {
        Preconditions.checkNotNull((Object)e);
        Preconditions.checkNotNull((Object)newPrecision);
        Precision oldPrecision = this.reached.put(e, newPrecision);
        if (oldPrecision == null) {
            this.reached.remove(e);
            throw new IllegalArgumentException("Element needs to be in the reached set in order to change the precision.");
        }
    }

    @Override
    public void remove(AbstractElement element) {
        Preconditions.checkNotNull((Object)element);
        int hc = element.hashCode();
        if (this.firstElement == null || hc == this.firstElement.hashCode() && element.equals(this.firstElement)) {
            this.firstElement = null;
        }
        if (this.lastElement == null || hc == this.lastElement.hashCode() && element.equals(this.lastElement)) {
            this.lastElement = null;
        }
        this.waitlist.remove(element);
        this.reached.remove(element);
    }

    @Override
    public void removeAll(Iterable<? extends AbstractElement> toRemove) {
        for (AbstractElement abstractElement : toRemove) {
            this.remove(abstractElement);
        }
        assert (this.firstElement != null || this.reached.isEmpty()) : "firstElement may only be removed if the whole reached set is cleared";
    }

    @Override
    public void removeOnlyFromWaitlist(AbstractElement element) {
        Preconditions.checkNotNull((Object)element);
        this.waitlist.remove(element);
    }

    @Override
    public void clear() {
        this.firstElement = null;
        this.lastElement = null;
        this.waitlist.clear();
        this.reached.clear();
    }

    public Set<AbstractElement> getReached() {
        return this.unmodifiableReached;
    }

    @Override
    public Iterator<AbstractElement> iterator() {
        return this.unmodifiableReached.iterator();
    }

    @Override
    public Collection<Pair<AbstractElement, Precision>> getReachedWithPrecision() {
        return Collections.unmodifiableCollection(Collections2.transform(this.reached.entrySet(), (Function)Pair.getPairFomMapEntry()));
    }

    @Override
    public Collection<Precision> getPrecisions() {
        return Collections.unmodifiableCollection(this.reached.values());
    }

    @Override
    public Collection<AbstractElement> getReached(AbstractElement element) {
        return this.getReached();
    }

    @Override
    public Collection<AbstractElement> getReached(CFANode location) {
        return this.getReached();
    }

    @Override
    public AbstractElement getFirstElement() {
        Preconditions.checkState((this.firstElement != null ? 1 : 0) != 0);
        return this.firstElement;
    }

    @Override
    public AbstractElement getLastElement() {
        return this.lastElement;
    }

    @Override
    public boolean hasWaitingElement() {
        return !this.waitlist.isEmpty();
    }

    @Override
    public Collection<AbstractElement> getWaitlist() {
        return new AbstractCollection<AbstractElement>(){

            @Override
            public Iterator<AbstractElement> iterator() {
                return Iterators.unmodifiableIterator(DefaultReachedSet.this.waitlist.iterator());
            }

            @Override
            public boolean contains(Object obj) {
                if (!(obj instanceof AbstractElement)) {
                    return false;
                }
                return DefaultReachedSet.this.waitlist.contains((AbstractElement)obj);
            }

            @Override
            public boolean isEmpty() {
                return DefaultReachedSet.this.waitlist.isEmpty();
            }

            @Override
            public int size() {
                return DefaultReachedSet.this.waitlist.size();
            }

            @Override
            public String toString() {
                return DefaultReachedSet.this.waitlist.toString();
            }
        };
    }

    @Override
    public AbstractElement popFromWaitlist() {
        return this.waitlist.pop();
    }

    @Override
    public int getWaitlistSize() {
        return this.waitlist.size();
    }

    @Override
    public Precision getPrecision(AbstractElement element) {
        Preconditions.checkNotNull((Object)element);
        Precision prec = this.reached.get(element);
        Preconditions.checkArgument((prec != null ? 1 : 0) != 0, (Object)"Element not in reached set.");
        return prec;
    }

    @Override
    public boolean contains(AbstractElement element) {
        Preconditions.checkNotNull((Object)element);
        return this.reached.containsKey(element);
    }

    @Override
    public int size() {
        return this.reached.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String toString() {
        return this.reached.keySet().toString();
    }
}

