/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.reachedset;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Partitionable;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.DefaultReachedSet;
import org.sosy_lab.cpachecker.core.waitlist.Waitlist;

public class PartitionedReachedSet
extends DefaultReachedSet {
    private final Multimap<Object, AbstractElement> partitionedReached = LinkedHashMultimap.create();

    public PartitionedReachedSet(Waitlist.WaitlistFactory waitlistFactory) {
        super(waitlistFactory);
    }

    @Override
    public void add(AbstractElement pElement, Precision pPrecision) {
        super.add(pElement, pPrecision);
        this.partitionedReached.put(this.getPartitionKey(pElement), (Object)pElement);
    }

    @Override
    public void remove(AbstractElement pElement) {
        super.remove(pElement);
        this.partitionedReached.remove(this.getPartitionKey(pElement), (Object)pElement);
    }

    @Override
    public void clear() {
        super.clear();
        this.partitionedReached.clear();
    }

    @Override
    public Collection<AbstractElement> getReached(AbstractElement pElement) {
        return this.getReachedForKey(this.getPartitionKey(pElement));
    }

    public int getNumberOfPartitions() {
        return this.partitionedReached.keySet().size();
    }

    public Map.Entry<Object, Collection<AbstractElement>> getMaxPartition() {
        int max = 0;
        Map.Entry maxPartition = null;
        for (Map.Entry partition : this.partitionedReached.asMap().entrySet()) {
            int size = ((Collection)partition.getValue()).size();
            if (size <= max) continue;
            max = ((Collection)partition.getValue()).size();
            maxPartition = partition;
        }
        return maxPartition;
    }

    protected Object getPartitionKey(AbstractElement pElement) {
        assert (pElement instanceof Partitionable) : "Partitionable elements necessary for PartitionedReachedSet";
        return ((Partitionable)((Object)pElement)).getPartitionKey();
    }

    protected Collection<AbstractElement> getReachedForKey(Object key) {
        return Collections.unmodifiableCollection(this.partitionedReached.get(key));
    }

    protected Set<?> getKeySet() {
        return Collections.unmodifiableSet(this.partitionedReached.keySet());
    }
}

