/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.reachedset;

import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.core.reachedset.DefaultReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.LocationMappedReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.PartitionedReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.waitlist.CallstackSortedWaitlist;
import org.sosy_lab.cpachecker.core.waitlist.ExplicitSortedWaitlist;
import org.sosy_lab.cpachecker.core.waitlist.TopologicallySortedWaitlist;
import org.sosy_lab.cpachecker.core.waitlist.Waitlist;

@Options(prefix="analysis")
public class ReachedSetFactory {
    @Option(name="traversal.order", description="which strategy to adopt for visiting states? TOPSORT is deprecated, use the option analysis.traversal.useTopsort instead")
    Waitlist.TraversalMethod traversalMethod = Waitlist.TraversalMethod.DFS;
    @Option(name="traversal.useCallstack", description="handle states with a deeper callstack first?\nThis needs the CallstackCPA to have any effect.")
    boolean useCallstack = false;
    @Option(name="traversal.useTopsort", description="Use an implementation of topsort strategy that allows to select a secondary strategy that is used if there are two elements with the same topsort id. The secondary strategy is selected with 'analysis.traversal.order'. The secondary strategy may not be TOPSORT.")
    boolean useTopSort = false;
    @Option(name="traversal.useExplicitInformation", description="handle more abstract states (with less information) first? (only for ExplicitCPA)")
    boolean useExplicitInformation = false;
    @Option(name="reachedSet", description="which reached set implementation to use?\nNORMAL: just a simple set\nLOCATIONMAPPED: a different set per location (faster, elements with different locations cannot be merged)\nPARTITIONED: partitioning depending on CPAs (e.g Location, Callstack etc.)")
    ReachedSetType reachedSet = ReachedSetType.PARTITIONED;

    public ReachedSetFactory(Configuration config, LogManager logger) throws InvalidConfigurationException {
        config.inject((Object)this);
        if (this.traversalMethod == Waitlist.TraversalMethod.TOPSORT) {
            logger.log(Level.WARNING, new Object[]{"Using the option 'analysis.traversal.order = TOPSORT' is deprecated, please switch to 'analysis.traversal.useTopSort = true'"});
            if (this.useTopSort) {
                throw new InvalidConfigurationException("Cannot use both 'analysis.traversal.order = TOPSORT' and 'analysis.traversal.useTopSort = true'");
            }
        }
    }

    public ReachedSet create() {
        Waitlist.WaitlistFactory waitlistFactory = this.traversalMethod;
        if (this.useTopSort) {
            waitlistFactory = TopologicallySortedWaitlist.factory(waitlistFactory);
        }
        if (this.useCallstack) {
            waitlistFactory = CallstackSortedWaitlist.factory(waitlistFactory);
        }
        if (this.useExplicitInformation) {
            waitlistFactory = ExplicitSortedWaitlist.factory(waitlistFactory);
        }
        switch (this.reachedSet) {
            case PARTITIONED: {
                return new PartitionedReachedSet(waitlistFactory);
            }
            case LOCATIONMAPPED: {
                return new LocationMappedReachedSet(waitlistFactory);
            }
        }
        return new DefaultReachedSet(waitlistFactory);
    }

    private static enum ReachedSetType {
        NORMAL,
        LOCATIONMAPPED,
        PARTITIONED;

    }
}

