/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.reachedset;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Iterator;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;

public class UnmodifiableReachedSetView
implements UnmodifiableReachedSet {
    private final UnmodifiableReachedSet underlying;
    private final Function<? super AbstractElement, AbstractElement> mapElementFunction;
    private final Function<? super Precision, Precision> mapPrecisionFunction;
    private final Function<Pair<AbstractElement, Precision>, Pair<AbstractElement, Precision>> mapElementAndPrecisionFunction;

    public UnmodifiableReachedSetView(UnmodifiableReachedSet pUnderlyingSet, Function<? super AbstractElement, AbstractElement> pMapElementFunction, Function<? super Precision, Precision> pMapPrecisionFunction) {
        assert (pUnderlyingSet != null);
        assert (pMapElementFunction != null);
        assert (pMapPrecisionFunction != null);
        this.underlying = pUnderlyingSet;
        this.mapElementFunction = pMapElementFunction;
        this.mapPrecisionFunction = pMapPrecisionFunction;
        this.mapElementAndPrecisionFunction = new Function<Pair<AbstractElement, Precision>, Pair<AbstractElement, Precision>>(){

            public Pair<AbstractElement, Precision> apply(Pair<AbstractElement, Precision> from) {
                return Pair.of((Object)UnmodifiableReachedSetView.this.mapElementFunction.apply(from.getFirst()), (Object)UnmodifiableReachedSetView.this.mapPrecisionFunction.apply(from.getSecond()));
            }
        };
    }

    @Override
    public AbstractElement getFirstElement() {
        return (AbstractElement)this.mapElementFunction.apply((Object)this.underlying.getFirstElement());
    }

    @Override
    public AbstractElement getLastElement() {
        return (AbstractElement)this.mapElementFunction.apply((Object)this.underlying.getLastElement());
    }

    @Override
    public Precision getPrecision(AbstractElement pElement) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Unwrapping prevents reverse mapping");
    }

    @Override
    public Collection<AbstractElement> getReached() {
        return Collections2.transform(this.underlying.getReached(), this.mapElementFunction);
    }

    @Override
    public Collection<AbstractElement> getReached(AbstractElement pElement) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Unwrapping may prevent to know the location");
    }

    @Override
    public Collection<AbstractElement> getReached(CFANode pLocation) {
        return Collections2.transform(this.underlying.getReached(pLocation), this.mapElementFunction);
    }

    @Override
    public Collection<Pair<AbstractElement, Precision>> getReachedWithPrecision() {
        return Collections2.transform(this.underlying.getReachedWithPrecision(), this.mapElementAndPrecisionFunction);
    }

    @Override
    public Collection<Precision> getPrecisions() {
        return Collections2.transform(this.underlying.getPrecisions(), this.mapPrecisionFunction);
    }

    @Override
    public Collection<AbstractElement> getWaitlist() {
        return Collections2.transform(this.underlying.getWaitlist(), this.mapElementFunction);
    }

    @Override
    public int getWaitlistSize() {
        return this.underlying.getWaitlistSize();
    }

    @Override
    public boolean hasWaitingElement() {
        return this.underlying.hasWaitingElement();
    }

    @Override
    public Iterator<AbstractElement> iterator() {
        return Iterators.transform(this.underlying.iterator(), this.mapElementFunction);
    }

    @Override
    public boolean contains(AbstractElement pElement) {
        throw new UnsupportedOperationException("Unwrapping may prevent to check contains");
    }

    @Override
    public boolean isEmpty() {
        return this.underlying.isEmpty();
    }

    @Override
    public int size() {
        return this.underlying.size();
    }
}

