/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.waitlist;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.waitlist.Waitlist;

public abstract class AbstractSortedWaitlist<K extends Comparable<K>>
implements Waitlist {
    private final Waitlist.WaitlistFactory wrappedWaitlist;
    private final NavigableMap<K, Waitlist> waitlist = new TreeMap<K, Waitlist>();
    private int size = 0;

    protected AbstractSortedWaitlist(Waitlist.WaitlistFactory pSecondaryStrategy) {
        this.wrappedWaitlist = (Waitlist.WaitlistFactory)Preconditions.checkNotNull((Object)pSecondaryStrategy);
    }

    protected abstract K getSortKey(AbstractElement var1);

    @Override
    public void add(AbstractElement pElement) {
        K key = this.getSortKey(pElement);
        Waitlist localWaitlist = (Waitlist)this.waitlist.get(key);
        if (localWaitlist == null) {
            localWaitlist = this.wrappedWaitlist.createWaitlistInstance();
            this.waitlist.put(key, localWaitlist);
        } else assert (!localWaitlist.isEmpty());
        localWaitlist.add(pElement);
        ++this.size;
    }

    @Override
    public boolean contains(AbstractElement pElement) {
        K key = this.getSortKey(pElement);
        Waitlist localWaitlist = (Waitlist)this.waitlist.get(key);
        if (localWaitlist == null) {
            return false;
        }
        assert (!localWaitlist.isEmpty());
        return localWaitlist.contains(pElement);
    }

    @Override
    public void clear() {
        this.waitlist.clear();
        this.size = 0;
    }

    @Override
    public boolean isEmpty() {
        assert (this.waitlist.isEmpty() == (this.size == 0));
        return this.waitlist.isEmpty();
    }

    @Override
    public Iterator<AbstractElement> iterator() {
        return Iterables.concat(this.waitlist.values()).iterator();
    }

    @Override
    public AbstractElement pop() {
        Map.Entry<K, Waitlist> highestEntry = this.waitlist.lastEntry();
        Waitlist localWaitlist = highestEntry.getValue();
        assert (!localWaitlist.isEmpty());
        AbstractElement result = localWaitlist.pop();
        if (localWaitlist.isEmpty()) {
            this.waitlist.remove(highestEntry.getKey());
        }
        --this.size;
        return result;
    }

    @Override
    public boolean remove(AbstractElement pElement) {
        K key = this.getSortKey(pElement);
        Waitlist localWaitlist = (Waitlist)this.waitlist.get(key);
        if (localWaitlist == null) {
            return false;
        }
        assert (!localWaitlist.isEmpty());
        boolean result = localWaitlist.remove(pElement);
        if (result) {
            if (localWaitlist.isEmpty()) {
                this.waitlist.remove(key);
            }
            --this.size;
        }
        return result;
    }

    @Override
    public int size() {
        return this.size;
    }

    public String toString() {
        return this.waitlist.toString();
    }
}

