/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.abm;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.LinkedList;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.abm.ABMCPA;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.util.AbstractElements;

class ABMARTUtils {
    private ABMARTUtils() {
    }

    public static Multimap<Block, ReachedSet> gatherReachedSets(ABMCPA cpa, ReachedSet finalReachedSet) {
        HashMultimap result = HashMultimap.create();
        ABMARTUtils.gatherReachedSets(cpa, cpa.getBlockPartitioning().getMainBlock(), finalReachedSet, (Multimap<Block, ReachedSet>)result);
        return result;
    }

    private static void gatherReachedSets(ABMCPA cpa, Block block, ReachedSet reachedSet, Multimap<Block, ReachedSet> blockToReachedSet) {
        if (blockToReachedSet.containsEntry((Object)block, (Object)reachedSet)) {
            return;
        }
        blockToReachedSet.put((Object)block, (Object)reachedSet);
        ARTElement firstElement = (ARTElement)reachedSet.getFirstElement();
        LinkedList<ARTElement> worklist = new LinkedList<ARTElement>();
        HashSet<ARTElement> processed = new HashSet<ARTElement>();
        worklist.add(firstElement);
        while (worklist.size() != 0) {
            ARTElement currentElement = (ARTElement)worklist.removeLast();
            assert (reachedSet.contains(currentElement));
            if (processed.contains(currentElement)) continue;
            processed.add(currentElement);
            for (ARTElement child : currentElement.getChildren()) {
                CFAEdge edge = ABMARTUtils.getEdgeToChild(currentElement, child);
                if (edge == null) {
                    Pair<Block, ReachedSet> pair = cpa.getTransferRelation().getCachedReachedSet(currentElement, reachedSet.getPrecision(currentElement));
                    ABMARTUtils.gatherReachedSets(cpa, (Block)pair.getFirst(), (ReachedSet)pair.getSecond(), blockToReachedSet);
                }
                if (worklist.contains(child) || !reachedSet.contains(child)) continue;
                worklist.add(child);
            }
        }
    }

    public static CFAEdge getEdgeToChild(ARTElement parent, ARTElement child) {
        CFANode currentLoc = AbstractElements.extractLocation(parent);
        CFANode childNode = AbstractElements.extractLocation(child);
        return ABMARTUtils.getEdgeTo(currentLoc, childNode);
    }

    public static CFAEdge getEdgeTo(CFANode node1, CFANode node2) {
        for (int i = 0; i < node1.getNumLeavingEdges(); ++i) {
            CFAEdge edge = node1.getLeavingEdge(i);
            if (edge.getSuccessor() != node2) continue;
            return edge;
        }
        return null;
    }
}

