/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.abm;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.ClassOption;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.cfa.blocks.builder.FunctionAndLoopPartitioning;
import org.sosy_lab.cpachecker.cfa.blocks.builder.PartitioningHeuristic;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithABM;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.WrapperCPA;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.cpa.abm.ABMCPAStatistics;
import org.sosy_lab.cpachecker.cpa.abm.ABMPrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.abm.ABMTransferRelation;
import org.sosy_lab.cpachecker.cpa.abm.TimedReducer;
import org.sosy_lab.cpachecker.cpa.predicate.ABMPredicateCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;

@Options(prefix="cpa.abm")
public class ABMCPA
extends AbstractSingleWrapperCPA
implements StatisticsProvider {
    private BlockPartitioning blockPartitioning;
    private final LogManager logger;
    private final TimedReducer reducer;
    private final ABMTransferRelation transfer;
    private final ABMPrecisionAdjustment prec;
    private final ABMCPAStatistics stats;
    private final PartitioningHeuristic heuristic;
    private final CFA cfa;
    @Option(description="Type of partitioning (FunctionAndLoopPartitioning or DelayedFunctionAndLoopPartitioning)\nor any class that implements a PartitioningHeuristic")
    @ClassOption(packagePrefix="org.sosy_lab.cpachecker.cfa.blocks.builder")
    private Class<? extends PartitioningHeuristic> blockHeuristic = FunctionAndLoopPartitioning.class;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(ABMCPA.class);
    }

    public ABMCPA(ConfigurableProgramAnalysis pCpa, Configuration config, LogManager pLogger, ReachedSetFactory pReachedSetFactory, CFA pCfa) throws InvalidConfigurationException, CPAException {
        super(pCpa);
        config.inject((Object)this);
        this.logger = pLogger;
        this.cfa = pCfa;
        if (!(pCpa instanceof ConfigurableProgramAnalysisWithABM)) {
            throw new InvalidConfigurationException("ABM needs CPAs that are capable for ABM");
        }
        Reducer wrappedReducer = ((ConfigurableProgramAnalysisWithABM)pCpa).getReducer();
        if (wrappedReducer == null) {
            throw new InvalidConfigurationException("ABM needs CPAs that are capable for ABM");
        }
        this.reducer = new TimedReducer(wrappedReducer);
        this.prec = new ABMPrecisionAdjustment(this.getWrappedCpa().getPrecisionAdjustment());
        this.transfer = new ABMTransferRelation(config, this.logger, this, pReachedSetFactory);
        this.stats = new ABMCPAStatistics(this);
        this.heuristic = this.getPartitioningHeuristic();
    }

    @Override
    public AbstractElement getInitialElement(CFANode node) {
        if (this.blockPartitioning == null) {
            this.blockPartitioning = this.heuristic.buildPartitioning(node);
            this.transfer.setBlockPartitioning(this.blockPartitioning);
            ABMPredicateCPA predicateCpa = ((WrapperCPA)((Object)this.getWrappedCpa())).retrieveWrappedCpa(ABMPredicateCPA.class);
            if (predicateCpa != null) {
                predicateCpa.setPartitioning(this.blockPartitioning);
            }
            HashMap<AbstractElement, Precision> forwardPrecisionToExpandedPrecision = new HashMap<AbstractElement, Precision>();
            this.transfer.setForwardPrecisionToExpandedPrecision(forwardPrecisionToExpandedPrecision);
            this.prec.setForwardPrecisionToExpandedPrecision(forwardPrecisionToExpandedPrecision);
        }
        return this.getWrappedCpa().getInitialElement(node);
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode) {
        return this.getWrappedCpa().getInitialPrecision(pNode);
    }

    private PartitioningHeuristic getPartitioningHeuristic() throws CPAException, InvalidConfigurationException {
        return (PartitioningHeuristic)Classes.createInstance(PartitioningHeuristic.class, this.blockHeuristic, (Class[])new Class[]{LogManager.class, CFA.class}, (Object[])new Object[]{this.logger, this.cfa}, CPAException.class);
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.getWrappedCpa().getAbstractDomain();
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.getWrappedCpa().getMergeOperator();
    }

    @Override
    public StopOperator getStopOperator() {
        return this.getWrappedCpa().getStopOperator();
    }

    @Override
    public ABMPrecisionAdjustment getPrecisionAdjustment() {
        return this.prec;
    }

    @Override
    public ABMTransferRelation getTransferRelation() {
        return this.transfer;
    }

    TimedReducer getReducer() {
        return this.reducer;
    }

    @Override
    protected ConfigurableProgramAnalysis getWrappedCpa() {
        return super.getWrappedCpa();
    }

    BlockPartitioning getBlockPartitioning() {
        Preconditions.checkState((this.blockPartitioning != null ? 1 : 0) != 0);
        return this.blockPartitioning;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
        super.collectStatistics(pStatsCollection);
    }

    ABMCPAStatistics getStatistics() {
        return this.stats;
    }
}

