/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.abm;

import com.google.common.base.Preconditions;
import java.io.PrintStream;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.abm.ABMARTUtils;
import org.sosy_lab.cpachecker.cpa.abm.ABMCPA;
import org.sosy_lab.cpachecker.cpa.abm.ABMTransferRelation;
import org.sosy_lab.cpachecker.cpa.abm.AbstractABMBasedRefiner;
import org.sosy_lab.cpachecker.cpa.abm.TimedReducer;

class ABMCPAStatistics
implements Statistics {
    private final ABMCPA cpa;
    private AbstractABMBasedRefiner refiner = null;

    public ABMCPAStatistics(ABMCPA cpa) {
        this.cpa = cpa;
    }

    @Override
    public String getName() {
        return "ABMCPA";
    }

    public void addRefiner(AbstractABMBasedRefiner pRefiner) {
        Preconditions.checkState((this.refiner == null ? 1 : 0) != 0);
        this.refiner = pRefiner;
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, ReachedSet reached) {
        ABMTransferRelation transferRelation = this.cpa.getTransferRelation();
        TimedReducer reducer = this.cpa.getReducer();
        int sumCalls = transferRelation.cacheMisses + transferRelation.partialCacheHits + transferRelation.fullCacheHits;
        int sumARTElemets = 0;
        for (ReachedSet subreached : ABMARTUtils.gatherReachedSets(this.cpa, reached).values()) {
            sumARTElemets += subreached.size();
        }
        out.println("Total size of all ARTs:                                         " + sumARTElemets);
        out.println("Maximum block depth:                                            " + transferRelation.maxRecursiveDepth);
        out.println("Total number of recursive CPA calls:                            " + sumCalls);
        out.println("  Number of cache misses:                                       " + transferRelation.cacheMisses + " (" + this.toPercent(transferRelation.cacheMisses, sumCalls) + " of all calls)");
        out.println("  Number of partial cache hits:                                 " + transferRelation.partialCacheHits + " (" + this.toPercent(transferRelation.partialCacheHits, sumCalls) + " of all calls)");
        out.println("  Number of full cache hits:                                    " + transferRelation.fullCacheHits + " (" + this.toPercent(transferRelation.fullCacheHits, sumCalls) + " of all calls)");
        if (transferRelation.gatherCacheMissStatistics) {
            out.println("Cause for cache misses:                                         ");
            out.println("  Number of abstraction caused misses:                          " + transferRelation.abstractionCausedMisses + " (" + this.toPercent(transferRelation.abstractionCausedMisses, transferRelation.cacheMisses) + " of all misses)");
            out.println("  Number of precision caused misses:                            " + transferRelation.precisionCausedMisses + " (" + this.toPercent(transferRelation.precisionCausedMisses, transferRelation.cacheMisses) + " of all misses)");
            out.println("  Number of misses with no similar elements:                    " + transferRelation.noSimilarCausedMisses + " (" + this.toPercent(transferRelation.noSimilarCausedMisses, transferRelation.cacheMisses) + " of all misses)");
        }
        out.println("Time for reducing abstract elements:                            " + reducer.reduceTime + " (Calls: " + reducer.reduceTime.getNumberOfIntervals() + ")");
        out.println("Time for expanding abstract elements:                           " + reducer.expandTime + " (Calls: " + reducer.expandTime.getNumberOfIntervals() + ")");
        out.println("Time for checking equality of abstract elements:                " + transferRelation.equalsTimer + " (Calls: " + transferRelation.equalsTimer.getNumberOfIntervals() + ")");
        out.println("Time for computing the hashCode of abstract elements:           " + transferRelation.hashingTimer + " (Calls: " + transferRelation.hashingTimer.getNumberOfIntervals() + ")");
        out.println("Time for searching for similar cache entries:                   " + transferRelation.searchingTimer + " (Calls: " + transferRelation.searchingTimer.getNumberOfIntervals() + ")");
        out.println("Time for reducing precisions:                                   " + reducer.reducePrecisionTime + " (Calls: " + reducer.reducePrecisionTime.getNumberOfIntervals() + ")");
        out.println("Time for expanding precisions:                                  " + reducer.expandPrecisionTime + " (Calls: " + reducer.expandPrecisionTime.getNumberOfIntervals() + ")");
        out.println("Time for removing cached subtrees for refinement:               " + transferRelation.removeCachedSubtreeTimer);
        out.println("Time for recomputing ARTs during counterexample analysis:       " + transferRelation.recomputeARTTimer);
        if (this.refiner != null) {
            out.println("Compute path for refinement:                                    " + this.refiner.computePathTimer);
            out.println("  Constructing flat ART:                                        " + this.refiner.computeSubtreeTimer);
            out.println("  Searching path to error location:                             " + this.refiner.computeCounterexampleTimer);
        }
    }

    private String toPercent(double val, double full) {
        return String.format("%1.0f", val / full * 100.0) + "%";
    }
}

