/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.abm;

import java.util.Map;
import org.sosy_lab.common.Triple;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class ABMPrecisionAdjustment
implements PrecisionAdjustment {
    private Map<AbstractElement, Precision> forwardPrecisionToExpandedPrecision;
    private boolean breakAnalysis = false;
    private final PrecisionAdjustment wrappedPrecisionAdjustment;

    public ABMPrecisionAdjustment(PrecisionAdjustment pWrappedPrecisionAdjustment) {
        this.wrappedPrecisionAdjustment = pWrappedPrecisionAdjustment;
    }

    void setForwardPrecisionToExpandedPrecision(Map<AbstractElement, Precision> pForwardPrecisionToExpandedPrecision) {
        this.forwardPrecisionToExpandedPrecision = pForwardPrecisionToExpandedPrecision;
    }

    @Override
    public Triple<AbstractElement, Precision, PrecisionAdjustment.Action> prec(AbstractElement pElement, Precision pPrecision, UnmodifiableReachedSet pElements) throws CPAException {
        if (this.breakAnalysis) {
            return Triple.of((Object)pElement, (Object)pPrecision, (Object)((Object)PrecisionAdjustment.Action.BREAK));
        }
        Triple<AbstractElement, Precision, PrecisionAdjustment.Action> result = this.wrappedPrecisionAdjustment.prec(pElement, pPrecision, pElements);
        Precision newPrecision = this.forwardPrecisionToExpandedPrecision.get(pElement);
        if (newPrecision != null) {
            return Triple.of((Object)result.getFirst(), (Object)newPrecision, (Object)result.getThird());
        }
        return result;
    }

    void breakAnalysis() {
        this.breakAnalysis = true;
    }
}

