/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.abm;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Timer;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.abm.ABMARTUtils;
import org.sosy_lab.cpachecker.cpa.abm.ABMCPA;
import org.sosy_lab.cpachecker.cpa.abm.ABMPrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.abm.RecursiveAnalysisFailedException;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.cpa.art.ARTReachedSet;
import org.sosy_lab.cpachecker.cpa.art.Path;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractElements;
import org.sosy_lab.cpachecker.util.Precisions;

@Options(prefix="cpa.abm")
public class ABMTransferRelation
implements TransferRelation {
    @Option(description="if enabled, cache queries also consider blocks with non-matching precision for reuse.")
    private boolean aggressiveCaching = true;
    private final Cache artCache = new Cache();
    private final Map<AbstractElement, ReachedSet> abstractElementToReachedSet = new HashMap<AbstractElement, ReachedSet>();
    private final Map<AbstractElement, AbstractElement> expandedToReducedCache = new HashMap<AbstractElement, AbstractElement>();
    private Block currentBlock;
    private BlockPartitioning partitioning;
    private int depth = 0;
    private final LogManager logger;
    private final CPAAlgorithm algorithm;
    private final TransferRelation wrappedTransfer;
    private final ReachedSetFactory reachedSetFactory;
    private final Reducer wrappedReducer;
    private final ABMPrecisionAdjustment prec;
    private Map<AbstractElement, Precision> forwardPrecisionToExpandedPrecision;
    @Option(description="if enabled, the reached set cache is analysed for each cache miss to find the cause of the miss.")
    boolean gatherCacheMissStatistics = false;
    int cacheMisses = 0;
    int partialCacheHits = 0;
    int fullCacheHits = 0;
    int maxRecursiveDepth = 0;
    int abstractionCausedMisses = 0;
    int precisionCausedMisses = 0;
    int noSimilarCausedMisses = 0;
    final Timer hashingTimer = new Timer();
    final Timer equalsTimer = new Timer();
    final Timer recomputeARTTimer = new Timer();
    final Timer removeCachedSubtreeTimer = new Timer();
    final Timer removeSubtreeTimer = new Timer();
    final Timer searchingTimer = new Timer();

    public ABMTransferRelation(Configuration pConfig, LogManager pLogger, ABMCPA abmCpa, ReachedSetFactory pReachedSetFactory) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = pLogger;
        this.algorithm = new CPAAlgorithm(abmCpa, this.logger);
        this.reachedSetFactory = pReachedSetFactory;
        this.wrappedTransfer = abmCpa.getWrappedCpa().getTransferRelation();
        this.wrappedReducer = abmCpa.getReducer();
        this.prec = abmCpa.getPrecisionAdjustment();
        assert (this.wrappedReducer != null);
    }

    void setForwardPrecisionToExpandedPrecision(Map<AbstractElement, Precision> pForwardPrecisionToExpandedPrecision) {
        this.forwardPrecisionToExpandedPrecision = pForwardPrecisionToExpandedPrecision;
    }

    void setBlockPartitioning(BlockPartitioning pManager) {
        this.partitioning = pManager;
        this.currentBlock = this.partitioning.getMainBlock();
    }

    public BlockPartitioning getBlockPartitioning() {
        assert (this.partitioning != null);
        return this.partitioning;
    }

    @Override
    public Collection<? extends AbstractElement> getAbstractSuccessors(AbstractElement pElement, Precision pPrecision, CFAEdge edge) throws CPATransferException, InterruptedException {
        this.forwardPrecisionToExpandedPrecision.clear();
        if (edge == null) {
            CFANode node = AbstractElements.extractLocation(pElement);
            if (this.partitioning.isCallNode(node)) {
                if (this.partitioning.getBlockForCallNode(node).equals(this.currentBlock)) {
                    return this.wrappedTransfer.getAbstractSuccessors(pElement, pPrecision, edge);
                }
                if (this.isHeadOfMainFunction(node)) {
                    return this.wrappedTransfer.getAbstractSuccessors(pElement, pPrecision, edge);
                }
                this.logger.log(Level.FINER, new Object[]{"Starting recursive analysis of depth", ++this.depth});
                this.logger.log(Level.ALL, new Object[]{"Starting element:", pElement});
                this.maxRecursiveDepth = Math.max(this.depth, this.maxRecursiveDepth);
                Block outerSubtree = this.currentBlock;
                this.currentBlock = this.partitioning.getBlockForCallNode(node);
                Collection<Pair<AbstractElement, Precision>> reducedResult = this.performCompositeAnalysis(pElement, pPrecision, node);
                this.logger.log(Level.FINER, new Object[]{"Recursive analysis of depth", this.depth--, "finished"});
                this.logger.log(Level.ALL, new Object[]{"Resulting elements:", reducedResult});
                ArrayList<ARTElement> expandedResult = new ArrayList<ARTElement>(reducedResult.size());
                for (Pair<AbstractElement, Precision> reducedPair : reducedResult) {
                    AbstractElement reducedElement = (AbstractElement)reducedPair.getFirst();
                    Precision reducedPrecision = (Precision)reducedPair.getSecond();
                    ARTElement expandedElement = (ARTElement)this.wrappedReducer.getVariableExpandedElement(pElement, this.currentBlock, reducedElement);
                    this.expandedToReducedCache.put(expandedElement, reducedElement);
                    Precision expandedPrecision = this.wrappedReducer.getVariableExpandedPrecision(pPrecision, outerSubtree, reducedPrecision);
                    expandedElement.addParent((ARTElement)pElement);
                    expandedResult.add(expandedElement);
                    this.forwardPrecisionToExpandedPrecision.put(expandedElement, expandedPrecision);
                }
                this.logger.log(Level.ALL, new Object[]{"Expanded results:", expandedResult});
                this.currentBlock = outerSubtree;
                return expandedResult;
            }
            ArrayList<? extends AbstractElement> result = new ArrayList<AbstractElement>();
            for (int i = 0; i < node.getNumLeavingEdges(); ++i) {
                CFAEdge e = node.getLeavingEdge(i);
                result.addAll(this.getAbstractSuccessors0(pElement, pPrecision, e));
            }
            return result;
        }
        return this.getAbstractSuccessors0(pElement, pPrecision, edge);
    }

    private Collection<? extends AbstractElement> getAbstractSuccessors0(AbstractElement pElement, Precision pPrecision, CFAEdge edge) throws CPATransferException, InterruptedException {
        assert (edge != null);
        CFANode currentNode = edge.getPredecessor();
        Block currentNodeBlock = this.partitioning.getBlockForReturnNode(currentNode);
        if (currentNodeBlock != null && !this.currentBlock.equals(currentNodeBlock) && currentNodeBlock.getNodes().contains(edge.getSuccessor())) {
            return Collections.emptySet();
        }
        if (this.currentBlock.isReturnNode(currentNode) && !this.currentBlock.getNodes().contains(edge.getSuccessor())) {
            return Collections.emptySet();
        }
        return this.wrappedTransfer.getAbstractSuccessors(pElement, pPrecision, edge);
    }

    private boolean isHeadOfMainFunction(CFANode currentNode) {
        return currentNode instanceof CFAFunctionDefinitionNode && currentNode.getNumEnteringEdges() == 0;
    }

    private Collection<Pair<AbstractElement, Precision>> performCompositeAnalysis(AbstractElement initialElement, Precision initialPrecision, CFANode node) throws InterruptedException, RecursiveAnalysisFailedException {
        try {
            AbstractElement reducedInitialElement = this.wrappedReducer.getVariableReducedElement(initialElement, this.currentBlock, node);
            Precision reducedInitialPrecision = this.wrappedReducer.getVariableReducedPrecision(initialPrecision, this.currentBlock);
            Pair pair = this.artCache.get(reducedInitialElement, reducedInitialPrecision, this.currentBlock);
            ReachedSet reached = (ReachedSet)pair.getFirst();
            List<AbstractElement> returnElements = (List<AbstractElement>)pair.getSecond();
            this.abstractElementToReachedSet.put(initialElement, reached);
            if (returnElements != null) {
                assert (reached != null);
                ++this.fullCacheHits;
                return this.imbueAbstractElementsWithPrecision(reached, (Collection<AbstractElement>)returnElements);
            }
            if (reached != null) {
                ++this.partialCacheHits;
            } else {
                ++this.cacheMisses;
                if (this.gatherCacheMissStatistics) {
                    this.artCache.findCacheMissCause(reducedInitialElement, reducedInitialPrecision, this.currentBlock);
                }
                reached = this.createInitialReachedSet(reducedInitialElement, reducedInitialPrecision);
                this.artCache.put(reducedInitialElement, reducedInitialPrecision, this.currentBlock, reached);
                this.abstractElementToReachedSet.put(initialElement, reached);
            }
            this.algorithm.run(reached);
            AbstractElement lastElement = reached.getLastElement();
            if (AbstractElements.isTargetElement(lastElement)) {
                returnElements = Collections.singletonList(lastElement);
            } else {
                if (reached.hasWaitingElement()) {
                    this.prec.breakAnalysis();
                    return Collections.singletonList(Pair.of((Object)reducedInitialElement, (Object)reducedInitialPrecision));
                }
                returnElements = new ArrayList<AbstractElement>();
                for (CFANode returnNode : this.currentBlock.getReturnNodes()) {
                    Iterables.addAll(returnElements, AbstractElements.filterLocation(reached, returnNode));
                }
            }
            this.artCache.put(reducedInitialElement, reached.getPrecision(reached.getFirstElement()), this.currentBlock, returnElements);
            return this.imbueAbstractElementsWithPrecision(reached, returnElements);
        }
        catch (CPAException e) {
            throw new RecursiveAnalysisFailedException(e);
        }
    }

    private List<Pair<AbstractElement, Precision>> imbueAbstractElementsWithPrecision(ReachedSet pReached, Collection<AbstractElement> pElements) {
        ArrayList<Pair<AbstractElement, Precision>> result = new ArrayList<Pair<AbstractElement, Precision>>();
        for (AbstractElement ele : pElements) {
            result.add((Pair<AbstractElement, Precision>)Pair.of((Object)ele, (Object)pReached.getPrecision(ele)));
        }
        return result;
    }

    private ReachedSet createInitialReachedSet(AbstractElement initialElement, Precision initialPredicatePrecision) {
        ReachedSet reached = this.reachedSetFactory.create();
        reached.add(initialElement, initialPredicatePrecision);
        return reached;
    }

    void removeSubtree(ARTReachedSet mainReachedSet, Path pPath, ARTElement element, Precision newPrecision, Map<ARTElement, ARTElement> pPathElementToReachedElement) {
        ARTElement aRTElement;
        this.removeSubtreeTimer.start();
        List<ARTElement> path = this.trimPath(pPath, element);
        assert (path.get(path.size() - 1).equals(element));
        Set<ARTElement> relevantCallNodes = this.getRelevantDefinitionNodes(path);
        HashSet<Pair> neededRemoveSubtreeCalls = new HashSet<Pair>();
        HashSet<Pair<ARTElement, ARTElement>> neededRemoveCachedSubtreeCalls = new HashSet<Pair<ARTElement, ARTElement>>();
        ARTElement lastElement = null;
        Iterator<Object> i$ = Iterables.skip(path, (int)1).iterator();
        while (i$.hasNext() && !(aRTElement = (ARTElement)i$.next()).equals(element)) {
            if (!relevantCallNodes.contains(aRTElement)) continue;
            ARTElement currentElement = pPathElementToReachedElement.get(aRTElement);
            if (lastElement == null) {
                neededRemoveSubtreeCalls.add(Pair.of((Object)mainReachedSet, (Object)currentElement));
            } else {
                neededRemoveCachedSubtreeCalls.add((Pair<ARTElement, ARTElement>)Pair.of(lastElement, (Object)currentElement));
            }
            lastElement = currentElement;
        }
        if (this.aggressiveCaching) {
            this.ensureExactCacheHitsOnPath(mainReachedSet, pPath, element, newPrecision, pPathElementToReachedElement, neededRemoveCachedSubtreeCalls);
        }
        for (Pair pair : neededRemoveSubtreeCalls) {
            ABMTransferRelation.removeSubtree((ARTReachedSet)pair.getFirst(), (ARTElement)pair.getSecond());
        }
        for (Pair pair : neededRemoveCachedSubtreeCalls) {
            this.removeCachedSubtree((ARTElement)pair.getFirst(), (ARTElement)pair.getSecond(), null);
        }
        if (lastElement == null) {
            ABMTransferRelation.removeSubtree(mainReachedSet, pPathElementToReachedElement.get(element), newPrecision);
        } else {
            this.removeCachedSubtree(lastElement, pPathElementToReachedElement.get(element), newPrecision);
        }
        this.removeSubtreeTimer.stop();
    }

    private void ensureExactCacheHitsOnPath(ARTReachedSet mainReachedSet, Path pPath, ARTElement pElement, Precision newPrecision, Map<ARTElement, ARTElement> pPathElementToReachedElement, Set<Pair<ARTElement, ARTElement>> neededRemoveCachedSubtreeCalls) {
        HashMap<ARTElement, UnmodifiableReachedSet> pathElementToOuterReachedSet = new HashMap<ARTElement, UnmodifiableReachedSet>();
        Pair<Set<ARTElement>, Set<ARTElement>> pair = this.getCallAndReturnNodes(pPath, pathElementToOuterReachedSet, mainReachedSet.asReachedSet(), pPathElementToReachedElement);
        Set callNodes = (Set)pair.getFirst();
        Set returnNodes = (Set)pair.getSecond();
        LinkedList<ARTElement> remainingPathElements = new LinkedList<ARTElement>();
        for (int i = 0; i < pPath.size(); ++i) {
            remainingPathElements.addLast((ARTElement)((Pair)pPath.get(i)).getFirst());
        }
        boolean starting = false;
        while (!remainingPathElements.isEmpty()) {
            ARTElement currentElement = (ARTElement)remainingPathElements.pop();
            if (currentElement.equals(pElement)) {
                starting = true;
            }
            if (!starting || !callNodes.contains(currentElement)) continue;
            ARTElement currentReachedElement = pPathElementToReachedElement.get(currentElement);
            CFANode node = AbstractElements.extractLocation(currentReachedElement);
            Block currentBlock = this.partitioning.getBlockForCallNode(node);
            AbstractElement reducedElement = this.wrappedReducer.getVariableReducedElement(currentReachedElement, currentBlock, node);
            this.removeUnpreciseCacheEntriesOnPath(currentElement, reducedElement, newPrecision, currentBlock, remainingPathElements, pPathElementToReachedElement, callNodes, returnNodes, pathElementToOuterReachedSet, neededRemoveCachedSubtreeCalls);
        }
    }

    private boolean removeUnpreciseCacheEntriesOnPath(ARTElement rootElement, AbstractElement reducedRootElement, Precision newPrecision, Block rootBlock, Deque<ARTElement> remainingPathElements, Map<ARTElement, ARTElement> pPathElementToReachedElement, Set<ARTElement> callNodes, Set<ARTElement> returnNodes, Map<ARTElement, UnmodifiableReachedSet> pathElementToOuterReachedSet, Set<Pair<ARTElement, ARTElement>> neededRemoveCachedSubtreeCalls) {
        UnmodifiableReachedSet outerReachedSet = pathElementToOuterReachedSet.get(rootElement);
        Precision rootPrecision = outerReachedSet.getPrecision(pPathElementToReachedElement.get(rootElement));
        Precision reducedNewPrecision = this.wrappedReducer.getVariableReducedPrecision(Precisions.replaceByType(rootPrecision, newPrecision, newPrecision.getClass()), rootBlock);
        UnmodifiableReachedSet innerReachedSet = this.abstractElementToReachedSet.get(pPathElementToReachedElement.get(rootElement));
        Precision usedPrecision = innerReachedSet.getPrecision(innerReachedSet.getFirstElement());
        if (!this.artCache.containsPreciseKey(reducedRootElement, reducedNewPrecision, rootBlock)) {
            ReachedSet reachedSet = this.createInitialReachedSet(reducedRootElement, reducedNewPrecision);
            this.artCache.put(reducedRootElement, reducedNewPrecision, rootBlock, reachedSet);
        }
        boolean isNewPrecisionEntry = usedPrecision.equals(reducedNewPrecision);
        boolean foundInnerUnpreciseEntries = false;
        while (!remainingPathElements.isEmpty()) {
            CFANode node;
            Block currentBlock;
            ARTElement currentReachedElement;
            AbstractElement reducedElement;
            boolean removedUnpreciseInnerBlock;
            ARTElement currentElement = remainingPathElements.pop();
            if (callNodes.contains(currentElement) && (removedUnpreciseInnerBlock = this.removeUnpreciseCacheEntriesOnPath(currentElement, reducedElement = this.wrappedReducer.getVariableReducedElement(currentReachedElement = pPathElementToReachedElement.get(currentElement), currentBlock = this.partitioning.getBlockForCallNode(node = AbstractElements.extractLocation(currentReachedElement)), node), newPrecision, currentBlock, remainingPathElements, pPathElementToReachedElement, callNodes, returnNodes, pathElementToOuterReachedSet, neededRemoveCachedSubtreeCalls)) && isNewPrecisionEntry && !foundInnerUnpreciseEntries) {
                neededRemoveCachedSubtreeCalls.add((Pair<ARTElement, ARTElement>)Pair.of((Object)pPathElementToReachedElement.get(rootElement), (Object)currentReachedElement));
                foundInnerUnpreciseEntries = true;
            }
            if (!returnNodes.contains(currentElement)) continue;
            return foundInnerUnpreciseEntries || !isNewPrecisionEntry;
        }
        return foundInnerUnpreciseEntries || !isNewPrecisionEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCachedSubtree(ARTElement rootElement, ARTElement removeElement, Precision newPrecision) {
        this.removeCachedSubtreeTimer.start();
        try {
            CFANode rootNode = AbstractElements.extractLocation(rootElement);
            this.logger.log(Level.FINER, new Object[]{"Remove cached subtree for ", removeElement, " (rootNode: ", rootNode, ") issued"});
            Block rootSubtree = this.partitioning.getBlockForCallNode(rootNode);
            AbstractElement reducedRootElement = this.wrappedReducer.getVariableReducedElement(rootElement, rootSubtree, rootNode);
            ReachedSet reachedSet = this.abstractElementToReachedSet.get(rootElement);
            if (!reachedSet.contains(removeElement)) {
                return;
            }
            Precision removePrecision = reachedSet.getPrecision(removeElement);
            Precision newReducedRemovePrecision = null;
            if (newPrecision != null) {
                newReducedRemovePrecision = this.wrappedReducer.getVariableReducedPrecision(Precisions.replaceByType(removePrecision, newPrecision, newPrecision.getClass()), rootSubtree);
            }
            assert (!removeElement.getParents().isEmpty());
            Precision reducedRootPrecision = reachedSet.getPrecision(reachedSet.getFirstElement());
            this.artCache.removeReturnEntry(reducedRootElement, reducedRootPrecision, rootSubtree);
            this.logger.log(Level.FINEST, new Object[]{"Removing subtree, adding a new cached entry, and removing the former cached entries"});
            if (ABMTransferRelation.removeSubtree(reachedSet, removeElement, newReducedRemovePrecision)) {
                this.artCache.updatePrecisionForEntry(reducedRootElement, reducedRootPrecision, rootSubtree, newReducedRemovePrecision);
            }
        }
        finally {
            this.removeCachedSubtreeTimer.stop();
        }
    }

    private static boolean removeSubtree(ReachedSet reachedSet, ARTElement artElement, Precision newPrecision) {
        ARTReachedSet artReachSet = new ARTReachedSet(reachedSet);
        boolean updateCacheNeeded = artElement.getParents().contains(reachedSet.getFirstElement());
        ABMTransferRelation.removeSubtree(artReachSet, artElement, newPrecision);
        return updateCacheNeeded;
    }

    private static void removeSubtree(ARTReachedSet reachedSet, ARTElement artElement) {
        reachedSet.removeSubtree(artElement);
    }

    private static void removeSubtree(ARTReachedSet reachedSet, ARTElement artElement, Precision newPrecision) {
        if (newPrecision == null) {
            ABMTransferRelation.removeSubtree(reachedSet, artElement);
        } else {
            reachedSet.removeSubtree(artElement, newPrecision);
        }
    }

    private List<ARTElement> trimPath(Path pPath, ARTElement pElement) {
        ArrayList<ARTElement> result = new ArrayList<ARTElement>();
        for (Pair e : pPath) {
            result.add((ARTElement)e.getFirst());
            if (!((ARTElement)e.getFirst()).equals(pElement)) continue;
            return result;
        }
        throw new IllegalArgumentException("Element " + pElement + " could not be found in path " + pPath + ".");
    }

    private Set<ARTElement> getRelevantDefinitionNodes(List<ARTElement> path) {
        ArrayDeque<ARTElement> openCallElements = new ArrayDeque<ARTElement>();
        ArrayDeque<Block> openSubtrees = new ArrayDeque<Block>();
        ARTElement prevElement = path.get(1);
        for (ARTElement currentElement : Iterables.skip(path, (int)2)) {
            CFANode currNode = AbstractElements.extractLocation(currentElement);
            CFANode prevNode = AbstractElements.extractLocation(prevElement);
            if (this.partitioning.isCallNode(prevNode) && !this.partitioning.getBlockForCallNode(prevNode).equals(openSubtrees.peek()) && !this.isHeadOfMainFunction(prevNode)) {
                openCallElements.push(prevElement);
                openSubtrees.push(this.partitioning.getBlockForCallNode(prevNode));
            }
            while (!openSubtrees.isEmpty() && ((Block)openSubtrees.peek()).isReturnNode(prevNode) && !((Block)openSubtrees.peek()).getNodes().contains(currNode)) {
                openCallElements.pop();
                openSubtrees.pop();
            }
            prevElement = currentElement;
        }
        ARTElement lastElement = path.get(path.size() - 1);
        if (this.partitioning.isCallNode(AbstractElements.extractLocation(lastElement))) {
            openCallElements.push(lastElement);
        }
        return new HashSet<ARTElement>(openCallElements);
    }

    private Pair<Set<ARTElement>, Set<ARTElement>> getCallAndReturnNodes(Path path, Map<ARTElement, UnmodifiableReachedSet> pathElementToOuterReachedSet, UnmodifiableReachedSet mainReachedSet, Map<ARTElement, ARTElement> pPathElementToReachedElement) {
        HashSet<ARTElement> callNodes = new HashSet<ARTElement>();
        HashSet<ARTElement> returnNodes = new HashSet<ARTElement>();
        ArrayDeque<Block> openSubtrees = new ArrayDeque<Block>();
        ArrayDeque<UnmodifiableReachedSet> openReachedSets = new ArrayDeque<UnmodifiableReachedSet>();
        openReachedSets.push(mainReachedSet);
        ARTElement prevElement = (ARTElement)((Pair)path.get(1)).getFirst();
        for (Pair currentElementPair : Iterables.skip((Iterable)path, (int)2)) {
            ARTElement currentElement = (ARTElement)currentElementPair.getFirst();
            CFANode currNode = AbstractElements.extractLocation(currentElement);
            CFANode prevNode = AbstractElements.extractLocation(prevElement);
            pathElementToOuterReachedSet.put(prevElement, (UnmodifiableReachedSet)openReachedSets.peek());
            if (this.partitioning.isCallNode(prevNode) && !this.partitioning.getBlockForCallNode(prevNode).equals(openSubtrees.peek()) && !this.isHeadOfMainFunction(prevNode)) {
                openSubtrees.push(this.partitioning.getBlockForCallNode(prevNode));
                openReachedSets.push(this.abstractElementToReachedSet.get(pPathElementToReachedElement.get(prevElement)));
                callNodes.add(prevElement);
            }
            while (!openSubtrees.isEmpty() && ((Block)openSubtrees.peek()).isReturnNode(prevNode) && !((Block)openSubtrees.peek()).getNodes().contains(currNode)) {
                openSubtrees.pop();
                openReachedSets.pop();
                returnNodes.add(prevElement);
            }
            prevElement = currentElement;
        }
        ARTElement lastElement = (ARTElement)((Pair)path.get(path.size() - 1)).getFirst();
        if (this.partitioning.isReturnNode(AbstractElements.extractLocation(lastElement))) {
            returnNodes.add(lastElement);
        }
        pathElementToOuterReachedSet.put(lastElement, (UnmodifiableReachedSet)openReachedSets.peek());
        return Pair.of(callNodes, returnNodes);
    }

    ARTElement computeCounterexampleSubgraph(ARTElement target, ARTReachedSet reachedSet, ARTElement newTreeTarget, Map<ARTElement, ARTElement> pPathElementToReachedElement) throws InterruptedException, RecursiveAnalysisFailedException {
        assert (reachedSet.asReachedSet().contains(target));
        HashMap<ARTElement, ARTElement> elementsMap = new HashMap<ARTElement, ARTElement>();
        Stack<ARTElement> openElements = new Stack<ARTElement>();
        ARTElement root = null;
        pPathElementToReachedElement.put(newTreeTarget, target);
        elementsMap.put(target, newTreeTarget);
        openElements.push(target);
        while (!openElements.empty()) {
            ARTElement currentElement = (ARTElement)openElements.pop();
            assert (reachedSet.asReachedSet().contains(currentElement));
            for (ARTElement parent : currentElement.getParents()) {
                CFAEdge edge;
                if (!elementsMap.containsKey(parent)) {
                    elementsMap.put(parent, new ARTElement(parent.getWrappedElement(), null));
                    pPathElementToReachedElement.put((ARTElement)elementsMap.get(parent), parent);
                    openElements.push(parent);
                }
                if ((edge = ABMARTUtils.getEdgeToChild(parent, currentElement)) == null) {
                    ARTElement innerTree = this.computeCounterexampleSubgraph(parent, reachedSet.asReachedSet().getPrecision(parent), (ARTElement)elementsMap.get(currentElement), pPathElementToReachedElement);
                    if (innerTree == null) {
                        ABMTransferRelation.removeSubtree(reachedSet, parent);
                        return null;
                    }
                    for (ARTElement child : innerTree.getChildren()) {
                        child.addParent((ARTElement)elementsMap.get(parent));
                    }
                    innerTree.removeFromART();
                    continue;
                }
                ((ARTElement)elementsMap.get(currentElement)).addParent((ARTElement)elementsMap.get(parent));
            }
            if (!currentElement.getParents().isEmpty()) continue;
            root = (ARTElement)elementsMap.get(currentElement);
        }
        assert (root != null);
        return root;
    }

    private ARTElement computeCounterexampleSubgraph(ARTElement root, Precision rootPrecision, ARTElement newTreeTarget, Map<ARTElement, ARTElement> pPathElementToReachedElement) throws InterruptedException, RecursiveAnalysisFailedException {
        CFANode rootNode = AbstractElements.extractLocation(root);
        Block rootSubtree = this.partitioning.getBlockForCallNode(rootNode);
        AbstractElement reducedRootElement = this.wrappedReducer.getVariableReducedElement(root, rootSubtree, rootNode);
        ReachedSet reachSet = this.abstractElementToReachedSet.get(root);
        ARTElement targetARTElement = (ARTElement)this.expandedToReducedCache.get(pPathElementToReachedElement.get(newTreeTarget));
        if (targetARTElement.isDestroyed()) {
            this.logger.log(Level.FINE, new Object[]{"Target element refers to a destroyed ARTElement, i.e., the cached subtree is outdated. Updating it."});
            return null;
        }
        assert (reachSet.contains(targetARTElement));
        ARTElement result = this.computeCounterexampleSubgraph(targetARTElement, new ARTReachedSet(reachSet), newTreeTarget, pPathElementToReachedElement);
        if (result == null) {
            this.artCache.removeReturnEntry(reducedRootElement, reachSet.getPrecision(reachSet.getFirstElement()), rootSubtree);
        }
        return result;
    }

    void clearCaches() {
        this.artCache.clear();
        this.abstractElementToReachedSet.clear();
    }

    Pair<Block, ReachedSet> getCachedReachedSet(ARTElement root, Precision rootPrecision) {
        CFANode rootNode = AbstractElements.extractLocation(root);
        Block rootSubtree = this.partitioning.getBlockForCallNode(rootNode);
        ReachedSet reachSet = this.abstractElementToReachedSet.get(root);
        assert (reachSet != null);
        return Pair.of((Object)rootSubtree, (Object)reachSet);
    }

    @Override
    public Collection<? extends AbstractElement> strengthen(AbstractElement pElement, List<AbstractElement> pOtherElements, CFAEdge pCfaEdge, Precision pPrecision) throws CPATransferException, InterruptedException {
        return this.wrappedTransfer.strengthen(pElement, pOtherElements, pCfaEdge, pPrecision);
    }

    private class Cache {
        private final Map<AbstractElementHash, ReachedSet> preciseReachedCache = new HashMap<AbstractElementHash, ReachedSet>();
        private final Map<AbstractElementHash, ReachedSet> unpreciseReachedCache = new HashMap<AbstractElementHash, ReachedSet>();
        private final Map<AbstractElementHash, Collection<AbstractElement>> returnCache = new HashMap<AbstractElementHash, Collection<AbstractElement>>();

        private Cache() {
        }

        private AbstractElementHash getHashCode(AbstractElement predicateKey, Precision precisionKey, Block context) {
            return new AbstractElementHash(predicateKey, precisionKey, context);
        }

        private void put(AbstractElement predicateKey, Precision precisionKey, Block context, ReachedSet item) {
            AbstractElementHash hash = this.getHashCode(predicateKey, precisionKey, context);
            assert (!this.preciseReachedCache.containsKey(hash));
            this.preciseReachedCache.put(hash, item);
        }

        private void put(AbstractElement predicateKey, Precision precisionKey, Block context, Collection<AbstractElement> item) {
            AbstractElementHash hash = this.getHashCode(predicateKey, precisionKey, context);
            assert (this.allElementsContainedInReachedSet(item, this.preciseReachedCache.get(hash)));
            this.returnCache.put(hash, item);
        }

        private boolean allElementsContainedInReachedSet(Collection<AbstractElement> pElements, ReachedSet reached) {
            for (AbstractElement e : pElements) {
                if (reached.contains(e)) continue;
                return false;
            }
            return true;
        }

        private void removeReturnEntry(AbstractElement predicateKey, Precision precisionKey, Block context) {
            this.returnCache.remove(this.getHashCode(predicateKey, precisionKey, context));
        }

        private Pair<ReachedSet, Collection<AbstractElement>> get(AbstractElement predicateKey, Precision precisionKey, Block context) {
            AbstractElementHash hash = this.getHashCode(predicateKey, precisionKey, context);
            ReachedSet result = this.preciseReachedCache.get(hash);
            if (result != null) {
                return Pair.of((Object)result, this.returnCache.get(hash));
            }
            if (ABMTransferRelation.this.aggressiveCaching) {
                result = this.unpreciseReachedCache.get(hash);
                if (result != null) {
                    return Pair.of((Object)result, this.returnCache.get(this.getHashCode(predicateKey, result.getPrecision(result.getFirstElement()), context)));
                }
                Pair<ReachedSet, Collection<AbstractElement>> pair = this.lookForSimilarElement(predicateKey, precisionKey, context);
                if (pair != null) {
                    this.unpreciseReachedCache.put(hash, (ReachedSet)pair.getFirst());
                    return pair;
                }
            }
            return Pair.of(null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Pair<ReachedSet, Collection<AbstractElement>> lookForSimilarElement(AbstractElement pPredicateKey, Precision pPrecisionKey, Block pContext) {
            ABMTransferRelation.this.searchingTimer.start();
            try {
                int min = Integer.MAX_VALUE;
                Pair result = null;
                for (AbstractElementHash cacheKey : this.preciseReachedCache.keySet()) {
                    int distance;
                    AbstractElementHash ignorePrecisionSearchKey = this.getHashCode(pPredicateKey, cacheKey.precisionKey, pContext);
                    if (!ignorePrecisionSearchKey.equals(cacheKey) || (distance = ABMTransferRelation.this.wrappedReducer.measurePrecisionDifference(pPrecisionKey, cacheKey.precisionKey)) >= min) continue;
                    min = distance;
                    result = Pair.of((Object)this.preciseReachedCache.get(ignorePrecisionSearchKey), this.returnCache.get(ignorePrecisionSearchKey));
                }
                Pair pair = result;
                return pair;
            }
            finally {
                ABMTransferRelation.this.searchingTimer.stop();
            }
        }

        private void findCacheMissCause(AbstractElement pPredicateKey, Precision pPrecisionKey, Block pContext) {
            AbstractElementHash searchKey = this.getHashCode(pPredicateKey, pPrecisionKey, pContext);
            for (AbstractElementHash cacheKey : this.preciseReachedCache.keySet()) {
                assert (!searchKey.equals(cacheKey));
                AbstractElementHash ignorePrecisionSearchKey = this.getHashCode(pPredicateKey, cacheKey.precisionKey, pContext);
                if (ignorePrecisionSearchKey.equals(cacheKey)) {
                    ++ABMTransferRelation.this.precisionCausedMisses;
                    return;
                }
                AbstractElementHash ignoreAbsSearchKey = this.getHashCode(cacheKey.predicateKey, pPrecisionKey, pContext);
                if (!ignoreAbsSearchKey.equals(cacheKey)) continue;
                ++ABMTransferRelation.this.abstractionCausedMisses;
                return;
            }
            ++ABMTransferRelation.this.noSimilarCausedMisses;
        }

        private void clear() {
            this.preciseReachedCache.clear();
            this.unpreciseReachedCache.clear();
            this.returnCache.clear();
        }

        private boolean containsPreciseKey(AbstractElement predicateKey, Precision precisionKey, Block context) {
            AbstractElementHash hash = this.getHashCode(predicateKey, precisionKey, context);
            return this.preciseReachedCache.containsKey(hash);
        }

        public void updatePrecisionForEntry(AbstractElement predicateKey, Precision precisionKey, Block context, Precision newPrecisionKey) {
            AbstractElementHash hash = this.getHashCode(predicateKey, precisionKey, context);
            ReachedSet reachedSet = this.preciseReachedCache.get(hash);
            if (reachedSet != null) {
                this.preciseReachedCache.remove(hash);
                this.preciseReachedCache.put(this.getHashCode(predicateKey, newPrecisionKey, context), reachedSet);
            }
        }
    }

    private class AbstractElementHash {
        private final Object wrappedHash;
        private final Block context;
        private final AbstractElement predicateKey;
        private final Precision precisionKey;

        public AbstractElementHash(AbstractElement pPredicateKey, Precision pPrecisionKey, Block pContext) {
            this.wrappedHash = ABMTransferRelation.this.wrappedReducer.getHashCodeForElement(pPredicateKey, pPrecisionKey);
            this.context = (Block)Preconditions.checkNotNull((Object)pContext);
            this.predicateKey = pPredicateKey;
            this.precisionKey = pPrecisionKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object pObj) {
            if (!(pObj instanceof AbstractElementHash)) {
                return false;
            }
            AbstractElementHash other = (AbstractElementHash)pObj;
            ABMTransferRelation.this.equalsTimer.start();
            try {
                boolean bl = this.context.equals(other.context) && this.wrappedHash.equals(other.wrappedHash);
                return bl;
            }
            finally {
                ABMTransferRelation.this.equalsTimer.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            ABMTransferRelation.this.hashingTimer.start();
            try {
                int n = this.wrappedHash.hashCode() * 17 + this.context.hashCode();
                return n;
            }
            finally {
                ABMTransferRelation.this.hashingTimer.stop();
            }
        }

        public String toString() {
            return "AbstractElementHash [hash=" + this.hashCode() + ", wrappedHash=" + this.wrappedHash + ", context=" + this.context + ", predicateKey=" + this.predicateKey + ", precisionKey=" + this.precisionKey + "]";
        }
    }
}

