/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.abm;

import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Timer;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.core.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.abm.ABMCPA;
import org.sosy_lab.cpachecker.cpa.abm.ABMTransferRelation;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.cpa.art.ARTReachedSet;
import org.sosy_lab.cpachecker.cpa.art.AbstractARTBasedRefiner;
import org.sosy_lab.cpachecker.cpa.art.Path;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractElements;

public abstract class AbstractABMBasedRefiner
extends AbstractARTBasedRefiner {
    final Timer computePathTimer = new Timer();
    final Timer computeSubtreeTimer = new Timer();
    final Timer computeCounterexampleTimer = new Timer();
    private final ABMTransferRelation transfer;
    private final Map<ARTElement, ARTElement> pathElementToReachedElement = new HashMap<ARTElement, ARTElement>();

    protected AbstractABMBasedRefiner(ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        super(pCpa);
        ABMCPA abmCpa = (ABMCPA)pCpa;
        this.transfer = abmCpa.getTransferRelation();
        abmCpa.getStatistics().addRefiner(this);
    }

    protected abstract CounterexampleInfo performRefinement0(ARTReachedSet var1, Path var2) throws CPAException, InterruptedException;

    @Override
    protected final CounterexampleInfo performRefinement(ARTReachedSet pReached, Path pPath) throws CPAException, InterruptedException {
        if (pPath == null) {
            return CounterexampleInfo.spurious();
        }
        return this.performRefinement0(new ABMReachedSet(this.transfer, pReached, pPath, this.pathElementToReachedElement), pPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final Path computePath(ARTElement pLastElement, ARTReachedSet pReachedSet) throws InterruptedException, CPATransferException {
        assert (pLastElement.isTarget());
        this.pathElementToReachedElement.clear();
        this.computePathTimer.start();
        try {
            Path path;
            ARTElement subgraph;
            this.computeSubtreeTimer.start();
            try {
                subgraph = this.transfer.computeCounterexampleSubgraph(pLastElement, pReachedSet, new ARTElement(pLastElement.getWrappedElement(), null), this.pathElementToReachedElement);
                if (subgraph == null) {
                    Path path2 = null;
                    return path2;
                }
            }
            finally {
                this.computeSubtreeTimer.stop();
            }
            this.computeCounterexampleTimer.start();
            try {
                path = this.computeCounterexample(subgraph);
            }
            catch (Throwable throwable) {
                this.computeCounterexampleTimer.stop();
                throw throwable;
            }
            this.computeCounterexampleTimer.stop();
            return path;
        }
        finally {
            this.computePathTimer.stop();
        }
    }

    private Path computeCounterexample(ARTElement root) {
        Path path = new Path();
        ARTElement currentElement = root;
        while (currentElement.getChildren().size() > 0) {
            ARTElement child = currentElement.getChildren().iterator().next();
            CFAEdge edge = currentElement.getEdgeToChild(child);
            path.add(Pair.of((Object)currentElement, (Object)edge));
            currentElement = child;
        }
        path.add(Pair.of((Object)currentElement, (Object)AbstractElements.extractLocation(currentElement).getLeavingEdge(0)));
        return path;
    }

    private static class ABMReachedSet
    extends ARTReachedSet.ForwardingARTReachedSet {
        private final ABMTransferRelation transfer;
        private final Path path;
        private final Map<ARTElement, ARTElement> pathElementToReachedElement;

        private ABMReachedSet(ABMTransferRelation pTransfer, ARTReachedSet pReached, Path pPath, Map<ARTElement, ARTElement> pPathElementToReachedElement) {
            super(pReached);
            this.transfer = pTransfer;
            this.path = pPath;
            this.pathElementToReachedElement = pPathElementToReachedElement;
        }

        @Override
        public void removeSubtree(ARTElement element, Precision newPrecision) {
            this.transfer.removeSubtree(this.delegate, this.path, element, newPrecision, this.pathElementToReachedElement);
        }

        @Override
        public void removeSubtree(ARTElement pE) {
            throw new UnsupportedOperationException();
        }
    }
}

