/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.abm;

import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

class RecursiveAnalysisFailedException
extends CPATransferException {
    private static final long serialVersionUID = 3822584071233172171L;
    private int depth;

    public RecursiveAnalysisFailedException(CPAException e) {
        super(RecursiveAnalysisFailedException.createMessage(e));
        if (e instanceof RecursiveAnalysisFailedException) {
            RecursiveAnalysisFailedException recursiveException = (RecursiveAnalysisFailedException)e;
            this.initCause(recursiveException.getCause());
            this.depth = recursiveException.depth + 1;
        } else {
            this.initCause(e);
            this.depth = 1;
        }
    }

    private static String createMessage(CPAException e) {
        if (e instanceof RecursiveAnalysisFailedException) {
            RecursiveAnalysisFailedException r = (RecursiveAnalysisFailedException)e;
            return "Error in recursive analysis at depth " + r.depth + ": " + r.getCause().getMessage();
        }
        return "Error in recursive analysis at depth 1: " + e.getMessage();
    }

    @Override
    public CPAException getCause() {
        return (CPAException)super.getCause();
    }
}

