/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.andersen;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.cpa.andersen.util.BaseConstraint;
import org.sosy_lab.cpachecker.cpa.andersen.util.ComplexConstraint;
import org.sosy_lab.cpachecker.cpa.andersen.util.DirectedGraph;
import org.sosy_lab.cpachecker.cpa.andersen.util.SimpleConstraint;

public class AndersenElement
implements AbstractElement,
Cloneable {
    private static final Set<BaseConstraint> gBaseConstraints = new HashSet<BaseConstraint>();
    private static final Set<SimpleConstraint> gSimpleConstraints = new HashSet<SimpleConstraint>();
    private static final Set<ComplexConstraint> gComplexConstraints = new HashSet<ComplexConstraint>();
    private static final Map<String, String[]> gPointsToSets = new HashMap<String, String[]>();
    private static boolean gChanged = false;
    private final Set<BaseConstraint> lBaseConstraints = new HashSet<BaseConstraint>();
    private final Set<SimpleConstraint> lSimpleConstraints = new HashSet<SimpleConstraint>();
    private final Set<ComplexConstraint> lComplexConstraints = new HashSet<ComplexConstraint>();
    private final Map<String, String[]> lPointsToSets = new HashMap<String, String[]>();
    private boolean lChanged = false;

    void addConstraint(BaseConstraint constr) {
        this.lChanged |= this.lBaseConstraints.add(constr);
        gChanged |= gBaseConstraints.add(constr);
    }

    void addConstraint(SimpleConstraint constr) {
        this.lChanged |= this.lSimpleConstraints.add(constr);
        gChanged |= gSimpleConstraints.add(constr);
    }

    void addConstraint(ComplexConstraint constr) {
        this.lChanged |= this.lComplexConstraints.add(constr);
        gChanged |= gComplexConstraints.add(constr);
    }

    public Map<String, String[]> getLocalPointsToSets() {
        if (this.lChanged) {
            AndersenElement.computeDynTransitiveClosure(this.lBaseConstraints, this.lSimpleConstraints, this.lComplexConstraints, this.lPointsToSets);
            this.lChanged = false;
        }
        return this.lPointsToSets;
    }

    public static Map<String, String[]> getGlobalPointsToSets() {
        if (gChanged) {
            AndersenElement.computeDynTransitiveClosure(gBaseConstraints, gSimpleConstraints, gComplexConstraints, gPointsToSets);
            gChanged = false;
        }
        return gPointsToSets;
    }

    private static void computeDynTransitiveClosure(Set<BaseConstraint> bConstr, Set<SimpleConstraint> sConstr, Set<ComplexConstraint> cConstr, Map<String, String[]> ptSets) {
        DirectedGraph g = new DirectedGraph();
        AndersenElement.buildGraph(bConstr, sConstr, cConstr, g);
        HashSet<DirectedGraph.Node> workset = new HashSet<DirectedGraph.Node>();
        for (Map.Entry<String, DirectedGraph.Node> entry : g.getNameMappings()) {
            workset.add(entry.getValue());
        }
        HashSet<DirectedGraph.Edge> tested = new HashSet<DirectedGraph.Edge>();
        block1: while (!workset.isEmpty()) {
            DirectedGraph.Node n = (DirectedGraph.Node)workset.iterator().next();
            workset.remove(n);
            if (!n.isValid()) continue;
            if (n.mergePts != null) {
                g.mergeNodes(n.mergePts, n.getPointsToNodesSet());
            }
            for (DirectedGraph.Node v : n.getPointsToNodesSet()) {
                for (String aStr : n.complexConstrMeSub) {
                    DirectedGraph.Node a = g.getNode(aStr);
                    if (v.isSuccessor(a)) continue;
                    g.addEdge(v, a);
                    workset.add(v);
                }
                for (String bStr : n.complexConstrMeSuper) {
                    DirectedGraph.Node b = g.getNode(bStr);
                    if (b.isSuccessor(v)) continue;
                    g.addEdge(b, v);
                    workset.add(b);
                }
            }
            for (DirectedGraph.Node z : n.getSuccessors()) {
                DirectedGraph directedGraph = g;
                directedGraph.getClass();
                DirectedGraph.Edge edge = new DirectedGraph.Edge(directedGraph, n, z);
                if (((Object)z.getPointsToSet()).equals(n.getPointsToSet()) && !tested.contains(edge)) {
                    tested.add(edge);
                    DirectedGraph.Node merged = g.detectAndCollapseCycleContainingEdge(edge);
                    if (merged == null) continue;
                    workset.add(merged);
                    continue block1;
                }
                if (!n.propagatePointerTargetsTo(z)) continue;
                workset.add(z);
            }
        }
        ptSets.clear();
        for (Map.Entry<String, DirectedGraph.Node> e : g.getNameMappings()) {
            Collection<String> ptSetNode = e.getValue().getPointsToSet();
            ptSets.put(e.getKey(), ptSetNode.toArray(new String[ptSetNode.size()]));
        }
    }

    private static void buildGraph(Set<BaseConstraint> bConstr, Set<SimpleConstraint> sConstr, Set<ComplexConstraint> cConstr, DirectedGraph g) {
        DirectedGraph.Node n;
        List<List<String>> sccs = AndersenElement.buildOfflineGraphAndFindSCCs(sConstr, cConstr);
        for (BaseConstraint bc : bConstr) {
            n = g.getNode(bc.getSuperVar());
            n.addPointerTarget(bc.getSubVar());
        }
        for (SimpleConstraint sc : sConstr) {
            DirectedGraph.Node src = g.getNode(sc.getSubVar());
            DirectedGraph.Node dest = g.getNode(sc.getSuperVar());
            g.addEdge(src, dest);
        }
        for (ComplexConstraint cc : cConstr) {
            if (cc.isSubDerefed()) {
                n = g.getNode(cc.getSubVar());
                n.complexConstrMeSub.add(cc.getSuperVar());
                continue;
            }
            n = g.getNode(cc.getSuperVar());
            n.complexConstrMeSuper.add(cc.getSubVar());
        }
        AndersenElement.mergeOrMarkSCCs(g, sccs);
    }

    private static List<List<String>> buildOfflineGraphAndFindSCCs(Collection<SimpleConstraint> sConstr, Collection<ComplexConstraint> cConstr) {
        DirectedGraph.Node dest;
        DirectedGraph.Node src;
        String destStr;
        String srcStr;
        HashSet<DirectedGraph.Node> workset = new HashSet<DirectedGraph.Node>();
        DirectedGraph g = new DirectedGraph();
        HashMap<DirectedGraph.Node, String> nodeStrMap = new HashMap<DirectedGraph.Node, String>();
        for (SimpleConstraint sc : sConstr) {
            srcStr = sc.getSubVar();
            destStr = sc.getSuperVar();
            src = g.getNode(srcStr);
            dest = g.getNode(destStr);
            g.addEdge(src, dest);
            workset.add(src);
            workset.add(dest);
            nodeStrMap.put(src, srcStr);
            nodeStrMap.put(dest, destStr);
        }
        for (ComplexConstraint cc : cConstr) {
            if (cc.isSubDerefed()) {
                srcStr = '*' + cc.getSubVar();
                destStr = cc.getSuperVar();
            } else {
                srcStr = cc.getSubVar();
                destStr = '*' + cc.getSuperVar();
            }
            src = g.getNode(srcStr);
            dest = g.getNode(destStr);
            g.addEdge(src, dest);
            workset.add(src);
            workset.add(dest);
            nodeStrMap.put(src, srcStr);
            nodeStrMap.put(dest, destStr);
        }
        int maxdfs = 1;
        LinkedList<DirectedGraph.Node> stack = new LinkedList<DirectedGraph.Node>();
        LinkedList<List<String>> sccs = new LinkedList<List<String>>();
        while (!workset.isEmpty()) {
            DirectedGraph.Node n = (DirectedGraph.Node)workset.iterator().next();
            maxdfs = AndersenElement.tarjan(maxdfs, n, workset, stack, nodeStrMap, sccs);
        }
        return sccs;
    }

    private static int tarjan(int maxdfs, DirectedGraph.Node v, Set<DirectedGraph.Node> workset, LinkedList<DirectedGraph.Node> stack, Map<DirectedGraph.Node, String> nodeStrMap, List<List<String>> sccs) {
        v.dfs = maxdfs;
        v.lowlink = maxdfs++;
        stack.push(v);
        workset.remove(v);
        for (DirectedGraph.Node succ : v.getSuccessors()) {
            if (workset.contains(succ)) {
                maxdfs = AndersenElement.tarjan(maxdfs, succ, workset, stack, nodeStrMap, sccs);
                v.lowlink = Math.min(v.lowlink, succ.lowlink);
                continue;
            }
            if (succ.dfs <= 0) continue;
            v.lowlink = Math.min(v.lowlink, succ.dfs);
        }
        if (v.lowlink == v.dfs) {
            DirectedGraph.Node succ;
            LinkedList<String> scc = new LinkedList<String>();
            do {
                succ = stack.pop();
                succ.dfs = -succ.dfs;
                scc.add(nodeStrMap.get(succ));
            } while (!succ.equals(v));
            if (scc.size() > 1) {
                sccs.add(scc);
            }
        }
        return maxdfs;
    }

    private static void mergeOrMarkSCCs(DirectedGraph g, List<List<String>> sccs) {
        for (List<String> scc : sccs) {
            LinkedList<DirectedGraph.Node> refNodes = new LinkedList<DirectedGraph.Node>();
            LinkedList<DirectedGraph.Node> normNodes = new LinkedList<DirectedGraph.Node>();
            for (String n : scc) {
                if (n.charAt(0) == '*') {
                    refNodes.add(g.getNode(n.substring(1)));
                    continue;
                }
                normNodes.add(g.getNode(n));
            }
            DirectedGraph.Node merged = g.mergeNodes((DirectedGraph.Node)normNodes.poll(), normNodes);
            for (DirectedGraph.Node n : refNodes) {
                n.mergePts = merged;
            }
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        AndersenElement oEl = (AndersenElement)other;
        return ((Object)this.lBaseConstraints).equals(oEl.lBaseConstraints) && ((Object)this.lSimpleConstraints).equals(oEl.lSimpleConstraints) && ((Object)this.lComplexConstraints).equals(oEl.lComplexConstraints);
    }

    public AndersenElement clone() {
        AndersenElement clone = new AndersenElement();
        clone.lBaseConstraints.addAll(this.lBaseConstraints);
        clone.lSimpleConstraints.addAll(this.lSimpleConstraints);
        clone.lComplexConstraints.addAll(this.lComplexConstraints);
        clone.lPointsToSets.putAll(this.lPointsToSets);
        clone.lChanged = this.lChanged;
        return clone;
    }

    public int hashCode() {
        int hash = 51;
        hash = 31 * hash + ((Object)this.lBaseConstraints).hashCode();
        hash = 31 * hash + ((Object)this.lSimpleConstraints).hashCode();
        hash = 31 * hash + ((Object)this.lComplexConstraints).hashCode();
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append('\n');
        for (BaseConstraint baseConstraint : this.lBaseConstraints) {
            sb.append('{').append(baseConstraint.getSubVar()).append("} \u2286 ");
            sb.append(baseConstraint.getSuperVar()).append('\n');
        }
        for (SimpleConstraint simpleConstraint : this.lSimpleConstraints) {
            sb.append(simpleConstraint.getSubVar()).append(" \u2286 ");
            sb.append(simpleConstraint.getSuperVar()).append('\n');
        }
        for (ComplexConstraint complexConstraint : this.lComplexConstraints) {
            sb.append(complexConstraint.getSubVar()).append(" \u2286 ");
            sb.append(complexConstraint.getSuperVar()).append('\n');
        }
        int size = this.lBaseConstraints.size() + this.lSimpleConstraints.size() + this.lComplexConstraints.size();
        sb.append("] size->  ").append(size);
        sb.append('\n');
        sb.append('[').append('\n');
        Map<String, String[]> map = this.getLocalPointsToSets();
        for (String key : map.keySet()) {
            String[] vals;
            sb.append(key).append(" -> {");
            for (String val : vals = map.get(key)) {
                sb.append(val).append(',');
            }
            if (vals.length > 0) {
                sb.setLength(sb.length() - 1);
            }
            sb.append('}').append('\n');
        }
        sb.append(']').append('\n');
        return sb.toString();
    }
}

