/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.andersen;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.ast.IASTAssignment;
import org.sosy_lab.cpachecker.cfa.ast.IASTCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTInitializer;
import org.sosy_lab.cpachecker.cfa.ast.IASTInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.IASTStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.DeclarationEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.StatementEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.andersen.AndersenElement;
import org.sosy_lab.cpachecker.cpa.andersen.util.BaseConstraint;
import org.sosy_lab.cpachecker.cpa.andersen.util.ComplexConstraint;
import org.sosy_lab.cpachecker.cpa.andersen.util.SimpleConstraint;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;

@Options(prefix="cpa.pointerA")
public class AndersenTransferRelation
implements TransferRelation {
    public AndersenTransferRelation(Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
    }

    public Collection<AbstractElement> getAbstractSuccessors(AbstractElement element, Precision pPrecision, CFAEdge cfaEdge) throws CPATransferException {
        AndersenElement successor = null;
        AndersenElement andersenElement = (AndersenElement)element;
        switch (cfaEdge.getEdgeType()) {
            case StatementEdge: {
                StatementEdge statementEdge = (StatementEdge)cfaEdge;
                successor = this.handleStatement(andersenElement, statementEdge.getStatement(), cfaEdge);
                break;
            }
            case DeclarationEdge: {
                DeclarationEdge declarationEdge = (DeclarationEdge)cfaEdge;
                successor = this.handleDeclaration(andersenElement, declarationEdge);
                break;
            }
            case AssumeEdge: {
                successor = andersenElement.clone();
                break;
            }
            case BlankEdge: {
                successor = andersenElement.clone();
                break;
            }
            default: {
                this.printWarning(cfaEdge);
            }
        }
        if (successor == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(successor);
    }

    @Override
    public Collection<? extends AbstractElement> strengthen(AbstractElement element, List<AbstractElement> elements, CFAEdge cfaEdge, Precision precision) throws UnrecognizedCCodeException {
        return null;
    }

    private AndersenElement handleStatement(AndersenElement element, IASTStatement expression, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        if (expression instanceof IASTAssignment) {
            return this.handleAssignment(element, (IASTAssignment)((Object)expression), cfaEdge);
        }
        if (expression instanceof IASTFunctionCallStatement) {
            return element.clone();
        }
        if (expression instanceof IASTExpressionStatement) {
            return element.clone();
        }
        throw new UnrecognizedCCodeException(cfaEdge, expression);
    }

    private AndersenElement handleAssignment(AndersenElement element, IASTAssignment assignExpression, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        IASTExpression op1 = assignExpression.getLeftHandSide();
        IASTRightHandSide op2 = assignExpression.getRightHandSide();
        if (op1 instanceof IASTIdExpression) {
            return this.handleAssignmentTo(op1.toASTString(), op2, element, cfaEdge);
        }
        if (op1 instanceof IASTUnaryExpression && ((IASTUnaryExpression)op1).getOperator() == IASTUnaryExpression.UnaryOperator.STAR && op2 instanceof IASTIdExpression) {
            if ((op1 = ((IASTUnaryExpression)op1).getOperand()) instanceof IASTIdExpression) {
                AndersenElement succ = element.clone();
                succ.addConstraint(new ComplexConstraint(op2.toASTString(), op1.toASTString(), false));
                return succ;
            }
            throw new UnrecognizedCCodeException("not supported", cfaEdge, op2);
        }
        throw new UnrecognizedCCodeException("not supported", cfaEdge, op1);
    }

    private AndersenElement handleAssignmentTo(String op1, IASTRightHandSide op2, AndersenElement element, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        while (op2 instanceof IASTCastExpression) {
            op2 = ((IASTCastExpression)op2).getOperand();
        }
        if (op2 instanceof IASTIdExpression) {
            AndersenElement succ = element.clone();
            succ.addConstraint(new SimpleConstraint(op2.toASTString(), op1));
            return succ;
        }
        if (op2 instanceof IASTUnaryExpression && ((IASTUnaryExpression)op2).getOperator() == IASTUnaryExpression.UnaryOperator.AMPER) {
            if ((op2 = ((IASTUnaryExpression)op2).getOperand()) instanceof IASTIdExpression) {
                AndersenElement succ = element.clone();
                succ.addConstraint(new BaseConstraint(op2.toASTString(), op1));
                return succ;
            }
            throw new UnrecognizedCCodeException("not supported", cfaEdge, op2);
        }
        if (op2 instanceof IASTUnaryExpression && ((IASTUnaryExpression)op2).getOperator() == IASTUnaryExpression.UnaryOperator.STAR) {
            if ((op2 = ((IASTUnaryExpression)op2).getOperand()) instanceof IASTIdExpression) {
                AndersenElement succ = element.clone();
                succ.addConstraint(new ComplexConstraint(op2.toASTString(), op1, true));
                return succ;
            }
            throw new UnrecognizedCCodeException("not supported", cfaEdge, op2);
        }
        if (op2 instanceof IASTFunctionCallExpression && "malloc".equals(((IASTFunctionCallExpression)op2).getFunctionNameExpression().toASTString())) {
            AndersenElement succ = element.clone();
            succ.addConstraint(new BaseConstraint("malloc-" + cfaEdge.getLineNumber(), op1));
            return succ;
        }
        this.printWarning(cfaEdge);
        return element.clone();
    }

    private AndersenElement handleDeclaration(AndersenElement element, DeclarationEdge declarationEdge) throws UnrecognizedCCodeException {
        if (!(declarationEdge.getDeclaration() instanceof IASTVariableDeclaration)) {
            return element.clone();
        }
        IASTVariableDeclaration decl = (IASTVariableDeclaration)declarationEdge.getDeclaration();
        String varName = decl.getName();
        IASTInitializer init = decl.getInitializer();
        if (init instanceof IASTInitializerExpression) {
            IASTExpression exp = ((IASTInitializerExpression)init).getExpression();
            return this.handleAssignmentTo(varName, exp, element, declarationEdge);
        }
        return element.clone();
    }

    private void printWarning(CFAEdge cfaEdge) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        System.err.println("Warning! CFA Edge \"" + cfaEdge.getRawStatement() + "\" (line: " + cfaEdge.getLineNumber() + ") not handled. [Method: " + trace[2].toString() + ']');
    }
}

