/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.art;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.FlatLatticeDomain;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.SimplePrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithABM;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.ProofChecker;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.cpa.art.ARTMergeJoin;
import org.sosy_lab.cpachecker.cpa.art.ARTPrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.art.ARTReducer;
import org.sosy_lab.cpachecker.cpa.art.ARTSimplePrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.art.ARTStatistics;
import org.sosy_lab.cpachecker.cpa.art.ARTStopSep;
import org.sosy_lab.cpachecker.cpa.art.ARTTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

public class ARTCPA
extends AbstractSingleWrapperCPA
implements ConfigurableProgramAnalysisWithABM,
ProofChecker {
    private final LogManager logger;
    private final AbstractDomain abstractDomain;
    private final ARTTransferRelation transferRelation;
    private final MergeOperator mergeOperator;
    private final ARTStopSep stopOperator;
    private final PrecisionAdjustment precisionAdjustment;
    private final Reducer reducer;
    private final Statistics stats;
    private final ProofChecker wrappedProofChecker;
    private CounterexampleInfo lastCounterexample = null;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(ARTCPA.class);
    }

    private ARTCPA(ConfigurableProgramAnalysis cpa, Configuration config, LogManager logger) throws InvalidConfigurationException {
        super(cpa);
        Reducer wrappedReducer;
        this.logger = logger;
        this.abstractDomain = new FlatLatticeDomain();
        this.transferRelation = new ARTTransferRelation(cpa.getTransferRelation());
        PrecisionAdjustment wrappedPrec = cpa.getPrecisionAdjustment();
        this.precisionAdjustment = wrappedPrec instanceof SimplePrecisionAdjustment ? new ARTSimplePrecisionAdjustment((SimplePrecisionAdjustment)wrappedPrec) : new ARTPrecisionAdjustment(cpa.getPrecisionAdjustment());
        this.reducer = cpa instanceof ConfigurableProgramAnalysisWithABM ? ((wrappedReducer = ((ConfigurableProgramAnalysisWithABM)cpa).getReducer()) != null ? new ARTReducer(wrappedReducer) : null) : null;
        this.wrappedProofChecker = cpa instanceof ProofChecker ? (ProofChecker)((Object)cpa) : null;
        MergeOperator wrappedMerge = this.getWrappedCpa().getMergeOperator();
        this.mergeOperator = wrappedMerge == MergeSepOperator.getInstance() ? MergeSepOperator.getInstance() : new ARTMergeJoin(wrappedMerge);
        this.stopOperator = new ARTStopSep(this.getWrappedCpa().getStopOperator(), logger, config);
        this.stats = new ARTStatistics(config, this);
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.abstractDomain;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.precisionAdjustment;
    }

    @Override
    public Reducer getReducer() {
        return this.reducer;
    }

    @Override
    public AbstractElement getInitialElement(CFANode pNode) {
        return new ARTElement(this.getWrappedCpa().getInitialElement(pNode), null);
    }

    protected LogManager getLogger() {
        return this.logger;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
        super.collectStatistics(pStatsCollection);
    }

    public CounterexampleInfo getLastCounterexample() {
        return this.lastCounterexample;
    }

    public void clearCounterexample() {
        this.lastCounterexample = null;
    }

    public void setCounterexample(CounterexampleInfo pCounterexample) {
        Preconditions.checkArgument((!pCounterexample.isSpurious() ? 1 : 0) != 0);
        this.lastCounterexample = pCounterexample;
    }

    @Override
    public boolean areAbstractSuccessors(AbstractElement pElement, CFAEdge pCfaEdge, Collection<? extends AbstractElement> pSuccessors) throws CPATransferException, InterruptedException {
        Preconditions.checkNotNull((Object)this.wrappedProofChecker, (Object)"Wrapped CPA has to implement ProofChecker interface");
        return this.transferRelation.areAbstractSuccessors(pElement, pCfaEdge, pSuccessors, this.wrappedProofChecker);
    }

    @Override
    public boolean isCoveredBy(AbstractElement pElement, AbstractElement pOtherElement) throws CPAException {
        Preconditions.checkNotNull((Object)this.wrappedProofChecker, (Object)"Wrapped CPA has to implement ProofChecker interface");
        return this.stopOperator.isCoveredBy(pElement, pOtherElement, this.wrappedProofChecker);
    }
}

