/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.art;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperElement;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.util.AbstractElements;

public class ARTElement
extends AbstractSingleWrapperElement
implements Comparable<ARTElement> {
    private static final long serialVersionUID = 2608287648397165040L;
    private final Set<ARTElement> children;
    private final Set<ARTElement> parents;
    private ARTElement mCoveredBy = null;
    private Set<ARTElement> mCoveredByThis = null;
    private boolean wasExpanded = false;
    private boolean mayCover = true;
    private boolean destroyed = false;
    private ARTElement mergedWith = null;
    private final int elementId = ++nextArtElementId;
    private static int nextArtElementId = 0;

    public ARTElement(AbstractElement pWrappedElement, ARTElement pParentElement) {
        super(pWrappedElement);
        this.parents = new LinkedHashSet<ARTElement>();
        if (pParentElement != null) {
            this.addParent(pParentElement);
        }
        this.children = new LinkedHashSet<ARTElement>();
    }

    public Set<ARTElement> getParents() {
        return this.parents;
    }

    public void addParent(ARTElement pOtherParent) {
        assert (!this.destroyed) : "Don't use destroyed ARTElements!";
        if (this.parents.add(pOtherParent)) {
            pOtherParent.children.add(this);
        }
    }

    public Set<ARTElement> getChildren() {
        assert (!this.destroyed) : "Don't use destroyed ARTElements!";
        return this.children;
    }

    public void setCovered(ARTElement pCoveredBy) {
        assert (!this.isCovered());
        assert (pCoveredBy != null);
        assert (pCoveredBy.mayCover);
        this.mCoveredBy = pCoveredBy;
        if (pCoveredBy.mCoveredByThis == null) {
            pCoveredBy.mCoveredByThis = new HashSet<ARTElement>(2);
        }
        pCoveredBy.mCoveredByThis.add(this);
    }

    public void uncover() {
        assert (this.isCovered());
        assert (this.mCoveredBy.mCoveredByThis.contains(this));
        this.mCoveredBy.mCoveredByThis.remove(this);
        this.mCoveredBy = null;
    }

    public boolean isCovered() {
        assert (!this.destroyed) : "Don't use destroyed ARTElements!";
        return this.mCoveredBy != null;
    }

    public ARTElement getCoveringElement() {
        Preconditions.checkState((boolean)this.isCovered());
        return this.mCoveredBy;
    }

    public Set<ARTElement> getCoveredByThis() {
        assert (!this.destroyed) : "Don't use destroyed ARTElements!";
        if (this.mCoveredByThis == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.mCoveredByThis);
    }

    protected void setMergedWith(ARTElement pMergedWith) {
        assert (!this.destroyed) : "Don't use destroyed ARTElements!";
        assert (this.mergedWith == null);
        this.mergedWith = pMergedWith;
    }

    protected ARTElement getMergedWith() {
        return this.mergedWith;
    }

    public boolean mayCover() {
        return this.mayCover && !this.isCovered();
    }

    public void setNotCovering() {
        assert (!this.destroyed) : "Don't use destroyed ARTElements!";
        this.mayCover = false;
    }

    public void setCovering() {
        assert (!this.destroyed) : "Don't use destroyed ARTElements!";
        this.mayCover = true;
    }

    public boolean wasExpanded() {
        return this.wasExpanded;
    }

    void markExpanded() {
        this.wasExpanded = true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.destroyed) {
            sb.append("Destroyed ");
        }
        if (this.mCoveredBy != null) {
            sb.append("Covered ");
        }
        sb.append("ART Element (Id: ");
        sb.append(this.elementId);
        if (!this.destroyed) {
            sb.append(", Parents: ");
            sb.append(this.elementIdsOf(this.parents));
            sb.append(", Children: ");
            sb.append(this.elementIdsOf(this.children));
            if (this.mCoveredBy != null) {
                sb.append(", Covered by: ");
                sb.append(this.mCoveredBy.elementId);
            } else {
                sb.append(", Covering: ");
                sb.append(this.elementIdsOf(this.getCoveredByThis()));
            }
        }
        sb.append(") ");
        sb.append(this.getWrappedElement());
        return sb.toString();
    }

    private final Iterable<Integer> elementIdsOf(Iterable<ARTElement> elements) {
        return Iterables.transform(elements, (Function)new Function<ARTElement, Integer>(){

            public Integer apply(ARTElement pInput) {
                return pInput.elementId;
            }
        });
    }

    public Set<ARTElement> getSubtree() {
        assert (!this.destroyed) : "Don't use destroyed ARTElements!";
        HashSet<ARTElement> result = new HashSet<ARTElement>();
        ArrayDeque<ARTElement> workList = new ArrayDeque<ARTElement>();
        workList.add(this);
        while (!workList.isEmpty()) {
            ARTElement currentElement = (ARTElement)workList.removeFirst();
            if (!result.add(currentElement)) continue;
            workList.addAll(currentElement.children);
        }
        return result;
    }

    public void removeFromART() {
        assert (!this.destroyed) : "Don't use destroyed ARTElements!";
        for (ARTElement child : this.children) {
            assert (child.parents.contains(this));
            child.parents.remove(this);
        }
        this.children.clear();
        for (ARTElement parent : this.parents) {
            assert (parent.children.contains(this));
            parent.children.remove(this);
        }
        this.parents.clear();
        if (this.isCovered()) {
            assert (this.mCoveredBy.mCoveredByThis.contains(this));
            this.mCoveredBy.mCoveredByThis.remove(this);
            this.mCoveredBy = null;
        }
        if (this.mCoveredByThis != null) {
            for (ARTElement covered : this.mCoveredByThis) {
                covered.mCoveredBy = null;
            }
            this.mCoveredByThis.clear();
            this.mCoveredByThis = null;
        }
        this.destroyed = true;
    }

    protected void replaceInARTWith(ARTElement replacement) {
        assert (!this.destroyed) : "Don't use destroyed ARTElements!";
        assert (!replacement.destroyed) : "Don't use destroyed ARTElements!";
        assert (!this.isCovered());
        assert (!replacement.isCovered());
        for (ARTElement child : this.children) {
            assert (child.parents.contains(this));
            child.parents.remove(this);
            child.addParent(replacement);
        }
        this.children.clear();
        for (ARTElement parent : this.parents) {
            assert (parent.children.contains(this));
            parent.children.remove(this);
            replacement.addParent(parent);
        }
        this.parents.clear();
        if (this.mCoveredByThis != null) {
            if (replacement.mCoveredByThis == null) {
                replacement.mCoveredByThis = new HashSet<ARTElement>(this.mCoveredByThis.size());
            }
            for (ARTElement covered : this.mCoveredByThis) {
                assert (covered.mCoveredBy == this);
                covered.mCoveredBy = replacement;
                replacement.mCoveredByThis.add(covered);
            }
            this.mCoveredByThis.clear();
            this.mCoveredByThis = null;
        }
        this.destroyed = true;
    }

    public int getElementId() {
        return this.elementId;
    }

    public CFAEdge getEdgeToChild(ARTElement pChild) {
        Preconditions.checkArgument((boolean)this.children.contains(pChild));
        CFANode currentLoc = AbstractElements.extractLocation(this);
        CFANode childNode = AbstractElements.extractLocation(pChild);
        return currentLoc.getEdgeTo(childNode);
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public int compareTo(ARTElement pO) {
        return Ints.compare((int)this.elementId, (int)pO.elementId);
    }

    public boolean isOlderThan(ARTElement other) {
        return this.elementId < other.elementId;
    }
}

