/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.art;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.art.ARTCPA;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.util.Precisions;

public class ARTReachedSet {
    private final ReachedSet mReached;
    private final ARTCPA mCpa;

    public ARTReachedSet(ReachedSet pReached) {
        this(pReached, null);
    }

    public ARTReachedSet(ReachedSet pReached, ARTCPA pCpa) {
        this.mReached = (ReachedSet)Preconditions.checkNotNull((Object)pReached);
        this.mCpa = pCpa;
    }

    public ReachedSet asReachedSet() {
        return this.mReached;
    }

    public void removeSubtree(ARTElement e) {
        Set<ARTElement> toWaitlist = this.removeSubtree0(e);
        for (ARTElement ae : toWaitlist) {
            this.mReached.reAddToWaitlist(ae);
        }
    }

    public void removeSubtree(ARTElement e, Precision p) {
        Set<ARTElement> toWaitlist = this.removeSubtree0(e);
        for (ARTElement ae : toWaitlist) {
            this.mReached.updatePrecision(ae, this.adaptPrecision(ae, p));
            this.mReached.reAddToWaitlist(ae);
        }
    }

    private Precision adaptPrecision(ARTElement pARTElement, Precision pNewPrecision) {
        Precision lOldPrecision = this.mReached.getPrecision(pARTElement);
        return Precisions.replaceByType(lOldPrecision, pNewPrecision, pNewPrecision.getClass());
    }

    private Set<ARTElement> removeSubtree0(ARTElement e) {
        Preconditions.checkNotNull((Object)e);
        Preconditions.checkArgument((!e.getParents().isEmpty() ? 1 : 0) != 0, (Object)"May not remove the initial element from the ART/reached set");
        Set<ARTElement> toUnreach = e.getSubtree();
        ArrayList<ARTElement> newToUnreach = new ArrayList<ARTElement>();
        for (ARTElement ae : toUnreach) {
            newToUnreach.addAll(ae.getCoveredByThis());
        }
        toUnreach.addAll(newToUnreach);
        this.mReached.removeAll(toUnreach);
        Set<ARTElement> toWaitlist = ARTReachedSet.removeSet(toUnreach);
        return toWaitlist;
    }

    private static Set<ARTElement> removeSet(Set<ARTElement> elements) {
        LinkedHashSet<ARTElement> toWaitlist = new LinkedHashSet<ARTElement>();
        for (ARTElement ae : elements) {
            for (ARTElement parent : ae.getParents()) {
                if (elements.contains(parent)) continue;
                toWaitlist.add(parent);
            }
            ae.removeFromART();
        }
        return toWaitlist;
    }

    public static class ForwardingARTReachedSet
    extends ARTReachedSet {
        protected final ARTReachedSet delegate;

        public ForwardingARTReachedSet(ARTReachedSet pReached) {
            super(pReached.mReached, pReached.mCpa);
            this.delegate = pReached;
        }

        @Override
        public ReachedSet asReachedSet() {
            return this.delegate.asReachedSet();
        }

        @Override
        public void removeSubtree(ARTElement pE) {
            this.delegate.removeSubtree(pE);
        }

        @Override
        public void removeSubtree(ARTElement pE, Precision pP) {
            this.delegate.removeSubtree(pE, pP);
        }
    }
}

