/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.art;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.Files;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.art.ARTCPA;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.cpa.art.ARTUtils;
import org.sosy_lab.cpachecker.cpa.art.ErrorPathShrinker;
import org.sosy_lab.cpachecker.cpa.art.Path;
import org.sosy_lab.cpachecker.util.cwriter.PathToCTranslator;

@Options(prefix="cpa.art")
public class ARTStatistics
implements Statistics {
    @Option(name="export", description="export final ART as .dot file")
    private boolean exportART = true;
    @Option(name="file", description="export final ART as .dot file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private File artFile = new File("ART.dot");
    @Option(name="errorPath.export", description="export error path to file, if one is found")
    private boolean exportErrorPath = true;
    @Option(name="errorPath.file", description="export error path to file, if one is found")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private File errorPathFile = new File("ErrorPath.txt");
    @Option(name="errorPath.core", description="export error path to file, if one is found")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private File errorPathCoreFile = new File("ErrorPathCore.txt");
    @Option(name="errorPath.source", description="export error path to file, if one is found")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private File errorPathSourceFile = new File("ErrorPath.c");
    @Option(name="errorPath.json", description="export error path to file, if one is found")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private File errorPathJson = new File("ErrorPath.json");
    @Option(name="errorPath.assignment", description="export one variable assignment for error path to file, if one is found")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private File errorPathAssignment = new File("ErrorPathAssignment.txt");
    @Option(name="errorPath.graph", description="export error path to file, if one is found")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private File errorPathGraphFile = new File("ErrorPath.dot");
    private final ARTCPA cpa;

    public ARTStatistics(Configuration config, ARTCPA cpa) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.cpa = cpa;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, ReachedSet pReached) {
        if (!(this.exportErrorPath && this.errorPathFile != null || this.exportART && this.artFile != null)) {
            return;
        }
        Path targetPath = null;
        if (pResult != CPAcheckerResult.Result.SAFE) {
            ARTElement lastElement;
            CounterexampleInfo counterexample = this.cpa.getLastCounterexample();
            Object assignment = null;
            if (counterexample != null) {
                targetPath = counterexample.getTargetPath();
                assignment = counterexample.getTargetPathAssignment();
            }
            if (targetPath == null && (lastElement = (ARTElement)pReached.getLastElement()) != null && lastElement.isTarget()) {
                targetPath = ARTUtils.getOnePathTo(lastElement);
            }
            if (targetPath != null && this.exportErrorPath && this.errorPathFile != null) {
                String pathProgram;
                Object pathElements;
                ErrorPathShrinker pathShrinker = new ErrorPathShrinker();
                Path shrinkedErrorPath = pathShrinker.shrinkErrorPath(targetPath);
                ARTElement rootElement = (ARTElement)((Pair)targetPath.getFirst()).getFirst();
                if (counterexample != null && counterexample.getTargetPath() != null) {
                    pathElements = targetPath.getElementSet();
                    pathProgram = PathToCTranslator.translateSinglePath(targetPath);
                } else {
                    ARTElement lastElement2 = (ARTElement)pReached.getLastElement();
                    pathElements = ARTUtils.getAllElementsOnPathsTo(lastElement2);
                    pathProgram = PathToCTranslator.translatePaths(rootElement, pathElements);
                }
                this.writeErrorPathFile(this.errorPathFile, targetPath);
                this.writeErrorPathFile(this.errorPathCoreFile, shrinkedErrorPath);
                this.writeErrorPathFile(this.errorPathSourceFile, pathProgram);
                this.writeErrorPathFile(this.errorPathJson, targetPath.toJSON());
                this.writeErrorPathFile(this.errorPathGraphFile, ARTUtils.convertARTToDot(rootElement, pathElements, ARTStatistics.getEdgesOfPath(targetPath)));
                if (assignment != null) {
                    this.writeErrorPathFile(this.errorPathAssignment, assignment);
                }
                if (counterexample != null) {
                    for (Pair<Object, File> info : counterexample.getAllFurtherInformation()) {
                        this.writeErrorPathFile((File)info.getSecond(), info.getFirst());
                    }
                }
            }
        }
        if (this.exportART && this.artFile != null) {
            try {
                ARTElement rootElement = (ARTElement)pReached.getFirstElement();
                Files.writeFile((File)this.artFile, (Object)ARTUtils.convertARTToDot(rootElement, null, ARTStatistics.getEdgesOfPath(targetPath)));
            }
            catch (IOException e) {
                this.cpa.getLogger().logUserException(Level.WARNING, (Throwable)e, "Could not write ART to file.");
            }
        }
    }

    private void writeErrorPathFile(File file, Object content) {
        if (file != null) {
            try {
                Files.writeFile((File)file, (Object)content);
            }
            catch (IOException e) {
                this.cpa.getLogger().logUserException(Level.WARNING, (Throwable)e, "Could not write information about the error path to file.");
            }
        }
    }

    private static Set<Pair<ARTElement, ARTElement>> getEdgesOfPath(Path pPath) {
        if (pPath == null) {
            return Collections.emptySet();
        }
        HashSet<Pair<ARTElement, ARTElement>> result = new HashSet<Pair<ARTElement, ARTElement>>(pPath.size());
        Iterator it = pPath.iterator();
        assert (it.hasNext());
        ARTElement lastElement = (ARTElement)((Pair)it.next()).getFirst();
        while (it.hasNext()) {
            ARTElement currentElement = (ARTElement)((Pair)it.next()).getFirst();
            result.add((Pair<ARTElement, ARTElement>)Pair.of((Object)lastElement, (Object)currentElement));
            lastElement = currentElement;
        }
        return result;
    }
}

