/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.art;

import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.ProofChecker;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.exceptions.CPAException;

@Options(prefix="cpa.art")
public class ARTStopSep
implements StopOperator {
    @Option(description="whether to keep covered states in the reached set as addition to keeping them in the ART")
    private boolean keepCoveredStatesInReached = false;
    private final StopOperator wrappedStop;
    private final LogManager logger;

    public ARTStopSep(StopOperator pWrappedStop, LogManager pLogger, Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.wrappedStop = pWrappedStop;
        this.logger = pLogger;
    }

    @Override
    public boolean stop(AbstractElement pElement, Collection<AbstractElement> pReached, Precision pPrecision) throws CPAException {
        ARTElement artElement = (ARTElement)pElement;
        assert (!artElement.isCovered());
        if (artElement.getMergedWith() != null) {
            ARTElement mergedWith = artElement.getMergedWith();
            if (pReached.contains(mergedWith)) {
                if (this.wrappedStop.stop(artElement.getWrappedElement(), Collections.singleton(mergedWith.getWrappedElement()), pPrecision)) {
                    artElement.removeFromART();
                    this.logger.log(Level.FINEST, new Object[]{"Element is covered by the element it was merged into"});
                    return true;
                }
                this.logger.log(Level.FINEST, new Object[]{"Element was merged but not covered:", pElement});
            } else {
                this.logger.log(Level.FINEST, new Object[]{"Element was merged into an element that's not in the reached set, merged-with element is", mergedWith});
            }
        }
        for (AbstractElement reachedElement : pReached) {
            ARTElement artReachedElement = (ARTElement)reachedElement;
            if (!this.stop(artElement, artReachedElement, pPrecision)) continue;
            return !this.keepCoveredStatesInReached;
        }
        return false;
    }

    private boolean stop(ARTElement pElement, ARTElement pReachedElement, Precision pPrecision) throws CPAException {
        AbstractElement wrappedReachedElement;
        if (!pReachedElement.mayCover()) {
            return false;
        }
        if (pElement == pReachedElement) {
            return false;
        }
        if (pElement.isOlderThan(pReachedElement)) {
            return false;
        }
        AbstractElement wrappedElement = pElement.getWrappedElement();
        boolean stop = this.wrappedStop.stop(wrappedElement, Collections.singleton(wrappedReachedElement = pReachedElement.getWrappedElement()), pPrecision);
        if (stop) {
            pElement.setCovered(pReachedElement);
        }
        return stop;
    }

    boolean isCoveredBy(AbstractElement pElement, AbstractElement pOtherElement, ProofChecker wrappedProofChecker) throws CPAException {
        ARTElement artElement = (ARTElement)pElement;
        ARTElement otherArtElement = (ARTElement)pOtherElement;
        AbstractElement wrappedElement = artElement.getWrappedElement();
        AbstractElement wrappedOtherElement = otherArtElement.getWrappedElement();
        return wrappedProofChecker.isCoveredBy(wrappedElement, wrappedOtherElement);
    }
}

